/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Description of the CloudWatch logging option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLoggingOptionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLoggingOptionDescription.Builder, CloudWatchLoggingOptionDescription> {
    private static final SdkField<String> CLOUD_WATCH_LOGGING_OPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLoggingOptionId")
            .getter(getter(CloudWatchLoggingOptionDescription::cloudWatchLoggingOptionId))
            .setter(setter(Builder::cloudWatchLoggingOptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionId").build())
            .build();

    private static final SdkField<String> LOG_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStreamARN").getter(getter(CloudWatchLoggingOptionDescription::logStreamARN))
            .setter(setter(Builder::logStreamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamARN").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(CloudWatchLoggingOptionDescription::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGGING_OPTION_ID_FIELD, LOG_STREAM_ARN_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLoggingOptionId;

    private final String logStreamARN;

    private final String roleARN;

    private CloudWatchLoggingOptionDescription(BuilderImpl builder) {
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.logStreamARN = builder.logStreamARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * ID of the CloudWatch logging option description.
     * </p>
     * 
     * @return ID of the CloudWatch logging option description.
     */
    public final String cloudWatchLoggingOptionId() {
        return cloudWatchLoggingOptionId;
    }

    /**
     * <p>
     * ARN of the CloudWatch log to receive application messages.
     * </p>
     * 
     * @return ARN of the CloudWatch log to receive application messages.
     */
    public final String logStreamARN() {
        return logStreamARN;
    }

    /**
     * <p>
     * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the
     * IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     * </p>
     * 
     * @return IAM ARN of the role to use to send application messages. Note: To write application messages to
     *         CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     */
    public final String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptionDescription)) {
            return false;
        }
        CloudWatchLoggingOptionDescription other = (CloudWatchLoggingOptionDescription) obj;
        return Objects.equals(cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId())
                && Objects.equals(logStreamARN(), other.logStreamARN()) && Objects.equals(roleARN(), other.roleARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLoggingOptionDescription")
                .add("CloudWatchLoggingOptionId", cloudWatchLoggingOptionId()).add("LogStreamARN", logStreamARN())
                .add("RoleARN", roleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLoggingOptionId":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionId()));
        case "LogStreamARN":
            return Optional.ofNullable(clazz.cast(logStreamARN()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLoggingOptionId", CLOUD_WATCH_LOGGING_OPTION_ID_FIELD);
        map.put("LogStreamARN", LOG_STREAM_ARN_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOptionDescription, T> g) {
        return obj -> g.apply((CloudWatchLoggingOptionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLoggingOptionDescription> {
        /**
         * <p>
         * ID of the CloudWatch logging option description.
         * </p>
         * 
         * @param cloudWatchLoggingOptionId
         *        ID of the CloudWatch logging option description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId);

        /**
         * <p>
         * ARN of the CloudWatch log to receive application messages.
         * </p>
         * 
         * @param logStreamARN
         *        ARN of the CloudWatch log to receive application messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamARN(String logStreamARN);

        /**
         * <p>
         * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch,
         * the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * </p>
         * 
         * @param roleARN
         *        IAM ARN of the role to use to send application messages. Note: To write application messages to
         *        CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLoggingOptionId;

        private String logStreamARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptionDescription model) {
            cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            logStreamARN(model.logStreamARN);
            roleARN(model.roleARN);
        }

        public final String getCloudWatchLoggingOptionId() {
            return cloudWatchLoggingOptionId;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final String getLogStreamARN() {
            return logStreamARN;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        @Override
        public CloudWatchLoggingOptionDescription build() {
            return new CloudWatchLoggingOptionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
