/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationDetail> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(ApplicationDetail.getter(ApplicationDetail::applicationName)).setter(ApplicationDetail.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationDescription").getter(ApplicationDetail.getter(ApplicationDetail::applicationDescription)).setter(ApplicationDetail.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(ApplicationDetail.getter(ApplicationDetail::applicationARN)).setter(ApplicationDetail.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationStatus").getter(ApplicationDetail.getter(ApplicationDetail::applicationStatusAsString)).setter(ApplicationDetail.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTimestamp").getter(ApplicationDetail.getter(ApplicationDetail::createTimestamp)).setter(ApplicationDetail.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(ApplicationDetail.getter(ApplicationDetail::lastUpdateTimestamp)).setter(ApplicationDetail.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<List<InputDescription>> INPUT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDescriptions").getter(ApplicationDetail.getter(ApplicationDetail::inputDescriptions)).setter(ApplicationDetail.setter(Builder::inputDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputDescription>> OUTPUT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputDescriptions").getter(ApplicationDetail.getter(ApplicationDetail::outputDescriptions)).setter(ApplicationDetail.setter(Builder::outputDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReferenceDataSourceDescription>> REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceDataSourceDescriptions").getter(ApplicationDetail.getter(ApplicationDetail::referenceDataSourceDescriptions)).setter(ApplicationDetail.setter(Builder::referenceDataSourceDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceDataSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchLoggingOptionDescriptions").getter(ApplicationDetail.getter(ApplicationDetail::cloudWatchLoggingOptionDescriptions)).setter(ApplicationDetail.setter(Builder::cloudWatchLoggingOptionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationCode").getter(ApplicationDetail.getter(ApplicationDetail::applicationCode)).setter(ApplicationDetail.setter(Builder::applicationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCode").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionId)).setter(ApplicationDetail.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_ARN_FIELD, APPLICATION_STATUS_FIELD, CREATE_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, INPUT_DESCRIPTIONS_FIELD, OUTPUT_DESCRIPTIONS_FIELD, REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD, APPLICATION_CODE_FIELD, APPLICATION_VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String applicationDescription;
    private final String applicationARN;
    private final String applicationStatus;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final List<InputDescription> inputDescriptions;
    private final List<OutputDescription> outputDescriptions;
    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;
    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;
    private final String applicationCode;
    private final Long applicationVersionId;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.inputDescriptions = builder.inputDescriptions;
        this.outputDescriptions = builder.outputDescriptions;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
        this.applicationCode = builder.applicationCode;
        this.applicationVersionId = builder.applicationVersionId;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String applicationDescription() {
        return this.applicationDescription;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public final String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public final Instant createTimestamp() {
        return this.createTimestamp;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public final boolean hasInputDescriptions() {
        return this.inputDescriptions != null && !(this.inputDescriptions instanceof SdkAutoConstructList);
    }

    public final List<InputDescription> inputDescriptions() {
        return this.inputDescriptions;
    }

    public final boolean hasOutputDescriptions() {
        return this.outputDescriptions != null && !(this.outputDescriptions instanceof SdkAutoConstructList);
    }

    public final List<OutputDescription> outputDescriptions() {
        return this.outputDescriptions;
    }

    public final boolean hasReferenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions != null && !(this.referenceDataSourceDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions;
    }

    public final boolean hasCloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions != null && !(this.cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions;
    }

    public final String applicationCode() {
        return this.applicationCode;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDescriptions() ? this.inputDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputDescriptions() ? this.outputDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceDataSourceDescriptions() ? this.referenceDataSourceDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchLoggingOptionDescriptions() ? this.cloudWatchLoggingOptionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && this.hasInputDescriptions() == other.hasInputDescriptions() && Objects.equals(this.inputDescriptions(), other.inputDescriptions()) && this.hasOutputDescriptions() == other.hasOutputDescriptions() && Objects.equals(this.outputDescriptions(), other.outputDescriptions()) && this.hasReferenceDataSourceDescriptions() == other.hasReferenceDataSourceDescriptions() && Objects.equals(this.referenceDataSourceDescriptions(), other.referenceDataSourceDescriptions()) && this.hasCloudWatchLoggingOptionDescriptions() == other.hasCloudWatchLoggingOptionDescriptions() && Objects.equals(this.cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions()) && Objects.equals(this.applicationCode(), other.applicationCode()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationDetail").add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("CreateTimestamp", (Object)this.createTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("InputDescriptions", this.hasInputDescriptions() ? this.inputDescriptions() : null).add("OutputDescriptions", this.hasOutputDescriptions() ? this.outputDescriptions() : null).add("ReferenceDataSourceDescriptions", this.hasReferenceDataSourceDescriptions() ? this.referenceDataSourceDescriptions() : null).add("CloudWatchLoggingOptionDescriptions", this.hasCloudWatchLoggingOptionDescriptions() ? this.cloudWatchLoggingOptionDescriptions() : null).add("ApplicationCode", (Object)this.applicationCode()).add("ApplicationVersionId", (Object)this.applicationVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ApplicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "InputDescriptions": {
                return Optional.ofNullable(clazz.cast(this.inputDescriptions()));
            }
            case "OutputDescriptions": {
                return Optional.ofNullable(clazz.cast(this.outputDescriptions()));
            }
            case "ReferenceDataSourceDescriptions": {
                return Optional.ofNullable(clazz.cast(this.referenceDataSourceDescriptions()));
            }
            case "CloudWatchLoggingOptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionDescriptions()));
            }
            case "ApplicationCode": {
                return Optional.ofNullable(clazz.cast(this.applicationCode()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("ApplicationDescription", APPLICATION_DESCRIPTION_FIELD);
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationStatus", APPLICATION_STATUS_FIELD);
        map.put("CreateTimestamp", CREATE_TIMESTAMP_FIELD);
        map.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        map.put("InputDescriptions", INPUT_DESCRIPTIONS_FIELD);
        map.put("OutputDescriptions", OUTPUT_DESCRIPTIONS_FIELD);
        map.put("ReferenceDataSourceDescriptions", REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD);
        map.put("CloudWatchLoggingOptionDescriptions", CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD);
        map.put("ApplicationCode", APPLICATION_CODE_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDetail, T> g) {
        return obj -> g.apply((ApplicationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private String applicationARN;
        private String applicationStatus;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private List<InputDescription> inputDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<OutputDescription> outputDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String applicationCode;
        private Long applicationVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.applicationARN(model.applicationARN);
            this.applicationStatus(model.applicationStatus);
            this.createTimestamp(model.createTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.inputDescriptions(model.inputDescriptions);
            this.outputDescriptions(model.outputDescriptions);
            this.referenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
            this.cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
            this.applicationCode(model.applicationCode);
            this.applicationVersionId(model.applicationVersionId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final List<InputDescription.Builder> getInputDescriptions() {
            List<InputDescription.Builder> result = InputDescriptionsCopier.copyToBuilder(this.inputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDescriptions(Collection<InputDescription.BuilderImpl> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copyFromBuilder(inputDescriptions);
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription ... inputDescriptions) {
            this.inputDescriptions(Arrays.asList(inputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(Consumer<InputDescription.Builder> ... inputDescriptions) {
            this.inputDescriptions(Stream.of(inputDescriptions).map(c -> (InputDescription)((InputDescription.Builder)InputDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputDescription.Builder> getOutputDescriptions() {
            List<OutputDescription.Builder> result = OutputDescriptionsCopier.copyToBuilder(this.outputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputDescriptions(Collection<OutputDescription.BuilderImpl> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copyFromBuilder(outputDescriptions);
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription ... outputDescriptions) {
            this.outputDescriptions(Arrays.asList(outputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(Consumer<OutputDescription.Builder> ... outputDescriptions) {
            this.outputDescriptions(Stream.of(outputDescriptions).map(c -> (OutputDescription)((OutputDescription.Builder)OutputDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReferenceDataSourceDescription.Builder> getReferenceDataSourceDescriptions() {
            List<ReferenceDataSourceDescription.Builder> result = ReferenceDataSourceDescriptionsCopier.copyToBuilder(this.referenceDataSourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription.BuilderImpl> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copyFromBuilder(referenceDataSourceDescriptions);
        }

        @Override
        public final Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Arrays.asList(referenceDataSourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Stream.of(referenceDataSourceDescriptions).map(c -> (ReferenceDataSourceDescription)((ReferenceDataSourceDescription.Builder)ReferenceDataSourceDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            List<CloudWatchLoggingOptionDescription.Builder> result = CloudWatchLoggingOptionDescriptionsCopier.copyToBuilder(this.cloudWatchLoggingOptionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions).map(c -> (CloudWatchLoggingOptionDescription)((CloudWatchLoggingOptionDescription.Builder)CloudWatchLoggingOptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationDetail> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationARN(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder inputDescriptions(Collection<InputDescription> var1);

        public Builder inputDescriptions(InputDescription ... var1);

        public Builder inputDescriptions(Consumer<InputDescription.Builder> ... var1);

        public Builder outputDescriptions(Collection<OutputDescription> var1);

        public Builder outputDescriptions(OutputDescription ... var1);

        public Builder outputDescriptions(Consumer<OutputDescription.Builder> ... var1);

        public Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> var1);

        public Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... var1);

        public Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> var1);

        public Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... var1);

        public Builder applicationCode(String var1);

        public Builder applicationVersionId(Long var1);
    }
}

