/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to a specific input configuration (identified by the <code>InputId</code> of an application).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputUpdate implements SdkPojo, Serializable, ToCopyableBuilder<InputUpdate.Builder, InputUpdate> {
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(InputUpdate::inputId)).setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()).build();

    private static final SdkField<String> NAME_PREFIX_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefixUpdate").getter(getter(InputUpdate::namePrefixUpdate))
            .setter(setter(Builder::namePrefixUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefixUpdate").build()).build();

    private static final SdkField<InputProcessingConfigurationUpdate> INPUT_PROCESSING_CONFIGURATION_UPDATE_FIELD = SdkField
            .<InputProcessingConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("InputProcessingConfigurationUpdate")
            .getter(getter(InputUpdate::inputProcessingConfigurationUpdate))
            .setter(setter(Builder::inputProcessingConfigurationUpdate))
            .constructor(InputProcessingConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfigurationUpdate")
                    .build()).build();

    private static final SdkField<KinesisStreamsInputUpdate> KINESIS_STREAMS_INPUT_UPDATE_FIELD = SdkField
            .<KinesisStreamsInputUpdate> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamsInputUpdate")
            .getter(getter(InputUpdate::kinesisStreamsInputUpdate)).setter(setter(Builder::kinesisStreamsInputUpdate))
            .constructor(KinesisStreamsInputUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsInputUpdate").build())
            .build();

    private static final SdkField<KinesisFirehoseInputUpdate> KINESIS_FIREHOSE_INPUT_UPDATE_FIELD = SdkField
            .<KinesisFirehoseInputUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisFirehoseInputUpdate")
            .getter(getter(InputUpdate::kinesisFirehoseInputUpdate))
            .setter(setter(Builder::kinesisFirehoseInputUpdate))
            .constructor(KinesisFirehoseInputUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseInputUpdate").build())
            .build();

    private static final SdkField<InputSchemaUpdate> INPUT_SCHEMA_UPDATE_FIELD = SdkField
            .<InputSchemaUpdate> builder(MarshallingType.SDK_POJO).memberName("InputSchemaUpdate")
            .getter(getter(InputUpdate::inputSchemaUpdate)).setter(setter(Builder::inputSchemaUpdate))
            .constructor(InputSchemaUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSchemaUpdate").build()).build();

    private static final SdkField<InputParallelismUpdate> INPUT_PARALLELISM_UPDATE_FIELD = SdkField
            .<InputParallelismUpdate> builder(MarshallingType.SDK_POJO).memberName("InputParallelismUpdate")
            .getter(getter(InputUpdate::inputParallelismUpdate)).setter(setter(Builder::inputParallelismUpdate))
            .constructor(InputParallelismUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParallelismUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ID_FIELD,
            NAME_PREFIX_UPDATE_FIELD, INPUT_PROCESSING_CONFIGURATION_UPDATE_FIELD, KINESIS_STREAMS_INPUT_UPDATE_FIELD,
            KINESIS_FIREHOSE_INPUT_UPDATE_FIELD, INPUT_SCHEMA_UPDATE_FIELD, INPUT_PARALLELISM_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputId;

    private final String namePrefixUpdate;

    private final InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate;

    private final KinesisStreamsInputUpdate kinesisStreamsInputUpdate;

    private final KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;

    private final InputSchemaUpdate inputSchemaUpdate;

    private final InputParallelismUpdate inputParallelismUpdate;

    private InputUpdate(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefixUpdate = builder.namePrefixUpdate;
        this.inputProcessingConfigurationUpdate = builder.inputProcessingConfigurationUpdate;
        this.kinesisStreamsInputUpdate = builder.kinesisStreamsInputUpdate;
        this.kinesisFirehoseInputUpdate = builder.kinesisFirehoseInputUpdate;
        this.inputSchemaUpdate = builder.inputSchemaUpdate;
        this.inputParallelismUpdate = builder.inputParallelismUpdate;
    }

    /**
     * <p>
     * Input ID of the application input to be updated.
     * </p>
     * 
     * @return Input ID of the application input to be updated.
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * <p>
     * Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming source.
     * </p>
     * 
     * @return Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming
     *         source.
     */
    public final String namePrefixUpdate() {
        return namePrefixUpdate;
    }

    /**
     * <p>
     * Describes updates for an input processing configuration.
     * </p>
     * 
     * @return Describes updates for an input processing configuration.
     */
    public final InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate() {
        return inputProcessingConfigurationUpdate;
    }

    /**
     * <p>
     * If an Amazon Kinesis stream is the streaming source to be updated, provides an updated stream Amazon Resource
     * Name (ARN) and IAM role ARN.
     * </p>
     * 
     * @return If an Amazon Kinesis stream is the streaming source to be updated, provides an updated stream Amazon
     *         Resource Name (ARN) and IAM role ARN.
     */
    public final KinesisStreamsInputUpdate kinesisStreamsInputUpdate() {
        return kinesisStreamsInputUpdate;
    }

    /**
     * <p>
     * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated stream
     * ARN and IAM role ARN.
     * </p>
     * 
     * @return If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
     *         stream ARN and IAM role ARN.
     */
    public final KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate() {
        return kinesisFirehoseInputUpdate;
    }

    /**
     * <p>
     * Describes the data format on the streaming source, and how record elements on the streaming source map to columns
     * of the in-application stream that is created.
     * </p>
     * 
     * @return Describes the data format on the streaming source, and how record elements on the streaming source map to
     *         columns of the in-application stream that is created.
     */
    public final InputSchemaUpdate inputSchemaUpdate() {
        return inputSchemaUpdate;
    }

    /**
     * <p>
     * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
     * specific streaming source).
     * </p>
     * 
     * @return Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for
     *         the specific streaming source).
     */
    public final InputParallelismUpdate inputParallelismUpdate() {
        return inputParallelismUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(namePrefixUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsInputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseInputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchemaUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(inputParallelismUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputUpdate)) {
            return false;
        }
        InputUpdate other = (InputUpdate) obj;
        return Objects.equals(inputId(), other.inputId()) && Objects.equals(namePrefixUpdate(), other.namePrefixUpdate())
                && Objects.equals(inputProcessingConfigurationUpdate(), other.inputProcessingConfigurationUpdate())
                && Objects.equals(kinesisStreamsInputUpdate(), other.kinesisStreamsInputUpdate())
                && Objects.equals(kinesisFirehoseInputUpdate(), other.kinesisFirehoseInputUpdate())
                && Objects.equals(inputSchemaUpdate(), other.inputSchemaUpdate())
                && Objects.equals(inputParallelismUpdate(), other.inputParallelismUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputUpdate").add("InputId", inputId()).add("NamePrefixUpdate", namePrefixUpdate())
                .add("InputProcessingConfigurationUpdate", inputProcessingConfigurationUpdate())
                .add("KinesisStreamsInputUpdate", kinesisStreamsInputUpdate())
                .add("KinesisFirehoseInputUpdate", kinesisFirehoseInputUpdate()).add("InputSchemaUpdate", inputSchemaUpdate())
                .add("InputParallelismUpdate", inputParallelismUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "NamePrefixUpdate":
            return Optional.ofNullable(clazz.cast(namePrefixUpdate()));
        case "InputProcessingConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(inputProcessingConfigurationUpdate()));
        case "KinesisStreamsInputUpdate":
            return Optional.ofNullable(clazz.cast(kinesisStreamsInputUpdate()));
        case "KinesisFirehoseInputUpdate":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseInputUpdate()));
        case "InputSchemaUpdate":
            return Optional.ofNullable(clazz.cast(inputSchemaUpdate()));
        case "InputParallelismUpdate":
            return Optional.ofNullable(clazz.cast(inputParallelismUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InputId", INPUT_ID_FIELD);
        map.put("NamePrefixUpdate", NAME_PREFIX_UPDATE_FIELD);
        map.put("InputProcessingConfigurationUpdate", INPUT_PROCESSING_CONFIGURATION_UPDATE_FIELD);
        map.put("KinesisStreamsInputUpdate", KINESIS_STREAMS_INPUT_UPDATE_FIELD);
        map.put("KinesisFirehoseInputUpdate", KINESIS_FIREHOSE_INPUT_UPDATE_FIELD);
        map.put("InputSchemaUpdate", INPUT_SCHEMA_UPDATE_FIELD);
        map.put("InputParallelismUpdate", INPUT_PARALLELISM_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputUpdate, T> g) {
        return obj -> g.apply((InputUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputUpdate> {
        /**
         * <p>
         * Input ID of the application input to be updated.
         * </p>
         * 
         * @param inputId
         *        Input ID of the application input to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming
         * source.
         * </p>
         * 
         * @param namePrefixUpdate
         *        Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific
         *        streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefixUpdate(String namePrefixUpdate);

        /**
         * <p>
         * Describes updates for an input processing configuration.
         * </p>
         * 
         * @param inputProcessingConfigurationUpdate
         *        Describes updates for an input processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate);

        /**
         * <p>
         * Describes updates for an input processing configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InputProcessingConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link InputProcessingConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputProcessingConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate)}.
         * 
         * @param inputProcessingConfigurationUpdate
         *        a consumer that will call methods on {@link InputProcessingConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate)
         */
        default Builder inputProcessingConfigurationUpdate(
                Consumer<InputProcessingConfigurationUpdate.Builder> inputProcessingConfigurationUpdate) {
            return inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate.builder()
                    .applyMutation(inputProcessingConfigurationUpdate).build());
        }

        /**
         * <p>
         * If an Amazon Kinesis stream is the streaming source to be updated, provides an updated stream Amazon Resource
         * Name (ARN) and IAM role ARN.
         * </p>
         * 
         * @param kinesisStreamsInputUpdate
         *        If an Amazon Kinesis stream is the streaming source to be updated, provides an updated stream Amazon
         *        Resource Name (ARN) and IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate);

        /**
         * <p>
         * If an Amazon Kinesis stream is the streaming source to be updated, provides an updated stream Amazon Resource
         * Name (ARN) and IAM role ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamsInputUpdate.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamsInputUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisStreamsInputUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisStreamsInputUpdate(KinesisStreamsInputUpdate)}.
         * 
         * @param kinesisStreamsInputUpdate
         *        a consumer that will call methods on {@link KinesisStreamsInputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsInputUpdate(KinesisStreamsInputUpdate)
         */
        default Builder kinesisStreamsInputUpdate(Consumer<KinesisStreamsInputUpdate.Builder> kinesisStreamsInputUpdate) {
            return kinesisStreamsInputUpdate(KinesisStreamsInputUpdate.builder().applyMutation(kinesisStreamsInputUpdate).build());
        }

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
         * stream ARN and IAM role ARN.
         * </p>
         * 
         * @param kinesisFirehoseInputUpdate
         *        If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an
         *        updated stream ARN and IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate);

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
         * stream ARN and IAM role ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisFirehoseInputUpdate.Builder}
         * avoiding the need to create one manually via {@link KinesisFirehoseInputUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisFirehoseInputUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate)}.
         * 
         * @param kinesisFirehoseInputUpdate
         *        a consumer that will call methods on {@link KinesisFirehoseInputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate)
         */
        default Builder kinesisFirehoseInputUpdate(Consumer<KinesisFirehoseInputUpdate.Builder> kinesisFirehoseInputUpdate) {
            return kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate.builder().applyMutation(kinesisFirehoseInputUpdate)
                    .build());
        }

        /**
         * <p>
         * Describes the data format on the streaming source, and how record elements on the streaming source map to
         * columns of the in-application stream that is created.
         * </p>
         * 
         * @param inputSchemaUpdate
         *        Describes the data format on the streaming source, and how record elements on the streaming source map
         *        to columns of the in-application stream that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate);

        /**
         * <p>
         * Describes the data format on the streaming source, and how record elements on the streaming source map to
         * columns of the in-application stream that is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputSchemaUpdate.Builder} avoiding the
         * need to create one manually via {@link InputSchemaUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSchemaUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchemaUpdate(InputSchemaUpdate)}.
         * 
         * @param inputSchemaUpdate
         *        a consumer that will call methods on {@link InputSchemaUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchemaUpdate(InputSchemaUpdate)
         */
        default Builder inputSchemaUpdate(Consumer<InputSchemaUpdate.Builder> inputSchemaUpdate) {
            return inputSchemaUpdate(InputSchemaUpdate.builder().applyMutation(inputSchemaUpdate).build());
        }

        /**
         * <p>
         * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
         * specific streaming source).
         * </p>
         * 
         * @param inputParallelismUpdate
         *        Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates
         *        for the specific streaming source).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate);

        /**
         * <p>
         * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
         * specific streaming source).
         * </p>
         * This is a convenience method that creates an instance of the {@link InputParallelismUpdate.Builder} avoiding
         * the need to create one manually via {@link InputParallelismUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputParallelismUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #inputParallelismUpdate(InputParallelismUpdate)}.
         * 
         * @param inputParallelismUpdate
         *        a consumer that will call methods on {@link InputParallelismUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputParallelismUpdate(InputParallelismUpdate)
         */
        default Builder inputParallelismUpdate(Consumer<InputParallelismUpdate.Builder> inputParallelismUpdate) {
            return inputParallelismUpdate(InputParallelismUpdate.builder().applyMutation(inputParallelismUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputId;

        private String namePrefixUpdate;

        private InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate;

        private KinesisStreamsInputUpdate kinesisStreamsInputUpdate;

        private KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;

        private InputSchemaUpdate inputSchemaUpdate;

        private InputParallelismUpdate inputParallelismUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputUpdate model) {
            inputId(model.inputId);
            namePrefixUpdate(model.namePrefixUpdate);
            inputProcessingConfigurationUpdate(model.inputProcessingConfigurationUpdate);
            kinesisStreamsInputUpdate(model.kinesisStreamsInputUpdate);
            kinesisFirehoseInputUpdate(model.kinesisFirehoseInputUpdate);
            inputSchemaUpdate(model.inputSchemaUpdate);
            inputParallelismUpdate(model.inputParallelismUpdate);
        }

        public final String getInputId() {
            return inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final String getNamePrefixUpdate() {
            return namePrefixUpdate;
        }

        public final void setNamePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
        }

        @Override
        public final Builder namePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
            return this;
        }

        public final InputProcessingConfigurationUpdate.Builder getInputProcessingConfigurationUpdate() {
            return inputProcessingConfigurationUpdate != null ? inputProcessingConfigurationUpdate.toBuilder() : null;
        }

        public final void setInputProcessingConfigurationUpdate(
                InputProcessingConfigurationUpdate.BuilderImpl inputProcessingConfigurationUpdate) {
            this.inputProcessingConfigurationUpdate = inputProcessingConfigurationUpdate != null ? inputProcessingConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationUpdate(
                InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate) {
            this.inputProcessingConfigurationUpdate = inputProcessingConfigurationUpdate;
            return this;
        }

        public final KinesisStreamsInputUpdate.Builder getKinesisStreamsInputUpdate() {
            return kinesisStreamsInputUpdate != null ? kinesisStreamsInputUpdate.toBuilder() : null;
        }

        public final void setKinesisStreamsInputUpdate(KinesisStreamsInputUpdate.BuilderImpl kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate != null ? kinesisStreamsInputUpdate.build() : null;
        }

        @Override
        public final Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
            return this;
        }

        public final KinesisFirehoseInputUpdate.Builder getKinesisFirehoseInputUpdate() {
            return kinesisFirehoseInputUpdate != null ? kinesisFirehoseInputUpdate.toBuilder() : null;
        }

        public final void setKinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate.BuilderImpl kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate != null ? kinesisFirehoseInputUpdate.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
            return this;
        }

        public final InputSchemaUpdate.Builder getInputSchemaUpdate() {
            return inputSchemaUpdate != null ? inputSchemaUpdate.toBuilder() : null;
        }

        public final void setInputSchemaUpdate(InputSchemaUpdate.BuilderImpl inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate != null ? inputSchemaUpdate.build() : null;
        }

        @Override
        public final Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
            return this;
        }

        public final InputParallelismUpdate.Builder getInputParallelismUpdate() {
            return inputParallelismUpdate != null ? inputParallelismUpdate.toBuilder() : null;
        }

        public final void setInputParallelismUpdate(InputParallelismUpdate.BuilderImpl inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate != null ? inputParallelismUpdate.build() : null;
        }

        @Override
        public final Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
            return this;
        }

        @Override
        public InputUpdate build() {
            return new InputUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
