/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2Client;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeValidationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidApplicationConfigurationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidRequestException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Exception;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.LimitExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TooManyTagsException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnableToDetectSchemaException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationInputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DiscoverInputSchemaRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.StartApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.StopApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UpdateApplicationRequestMarshaller;

@SdkInternalApi
final class DefaultKinesisAnalyticsV2Client
implements KinesisAnalyticsV2Client {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisAnalyticsV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kinesisanalytics";
    }

    @Override
    public AddApplicationCloudWatchLoggingOptionResponse addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationCloudWatchLoggingOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddApplicationCloudWatchLoggingOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationCloudWatchLoggingOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationCloudWatchLoggingOptionRequest).withMarshaller((Marshaller)new AddApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddApplicationInputResponse addApplicationInput(AddApplicationInputRequest addApplicationInputRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, CodeValidationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddApplicationInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationInputRequest).withMarshaller((Marshaller)new AddApplicationInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddApplicationInputProcessingConfigurationResponse addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputProcessingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddApplicationInputProcessingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInputProcessingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationInputProcessingConfigurationRequest).withMarshaller((Marshaller)new AddApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddApplicationOutputResponse addApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddApplicationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationOutputRequest).withMarshaller((Marshaller)new AddApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddApplicationReferenceDataSourceResponse addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationReferenceDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddApplicationReferenceDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationReferenceDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationReferenceDataSourceRequest).withMarshaller((Marshaller)new AddApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws CodeValidationException, ResourceInUseException, LimitExceededException, InvalidArgumentException, InvalidRequestException, TooManyTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationRequest).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateApplicationSnapshotResponse createApplicationSnapshot(CreateApplicationSnapshotRequest createApplicationSnapshotRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, UnsupportedOperationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateApplicationSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationSnapshotRequest).withMarshaller((Marshaller)new CreateApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws ConcurrentModificationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationRequest).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteApplicationCloudWatchLoggingOptionResponse deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationCloudWatchLoggingOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteApplicationCloudWatchLoggingOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationCloudWatchLoggingOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationCloudWatchLoggingOptionRequest).withMarshaller((Marshaller)new DeleteApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteApplicationInputProcessingConfigurationResponse deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationInputProcessingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteApplicationInputProcessingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationInputProcessingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationInputProcessingConfigurationRequest).withMarshaller((Marshaller)new DeleteApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteApplicationOutputResponse deleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteApplicationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationOutputRequest).withMarshaller((Marshaller)new DeleteApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteApplicationReferenceDataSourceResponse deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationReferenceDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteApplicationReferenceDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationReferenceDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationReferenceDataSourceRequest).withMarshaller((Marshaller)new DeleteApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteApplicationSnapshotResponse deleteApplicationSnapshot(DeleteApplicationSnapshotRequest deleteApplicationSnapshotRequest) throws ResourceInUseException, InvalidArgumentException, UnsupportedOperationException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteApplicationSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationSnapshotRequest).withMarshaller((Marshaller)new DeleteApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeApplicationResponse describeApplication(DescribeApplicationRequest describeApplicationRequest) throws ResourceNotFoundException, InvalidArgumentException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationRequest).withMarshaller((Marshaller)new DescribeApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeApplicationSnapshotResponse describeApplicationSnapshot(DescribeApplicationSnapshotRequest describeApplicationSnapshotRequest) throws ResourceNotFoundException, InvalidArgumentException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeApplicationSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationSnapshotRequest).withMarshaller((Marshaller)new DescribeApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DiscoverInputSchemaResponse discoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest) throws InvalidArgumentException, UnableToDetectSchemaException, ResourceProvisionedThroughputExceededException, ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInputSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DiscoverInputSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInputSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)discoverInputSchemaRequest).withMarshaller((Marshaller)new DiscoverInputSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListApplicationSnapshotsResponse listApplicationSnapshots(ListApplicationSnapshotsRequest listApplicationSnapshotsRequest) throws InvalidArgumentException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListApplicationSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationSnapshotsRequest).withMarshaller((Marshaller)new ListApplicationSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationsRequest).withMarshaller((Marshaller)new ListApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartApplicationResponse startApplication(StartApplicationRequest startApplicationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidApplicationConfigurationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startApplicationRequest).withMarshaller((Marshaller)new StartApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopApplicationResponse stopApplication(StopApplicationRequest stopApplicationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopApplicationRequest).withMarshaller((Marshaller)new StopApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ResourceInUseException, TooManyTagsException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ResourceInUseException, TooManyTagsException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws CodeValidationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationRequest).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisAnalyticsV2Exception::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeValidationException").exceptionBuilderSupplier(CodeValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

