/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ContentLocationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ContentLocationUpdate> {
    private static final SdkField<String> BUCKET_ARN_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARNUpdate").getter(S3ContentLocationUpdate.getter(S3ContentLocationUpdate::bucketARNUpdate)).setter(S3ContentLocationUpdate.setter(Builder::bucketARNUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARNUpdate").build()}).build();
    private static final SdkField<String> FILE_KEY_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileKeyUpdate").getter(S3ContentLocationUpdate.getter(S3ContentLocationUpdate::fileKeyUpdate)).setter(S3ContentLocationUpdate.setter(Builder::fileKeyUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKeyUpdate").build()}).build();
    private static final SdkField<String> OBJECT_VERSION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectVersionUpdate").getter(S3ContentLocationUpdate.getter(S3ContentLocationUpdate::objectVersionUpdate)).setter(S3ContentLocationUpdate.setter(Builder::objectVersionUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersionUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_UPDATE_FIELD, FILE_KEY_UPDATE_FIELD, OBJECT_VERSION_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketARNUpdate;
    private final String fileKeyUpdate;
    private final String objectVersionUpdate;

    private S3ContentLocationUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.fileKeyUpdate = builder.fileKeyUpdate;
        this.objectVersionUpdate = builder.objectVersionUpdate;
    }

    public final String bucketARNUpdate() {
        return this.bucketARNUpdate;
    }

    public final String fileKeyUpdate() {
        return this.fileKeyUpdate;
    }

    public final String objectVersionUpdate() {
        return this.objectVersionUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKeyUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectVersionUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentLocationUpdate)) {
            return false;
        }
        S3ContentLocationUpdate other = (S3ContentLocationUpdate)obj;
        return Objects.equals(this.bucketARNUpdate(), other.bucketARNUpdate()) && Objects.equals(this.fileKeyUpdate(), other.fileKeyUpdate()) && Objects.equals(this.objectVersionUpdate(), other.objectVersionUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"S3ContentLocationUpdate").add("BucketARNUpdate", (Object)this.bucketARNUpdate()).add("FileKeyUpdate", (Object)this.fileKeyUpdate()).add("ObjectVersionUpdate", (Object)this.objectVersionUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.bucketARNUpdate()));
            }
            case "FileKeyUpdate": {
                return Optional.ofNullable(clazz.cast(this.fileKeyUpdate()));
            }
            case "ObjectVersionUpdate": {
                return Optional.ofNullable(clazz.cast(this.objectVersionUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ContentLocationUpdate, T> g) {
        return obj -> g.apply((S3ContentLocationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARNUpdate;
        private String fileKeyUpdate;
        private String objectVersionUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentLocationUpdate model) {
            this.bucketARNUpdate(model.bucketARNUpdate);
            this.fileKeyUpdate(model.fileKeyUpdate);
            this.objectVersionUpdate(model.objectVersionUpdate);
        }

        public final String getBucketARNUpdate() {
            return this.bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        public final String getFileKeyUpdate() {
            return this.fileKeyUpdate;
        }

        @Override
        public final Builder fileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
            return this;
        }

        public final void setFileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
        }

        public final String getObjectVersionUpdate() {
            return this.objectVersionUpdate;
        }

        @Override
        public final Builder objectVersionUpdate(String objectVersionUpdate) {
            this.objectVersionUpdate = objectVersionUpdate;
            return this;
        }

        public final void setObjectVersionUpdate(String objectVersionUpdate) {
            this.objectVersionUpdate = objectVersionUpdate;
        }

        public S3ContentLocationUpdate build() {
            return new S3ContentLocationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ContentLocationUpdate> {
        public Builder bucketARNUpdate(String var1);

        public Builder fileKeyUpdate(String var1);

        public Builder objectVersionUpdate(String var1);
    }
}

