/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlRunConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlRunConfiguration> {
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputId").getter(SqlRunConfiguration.getter(SqlRunConfiguration::inputId)).setter(SqlRunConfiguration.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()}).build();
    private static final SdkField<InputStartingPositionConfiguration> INPUT_STARTING_POSITION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputStartingPositionConfiguration").getter(SqlRunConfiguration.getter(SqlRunConfiguration::inputStartingPositionConfiguration)).setter(SqlRunConfiguration.setter(Builder::inputStartingPositionConfiguration)).constructor(InputStartingPositionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStartingPositionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ID_FIELD, INPUT_STARTING_POSITION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputId;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private SqlRunConfiguration(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    public final String inputId() {
        return this.inputId;
    }

    public final InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStartingPositionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlRunConfiguration)) {
            return false;
        }
        SqlRunConfiguration other = (SqlRunConfiguration)obj;
        return Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SqlRunConfiguration").add("InputId", (Object)this.inputId()).add("InputStartingPositionConfiguration", (Object)this.inputStartingPositionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputStartingPositionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputStartingPositionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlRunConfiguration, T> g) {
        return obj -> g.apply((SqlRunConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputId;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlRunConfiguration model) {
            this.inputId(model.inputId);
            this.inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration != null ? this.inputStartingPositionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.build() : null;
        }

        public SqlRunConfiguration build() {
            return new SqlRunConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlRunConfiguration> {
        public Builder inputId(String var1);

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);

        default public Builder inputStartingPositionConfiguration(Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return this.inputStartingPositionConfiguration((InputStartingPositionConfiguration)((InputStartingPositionConfiguration.Builder)InputStartingPositionConfiguration.builder().applyMutation(inputStartingPositionConfiguration)).build());
        }
    }
}

