/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentProperties;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationConfiguration> {
    private static final SdkField<SqlApplicationConfiguration> SQL_APPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqlApplicationConfiguration").getter(ApplicationConfiguration.getter(ApplicationConfiguration::sqlApplicationConfiguration)).setter(ApplicationConfiguration.setter(Builder::sqlApplicationConfiguration)).constructor(SqlApplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfiguration").build()}).build();
    private static final SdkField<FlinkApplicationConfiguration> FLINK_APPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlinkApplicationConfiguration").getter(ApplicationConfiguration.getter(ApplicationConfiguration::flinkApplicationConfiguration)).setter(ApplicationConfiguration.setter(Builder::flinkApplicationConfiguration)).constructor(FlinkApplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkApplicationConfiguration").build()}).build();
    private static final SdkField<EnvironmentProperties> ENVIRONMENT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnvironmentProperties").getter(ApplicationConfiguration.getter(ApplicationConfiguration::environmentProperties)).setter(ApplicationConfiguration.setter(Builder::environmentProperties)).constructor(EnvironmentProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentProperties").build()}).build();
    private static final SdkField<ApplicationCodeConfiguration> APPLICATION_CODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationCodeConfiguration").getter(ApplicationConfiguration.getter(ApplicationConfiguration::applicationCodeConfiguration)).setter(ApplicationConfiguration.setter(Builder::applicationCodeConfiguration)).constructor(ApplicationCodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfiguration").build()}).build();
    private static final SdkField<ApplicationSnapshotConfiguration> APPLICATION_SNAPSHOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSnapshotConfiguration").getter(ApplicationConfiguration.getter(ApplicationConfiguration::applicationSnapshotConfiguration)).setter(ApplicationConfiguration.setter(Builder::applicationSnapshotConfiguration)).constructor(ApplicationSnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSnapshotConfiguration").build()}).build();
    private static final SdkField<List<VpcConfiguration>> VPC_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcConfigurations").getter(ApplicationConfiguration.getter(ApplicationConfiguration::vpcConfigurations)).setter(ApplicationConfiguration.setter(Builder::vpcConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_APPLICATION_CONFIGURATION_FIELD, FLINK_APPLICATION_CONFIGURATION_FIELD, ENVIRONMENT_PROPERTIES_FIELD, APPLICATION_CODE_CONFIGURATION_FIELD, APPLICATION_SNAPSHOT_CONFIGURATION_FIELD, VPC_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final SqlApplicationConfiguration sqlApplicationConfiguration;
    private final FlinkApplicationConfiguration flinkApplicationConfiguration;
    private final EnvironmentProperties environmentProperties;
    private final ApplicationCodeConfiguration applicationCodeConfiguration;
    private final ApplicationSnapshotConfiguration applicationSnapshotConfiguration;
    private final List<VpcConfiguration> vpcConfigurations;

    private ApplicationConfiguration(BuilderImpl builder) {
        this.sqlApplicationConfiguration = builder.sqlApplicationConfiguration;
        this.flinkApplicationConfiguration = builder.flinkApplicationConfiguration;
        this.environmentProperties = builder.environmentProperties;
        this.applicationCodeConfiguration = builder.applicationCodeConfiguration;
        this.applicationSnapshotConfiguration = builder.applicationSnapshotConfiguration;
        this.vpcConfigurations = builder.vpcConfigurations;
    }

    public final SqlApplicationConfiguration sqlApplicationConfiguration() {
        return this.sqlApplicationConfiguration;
    }

    public final FlinkApplicationConfiguration flinkApplicationConfiguration() {
        return this.flinkApplicationConfiguration;
    }

    public final EnvironmentProperties environmentProperties() {
        return this.environmentProperties;
    }

    public final ApplicationCodeConfiguration applicationCodeConfiguration() {
        return this.applicationCodeConfiguration;
    }

    public final ApplicationSnapshotConfiguration applicationSnapshotConfiguration() {
        return this.applicationSnapshotConfiguration;
    }

    public final boolean hasVpcConfigurations() {
        return this.vpcConfigurations != null && !(this.vpcConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VpcConfiguration> vpcConfigurations() {
        return this.vpcConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlApplicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.flinkApplicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCodeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSnapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConfigurations() ? this.vpcConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfiguration)) {
            return false;
        }
        ApplicationConfiguration other = (ApplicationConfiguration)obj;
        return Objects.equals(this.sqlApplicationConfiguration(), other.sqlApplicationConfiguration()) && Objects.equals(this.flinkApplicationConfiguration(), other.flinkApplicationConfiguration()) && Objects.equals(this.environmentProperties(), other.environmentProperties()) && Objects.equals(this.applicationCodeConfiguration(), other.applicationCodeConfiguration()) && Objects.equals(this.applicationSnapshotConfiguration(), other.applicationSnapshotConfiguration()) && this.hasVpcConfigurations() == other.hasVpcConfigurations() && Objects.equals(this.vpcConfigurations(), other.vpcConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationConfiguration").add("SqlApplicationConfiguration", (Object)this.sqlApplicationConfiguration()).add("FlinkApplicationConfiguration", (Object)this.flinkApplicationConfiguration()).add("EnvironmentProperties", (Object)this.environmentProperties()).add("ApplicationCodeConfiguration", (Object)this.applicationCodeConfiguration()).add("ApplicationSnapshotConfiguration", (Object)this.applicationSnapshotConfiguration()).add("VpcConfigurations", this.hasVpcConfigurations() ? this.vpcConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlApplicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sqlApplicationConfiguration()));
            }
            case "FlinkApplicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.flinkApplicationConfiguration()));
            }
            case "EnvironmentProperties": {
                return Optional.ofNullable(clazz.cast(this.environmentProperties()));
            }
            case "ApplicationCodeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.applicationCodeConfiguration()));
            }
            case "ApplicationSnapshotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.applicationSnapshotConfiguration()));
            }
            case "VpcConfigurations": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfiguration, T> g) {
        return obj -> g.apply((ApplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SqlApplicationConfiguration sqlApplicationConfiguration;
        private FlinkApplicationConfiguration flinkApplicationConfiguration;
        private EnvironmentProperties environmentProperties;
        private ApplicationCodeConfiguration applicationCodeConfiguration;
        private ApplicationSnapshotConfiguration applicationSnapshotConfiguration;
        private List<VpcConfiguration> vpcConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfiguration model) {
            this.sqlApplicationConfiguration(model.sqlApplicationConfiguration);
            this.flinkApplicationConfiguration(model.flinkApplicationConfiguration);
            this.environmentProperties(model.environmentProperties);
            this.applicationCodeConfiguration(model.applicationCodeConfiguration);
            this.applicationSnapshotConfiguration(model.applicationSnapshotConfiguration);
            this.vpcConfigurations(model.vpcConfigurations);
        }

        public final SqlApplicationConfiguration.Builder getSqlApplicationConfiguration() {
            return this.sqlApplicationConfiguration != null ? this.sqlApplicationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sqlApplicationConfiguration(SqlApplicationConfiguration sqlApplicationConfiguration) {
            this.sqlApplicationConfiguration = sqlApplicationConfiguration;
            return this;
        }

        public final void setSqlApplicationConfiguration(SqlApplicationConfiguration.BuilderImpl sqlApplicationConfiguration) {
            this.sqlApplicationConfiguration = sqlApplicationConfiguration != null ? sqlApplicationConfiguration.build() : null;
        }

        public final FlinkApplicationConfiguration.Builder getFlinkApplicationConfiguration() {
            return this.flinkApplicationConfiguration != null ? this.flinkApplicationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder flinkApplicationConfiguration(FlinkApplicationConfiguration flinkApplicationConfiguration) {
            this.flinkApplicationConfiguration = flinkApplicationConfiguration;
            return this;
        }

        public final void setFlinkApplicationConfiguration(FlinkApplicationConfiguration.BuilderImpl flinkApplicationConfiguration) {
            this.flinkApplicationConfiguration = flinkApplicationConfiguration != null ? flinkApplicationConfiguration.build() : null;
        }

        public final EnvironmentProperties.Builder getEnvironmentProperties() {
            return this.environmentProperties != null ? this.environmentProperties.toBuilder() : null;
        }

        @Override
        public final Builder environmentProperties(EnvironmentProperties environmentProperties) {
            this.environmentProperties = environmentProperties;
            return this;
        }

        public final void setEnvironmentProperties(EnvironmentProperties.BuilderImpl environmentProperties) {
            this.environmentProperties = environmentProperties != null ? environmentProperties.build() : null;
        }

        public final ApplicationCodeConfiguration.Builder getApplicationCodeConfiguration() {
            return this.applicationCodeConfiguration != null ? this.applicationCodeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder applicationCodeConfiguration(ApplicationCodeConfiguration applicationCodeConfiguration) {
            this.applicationCodeConfiguration = applicationCodeConfiguration;
            return this;
        }

        public final void setApplicationCodeConfiguration(ApplicationCodeConfiguration.BuilderImpl applicationCodeConfiguration) {
            this.applicationCodeConfiguration = applicationCodeConfiguration != null ? applicationCodeConfiguration.build() : null;
        }

        public final ApplicationSnapshotConfiguration.Builder getApplicationSnapshotConfiguration() {
            return this.applicationSnapshotConfiguration != null ? this.applicationSnapshotConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder applicationSnapshotConfiguration(ApplicationSnapshotConfiguration applicationSnapshotConfiguration) {
            this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
            return this;
        }

        public final void setApplicationSnapshotConfiguration(ApplicationSnapshotConfiguration.BuilderImpl applicationSnapshotConfiguration) {
            this.applicationSnapshotConfiguration = applicationSnapshotConfiguration != null ? applicationSnapshotConfiguration.build() : null;
        }

        public final List<VpcConfiguration.Builder> getVpcConfigurations() {
            List<VpcConfiguration.Builder> result = VpcConfigurationsCopier.copyToBuilder(this.vpcConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcConfigurations(Collection<VpcConfiguration> vpcConfigurations) {
            this.vpcConfigurations = VpcConfigurationsCopier.copy(vpcConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurations(VpcConfiguration ... vpcConfigurations) {
            this.vpcConfigurations(Arrays.asList(vpcConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurations(Consumer<VpcConfiguration.Builder> ... vpcConfigurations) {
            this.vpcConfigurations(Stream.of(vpcConfigurations).map(c -> (VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcConfigurations(Collection<VpcConfiguration.BuilderImpl> vpcConfigurations) {
            this.vpcConfigurations = VpcConfigurationsCopier.copyFromBuilder(vpcConfigurations);
        }

        public ApplicationConfiguration build() {
            return new ApplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationConfiguration> {
        public Builder sqlApplicationConfiguration(SqlApplicationConfiguration var1);

        default public Builder sqlApplicationConfiguration(Consumer<SqlApplicationConfiguration.Builder> sqlApplicationConfiguration) {
            return this.sqlApplicationConfiguration((SqlApplicationConfiguration)((SqlApplicationConfiguration.Builder)SqlApplicationConfiguration.builder().applyMutation(sqlApplicationConfiguration)).build());
        }

        public Builder flinkApplicationConfiguration(FlinkApplicationConfiguration var1);

        default public Builder flinkApplicationConfiguration(Consumer<FlinkApplicationConfiguration.Builder> flinkApplicationConfiguration) {
            return this.flinkApplicationConfiguration((FlinkApplicationConfiguration)((FlinkApplicationConfiguration.Builder)FlinkApplicationConfiguration.builder().applyMutation(flinkApplicationConfiguration)).build());
        }

        public Builder environmentProperties(EnvironmentProperties var1);

        default public Builder environmentProperties(Consumer<EnvironmentProperties.Builder> environmentProperties) {
            return this.environmentProperties((EnvironmentProperties)((EnvironmentProperties.Builder)EnvironmentProperties.builder().applyMutation(environmentProperties)).build());
        }

        public Builder applicationCodeConfiguration(ApplicationCodeConfiguration var1);

        default public Builder applicationCodeConfiguration(Consumer<ApplicationCodeConfiguration.Builder> applicationCodeConfiguration) {
            return this.applicationCodeConfiguration((ApplicationCodeConfiguration)((ApplicationCodeConfiguration.Builder)ApplicationCodeConfiguration.builder().applyMutation(applicationCodeConfiguration)).build());
        }

        public Builder applicationSnapshotConfiguration(ApplicationSnapshotConfiguration var1);

        default public Builder applicationSnapshotConfiguration(Consumer<ApplicationSnapshotConfiguration.Builder> applicationSnapshotConfiguration) {
            return this.applicationSnapshotConfiguration((ApplicationSnapshotConfiguration)((ApplicationSnapshotConfiguration.Builder)ApplicationSnapshotConfiguration.builder().applyMutation(applicationSnapshotConfiguration)).build());
        }

        public Builder vpcConfigurations(Collection<VpcConfiguration> var1);

        public Builder vpcConfigurations(VpcConfiguration ... var1);

        public Builder vpcConfigurations(Consumer<VpcConfiguration.Builder> ... var1);
    }
}

