/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the method and snapshot to use when restarting an application using previously saved application state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationRestoreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationRestoreConfiguration.Builder, ApplicationRestoreConfiguration> {
    private static final SdkField<String> APPLICATION_RESTORE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationRestoreType").getter(getter(ApplicationRestoreConfiguration::applicationRestoreTypeAsString))
            .setter(setter(Builder::applicationRestoreType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRestoreType").build())
            .build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(ApplicationRestoreConfiguration::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_RESTORE_TYPE_FIELD, SNAPSHOT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationRestoreType;

    private final String snapshotName;

    private ApplicationRestoreConfiguration(BuilderImpl builder) {
        this.applicationRestoreType = builder.applicationRestoreType;
        this.snapshotName = builder.snapshotName;
    }

    /**
     * <p>
     * Specifies how the application should be restored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationRestoreType} will return {@link ApplicationRestoreType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationRestoreTypeAsString}.
     * </p>
     * 
     * @return Specifies how the application should be restored.
     * @see ApplicationRestoreType
     */
    public final ApplicationRestoreType applicationRestoreType() {
        return ApplicationRestoreType.fromValue(applicationRestoreType);
    }

    /**
     * <p>
     * Specifies how the application should be restored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationRestoreType} will return {@link ApplicationRestoreType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationRestoreTypeAsString}.
     * </p>
     * 
     * @return Specifies how the application should be restored.
     * @see ApplicationRestoreType
     */
    public final String applicationRestoreTypeAsString() {
        return applicationRestoreType;
    }

    /**
     * <p>
     * The identifier of an existing snapshot of application state to use to restart an application. The application
     * uses this value if <code>RESTORE_FROM_CUSTOM_SNAPSHOT</code> is specified for the
     * <code>ApplicationRestoreType</code>.
     * </p>
     * 
     * @return The identifier of an existing snapshot of application state to use to restart an application. The
     *         application uses this value if <code>RESTORE_FROM_CUSTOM_SNAPSHOT</code> is specified for the
     *         <code>ApplicationRestoreType</code>.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationRestoreTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationRestoreConfiguration)) {
            return false;
        }
        ApplicationRestoreConfiguration other = (ApplicationRestoreConfiguration) obj;
        return Objects.equals(applicationRestoreTypeAsString(), other.applicationRestoreTypeAsString())
                && Objects.equals(snapshotName(), other.snapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationRestoreConfiguration")
                .add("ApplicationRestoreType", applicationRestoreTypeAsString()).add("SnapshotName", snapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationRestoreType":
            return Optional.ofNullable(clazz.cast(applicationRestoreTypeAsString()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationRestoreConfiguration, T> g) {
        return obj -> g.apply((ApplicationRestoreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationRestoreConfiguration> {
        /**
         * <p>
         * Specifies how the application should be restored.
         * </p>
         * 
         * @param applicationRestoreType
         *        Specifies how the application should be restored.
         * @see ApplicationRestoreType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationRestoreType
         */
        Builder applicationRestoreType(String applicationRestoreType);

        /**
         * <p>
         * Specifies how the application should be restored.
         * </p>
         * 
         * @param applicationRestoreType
         *        Specifies how the application should be restored.
         * @see ApplicationRestoreType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationRestoreType
         */
        Builder applicationRestoreType(ApplicationRestoreType applicationRestoreType);

        /**
         * <p>
         * The identifier of an existing snapshot of application state to use to restart an application. The application
         * uses this value if <code>RESTORE_FROM_CUSTOM_SNAPSHOT</code> is specified for the
         * <code>ApplicationRestoreType</code>.
         * </p>
         * 
         * @param snapshotName
         *        The identifier of an existing snapshot of application state to use to restart an application. The
         *        application uses this value if <code>RESTORE_FROM_CUSTOM_SNAPSHOT</code> is specified for the
         *        <code>ApplicationRestoreType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);
    }

    static final class BuilderImpl implements Builder {
        private String applicationRestoreType;

        private String snapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationRestoreConfiguration model) {
            applicationRestoreType(model.applicationRestoreType);
            snapshotName(model.snapshotName);
        }

        public final String getApplicationRestoreType() {
            return applicationRestoreType;
        }

        public final void setApplicationRestoreType(String applicationRestoreType) {
            this.applicationRestoreType = applicationRestoreType;
        }

        @Override
        @Transient
        public final Builder applicationRestoreType(String applicationRestoreType) {
            this.applicationRestoreType = applicationRestoreType;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationRestoreType(ApplicationRestoreType applicationRestoreType) {
            this.applicationRestoreType(applicationRestoreType == null ? null : applicationRestoreType.toString());
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        @Transient
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        @Override
        public ApplicationRestoreConfiguration build() {
            return new ApplicationRestoreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
