/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides application summary information, including the application Amazon Resource Name (ARN), name, and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(ApplicationSummary::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(ApplicationSummary::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus").getter(getter(ApplicationSummary::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(ApplicationSummary::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeEnvironment").getter(getter(ApplicationSummary::runtimeEnvironmentAsString))
            .setter(setter(Builder::runtimeEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build())
            .build();

    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationMode").getter(getter(ApplicationSummary::applicationModeAsString))
            .setter(setter(Builder::applicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            APPLICATION_ARN_FIELD, APPLICATION_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, RUNTIME_ENVIRONMENT_FIELD,
            APPLICATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationName;

    private final String applicationARN;

    private final String applicationStatus;

    private final Long applicationVersionId;

    private final String runtimeEnvironment;

    private final String applicationMode;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.applicationMode = builder.applicationMode;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The ARN of the application.
     * </p>
     * 
     * @return The ARN of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    /**
     * <p>
     * Provides the current application version.
     * </p>
     * 
     * @return Provides the current application version.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The runtime environment for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application.
     * @see RuntimeEnvironment
     */
    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(runtimeEnvironment);
    }

    /**
     * <p>
     * The runtime environment for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application.
     * @see RuntimeEnvironment
     */
    public final String runtimeEnvironmentAsString() {
        return runtimeEnvironment;
    }

    /**
     * <p>
     * For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a Kinesis Data
     * Analytics Studio notebook, it is <code>INTERACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a
     *         Kinesis Data Analytics Studio notebook, it is <code>INTERACTIVE</code>.
     * @see ApplicationMode
     */
    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(applicationMode);
    }

    /**
     * <p>
     * For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a Kinesis Data
     * Analytics Studio notebook, it is <code>INTERACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a
     *         Kinesis Data Analytics Studio notebook, it is <code>INTERACTIVE</code>.
     * @see ApplicationMode
     */
    public final String applicationModeAsString() {
        return applicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString())
                && Objects.equals(applicationModeAsString(), other.applicationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSummary").add("ApplicationName", applicationName())
                .add("ApplicationARN", applicationARN()).add("ApplicationStatus", applicationStatusAsString())
                .add("ApplicationVersionId", applicationVersionId()).add("RuntimeEnvironment", runtimeEnvironmentAsString())
                .add("ApplicationMode", applicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "RuntimeEnvironment":
            return Optional.ofNullable(clazz.cast(runtimeEnvironmentAsString()));
        case "ApplicationMode":
            return Optional.ofNullable(clazz.cast(applicationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        The ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * Provides the current application version.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The runtime environment for the application.
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application.
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(String runtimeEnvironment);

        /**
         * <p>
         * The runtime environment for the application.
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application.
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment);

        /**
         * <p>
         * For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a Kinesis
         * Data Analytics Studio notebook, it is <code>INTERACTIVE</code>.
         * </p>
         * 
         * @param applicationMode
         *        For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a
         *        Kinesis Data Analytics Studio notebook, it is <code>INTERACTIVE</code>.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(String applicationMode);

        /**
         * <p>
         * For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a Kinesis
         * Data Analytics Studio notebook, it is <code>INTERACTIVE</code>.
         * </p>
         * 
         * @param applicationMode
         *        For a Kinesis Data Analytics for Apache Flink application, the mode is <code>STREAMING</code>. For a
         *        Kinesis Data Analytics Studio notebook, it is <code>INTERACTIVE</code>.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(ApplicationMode applicationMode);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String applicationARN;

        private String applicationStatus;

        private Long applicationVersionId;

        private String runtimeEnvironment;

        private String applicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            applicationName(model.applicationName);
            applicationARN(model.applicationARN);
            applicationStatus(model.applicationStatus);
            applicationVersionId(model.applicationVersionId);
            runtimeEnvironment(model.runtimeEnvironment);
            applicationMode(model.applicationMode);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        @Transient
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        @Transient
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        @Transient
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final String getRuntimeEnvironment() {
            return runtimeEnvironment;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        @Override
        @Transient
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        @Transient
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public final String getApplicationMode() {
            return applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        @Transient
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
