/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationPresignedUrlResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<CreateApplicationPresignedUrlResponse.Builder, CreateApplicationPresignedUrlResponse> {
    private static final SdkField<String> AUTHORIZED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedUrl").getter(getter(CreateApplicationPresignedUrlResponse::authorizedUrl))
            .setter(setter(Builder::authorizedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_URL_FIELD));

    private final String authorizedUrl;

    private CreateApplicationPresignedUrlResponse(BuilderImpl builder) {
        super(builder);
        this.authorizedUrl = builder.authorizedUrl;
    }

    /**
     * <p>
     * The URL of the extension.
     * </p>
     * 
     * @return The URL of the extension.
     */
    public final String authorizedUrl() {
        return authorizedUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizedUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationPresignedUrlResponse)) {
            return false;
        }
        CreateApplicationPresignedUrlResponse other = (CreateApplicationPresignedUrlResponse) obj;
        return Objects.equals(authorizedUrl(), other.authorizedUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationPresignedUrlResponse").add("AuthorizedUrl", authorizedUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizedUrl":
            return Optional.ofNullable(clazz.cast(authorizedUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationPresignedUrlResponse, T> g) {
        return obj -> g.apply((CreateApplicationPresignedUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationPresignedUrlResponse> {
        /**
         * <p>
         * The URL of the extension.
         * </p>
         * 
         * @param authorizedUrl
         *        The URL of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedUrl(String authorizedUrl);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String authorizedUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationPresignedUrlResponse model) {
            super(model);
            authorizedUrl(model.authorizedUrl);
        }

        public final String getAuthorizedUrl() {
            return authorizedUrl;
        }

        public final void setAuthorizedUrl(String authorizedUrl) {
            this.authorizedUrl = authorizedUrl;
        }

        @Override
        @Transient
        public final Builder authorizedUrl(String authorizedUrl) {
            this.authorizedUrl = authorizedUrl;
            return this;
        }

        @Override
        public CreateApplicationPresignedUrlResponse build() {
            return new CreateApplicationPresignedUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
