/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to the configuration information required to deploy an Amazon Data Analytics Studio notebook as an
 * application with durable state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeployAsApplicationConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<DeployAsApplicationConfigurationUpdate.Builder, DeployAsApplicationConfigurationUpdate> {
    private static final SdkField<S3ContentBaseLocationUpdate> S3_CONTENT_LOCATION_UPDATE_FIELD = SdkField
            .<S3ContentBaseLocationUpdate> builder(MarshallingType.SDK_POJO).memberName("S3ContentLocationUpdate")
            .getter(getter(DeployAsApplicationConfigurationUpdate::s3ContentLocationUpdate))
            .setter(setter(Builder::s3ContentLocationUpdate)).constructor(S3ContentBaseLocationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocationUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_CONTENT_LOCATION_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3ContentBaseLocationUpdate s3ContentLocationUpdate;

    private DeployAsApplicationConfigurationUpdate(BuilderImpl builder) {
        this.s3ContentLocationUpdate = builder.s3ContentLocationUpdate;
    }

    /**
     * <p>
     * Updates to the location that holds the data required to specify an Amazon Data Analytics application.
     * </p>
     * 
     * @return Updates to the location that holds the data required to specify an Amazon Data Analytics application.
     */
    public final S3ContentBaseLocationUpdate s3ContentLocationUpdate() {
        return s3ContentLocationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ContentLocationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployAsApplicationConfigurationUpdate)) {
            return false;
        }
        DeployAsApplicationConfigurationUpdate other = (DeployAsApplicationConfigurationUpdate) obj;
        return Objects.equals(s3ContentLocationUpdate(), other.s3ContentLocationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeployAsApplicationConfigurationUpdate")
                .add("S3ContentLocationUpdate", s3ContentLocationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ContentLocationUpdate":
            return Optional.ofNullable(clazz.cast(s3ContentLocationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeployAsApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((DeployAsApplicationConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeployAsApplicationConfigurationUpdate> {
        /**
         * <p>
         * Updates to the location that holds the data required to specify an Amazon Data Analytics application.
         * </p>
         * 
         * @param s3ContentLocationUpdate
         *        Updates to the location that holds the data required to specify an Amazon Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ContentLocationUpdate(S3ContentBaseLocationUpdate s3ContentLocationUpdate);

        /**
         * <p>
         * Updates to the location that holds the data required to specify an Amazon Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link S3ContentBaseLocationUpdate.Builder} avoiding
         * the need to create one manually via {@link S3ContentBaseLocationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ContentBaseLocationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #s3ContentLocationUpdate(S3ContentBaseLocationUpdate)}.
         * 
         * @param s3ContentLocationUpdate
         *        a consumer that will call methods on {@link S3ContentBaseLocationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ContentLocationUpdate(S3ContentBaseLocationUpdate)
         */
        default Builder s3ContentLocationUpdate(Consumer<S3ContentBaseLocationUpdate.Builder> s3ContentLocationUpdate) {
            return s3ContentLocationUpdate(S3ContentBaseLocationUpdate.builder().applyMutation(s3ContentLocationUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ContentBaseLocationUpdate s3ContentLocationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployAsApplicationConfigurationUpdate model) {
            s3ContentLocationUpdate(model.s3ContentLocationUpdate);
        }

        public final S3ContentBaseLocationUpdate.Builder getS3ContentLocationUpdate() {
            return s3ContentLocationUpdate != null ? s3ContentLocationUpdate.toBuilder() : null;
        }

        public final void setS3ContentLocationUpdate(S3ContentBaseLocationUpdate.BuilderImpl s3ContentLocationUpdate) {
            this.s3ContentLocationUpdate = s3ContentLocationUpdate != null ? s3ContentLocationUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder s3ContentLocationUpdate(S3ContentBaseLocationUpdate s3ContentLocationUpdate) {
            this.s3ContentLocationUpdate = s3ContentLocationUpdate;
            return this;
        }

        @Override
        public DeployAsApplicationConfigurationUpdate build() {
            return new DeployAsApplicationConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
