/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a SQL-based Kinesis Data Analytics application, represents an update to the <a>InputLambdaProcessor</a> that is
 * used to preprocess the records in the stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputLambdaProcessorUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<InputLambdaProcessorUpdate.Builder, InputLambdaProcessorUpdate> {
    private static final SdkField<String> RESOURCE_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARNUpdate").getter(getter(InputLambdaProcessorUpdate::resourceARNUpdate))
            .setter(setter(Builder::resourceARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceARNUpdate;

    private InputLambdaProcessorUpdate(BuilderImpl builder) {
        this.resourceARNUpdate = builder.resourceARNUpdate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the new Amazon Lambda function that is used to preprocess the records in the
     * stream.
     * </p>
     * <note>
     * <p>
     * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the
     * Lambda function ARN. For more information about Lambda ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs:
     * Amazon Lambda</a>
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the new Amazon Lambda function that is used to preprocess the records
     *         in the stream.</p> <note>
     *         <p>
     *         To specify an earlier version of the Lambda function than the latest, include the Lambda function version
     *         in the Lambda function ARN. For more information about Lambda ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda"
     *         >Example ARNs: Amazon Lambda</a>
     *         </p>
     */
    public final String resourceARNUpdate() {
        return resourceARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARNUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLambdaProcessorUpdate)) {
            return false;
        }
        InputLambdaProcessorUpdate other = (InputLambdaProcessorUpdate) obj;
        return Objects.equals(resourceARNUpdate(), other.resourceARNUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputLambdaProcessorUpdate").add("ResourceARNUpdate", resourceARNUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARNUpdate":
            return Optional.ofNullable(clazz.cast(resourceARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputLambdaProcessorUpdate, T> g) {
        return obj -> g.apply((InputLambdaProcessorUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputLambdaProcessorUpdate> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the new Amazon Lambda function that is used to preprocess the records in
         * the stream.
         * </p>
         * <note>
         * <p>
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in
         * the Lambda function ARN. For more information about Lambda ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example
         * ARNs: Amazon Lambda</a>
         * </p>
         * </note>
         * 
         * @param resourceARNUpdate
         *        The Amazon Resource Name (ARN) of the new Amazon Lambda function that is used to preprocess the
         *        records in the stream.</p> <note>
         *        <p>
         *        To specify an earlier version of the Lambda function than the latest, include the Lambda function
         *        version in the Lambda function ARN. For more information about Lambda ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda"
         *        >Example ARNs: Amazon Lambda</a>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNUpdate(String resourceARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLambdaProcessorUpdate model) {
            resourceARNUpdate(model.resourceARNUpdate);
        }

        public final String getResourceARNUpdate() {
            return resourceARNUpdate;
        }

        public final void setResourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
        }

        @Override
        @Transient
        public final Builder resourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
            return this;
        }

        @Override
        public InputLambdaProcessorUpdate build() {
            return new InputLambdaProcessorUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
