/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration parameters for CloudWatch logging for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfigurationDescription.Builder, MonitoringConfigurationDescription> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationType").getter(getter(MonitoringConfigurationDescription::configurationTypeAsString))
            .setter(setter(Builder::configurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()).build();

    private static final SdkField<String> METRICS_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricsLevel").getter(getter(MonitoringConfigurationDescription::metricsLevelAsString))
            .setter(setter(Builder::metricsLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsLevel").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(MonitoringConfigurationDescription::logLevelAsString))
            .setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD,
            METRICS_LEVEL_FIELD, LOG_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationType;

    private final String metricsLevel;

    private final String logLevel;

    private MonitoringConfigurationDescription(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.metricsLevel = builder.metricsLevel;
        this.logLevel = builder.logLevel;
    }

    /**
     * <p>
     * Describes whether to use the default CloudWatch logging configuration for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Describes whether to use the default CloudWatch logging configuration for an application.
     * @see ConfigurationType
     */
    public final ConfigurationType configurationType() {
        return ConfigurationType.fromValue(configurationType);
    }

    /**
     * <p>
     * Describes whether to use the default CloudWatch logging configuration for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return Describes whether to use the default CloudWatch logging configuration for an application.
     * @see ConfigurationType
     */
    public final String configurationTypeAsString() {
        return configurationType;
    }

    /**
     * <p>
     * Describes the granularity of the CloudWatch Logs for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsLevel} will
     * return {@link MetricsLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsLevelAsString}.
     * </p>
     * 
     * @return Describes the granularity of the CloudWatch Logs for an application.
     * @see MetricsLevel
     */
    public final MetricsLevel metricsLevel() {
        return MetricsLevel.fromValue(metricsLevel);
    }

    /**
     * <p>
     * Describes the granularity of the CloudWatch Logs for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsLevel} will
     * return {@link MetricsLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsLevelAsString}.
     * </p>
     * 
     * @return Describes the granularity of the CloudWatch Logs for an application.
     * @see MetricsLevel
     */
    public final String metricsLevelAsString() {
        return metricsLevel;
    }

    /**
     * <p>
     * Describes the verbosity of the CloudWatch Logs for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Describes the verbosity of the CloudWatch Logs for an application.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * Describes the verbosity of the CloudWatch Logs for an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Describes the verbosity of the CloudWatch Logs for an application.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfigurationDescription)) {
            return false;
        }
        MonitoringConfigurationDescription other = (MonitoringConfigurationDescription) obj;
        return Objects.equals(configurationTypeAsString(), other.configurationTypeAsString())
                && Objects.equals(metricsLevelAsString(), other.metricsLevelAsString())
                && Objects.equals(logLevelAsString(), other.logLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfigurationDescription").add("ConfigurationType", configurationTypeAsString())
                .add("MetricsLevel", metricsLevelAsString()).add("LogLevel", logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationType":
            return Optional.ofNullable(clazz.cast(configurationTypeAsString()));
        case "MetricsLevel":
            return Optional.ofNullable(clazz.cast(metricsLevelAsString()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfigurationDescription, T> g) {
        return obj -> g.apply((MonitoringConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfigurationDescription> {
        /**
         * <p>
         * Describes whether to use the default CloudWatch logging configuration for an application.
         * </p>
         * 
         * @param configurationType
         *        Describes whether to use the default CloudWatch logging configuration for an application.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationType(String configurationType);

        /**
         * <p>
         * Describes whether to use the default CloudWatch logging configuration for an application.
         * </p>
         * 
         * @param configurationType
         *        Describes whether to use the default CloudWatch logging configuration for an application.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationType(ConfigurationType configurationType);

        /**
         * <p>
         * Describes the granularity of the CloudWatch Logs for an application.
         * </p>
         * 
         * @param metricsLevel
         *        Describes the granularity of the CloudWatch Logs for an application.
         * @see MetricsLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsLevel
         */
        Builder metricsLevel(String metricsLevel);

        /**
         * <p>
         * Describes the granularity of the CloudWatch Logs for an application.
         * </p>
         * 
         * @param metricsLevel
         *        Describes the granularity of the CloudWatch Logs for an application.
         * @see MetricsLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsLevel
         */
        Builder metricsLevel(MetricsLevel metricsLevel);

        /**
         * <p>
         * Describes the verbosity of the CloudWatch Logs for an application.
         * </p>
         * 
         * @param logLevel
         *        Describes the verbosity of the CloudWatch Logs for an application.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * Describes the verbosity of the CloudWatch Logs for an application.
         * </p>
         * 
         * @param logLevel
         *        Describes the verbosity of the CloudWatch Logs for an application.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);
    }

    static final class BuilderImpl implements Builder {
        private String configurationType;

        private String metricsLevel;

        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfigurationDescription model) {
            configurationType(model.configurationType);
            metricsLevel(model.metricsLevel);
            logLevel(model.logLevel);
        }

        public final String getConfigurationType() {
            return configurationType;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        @Override
        @Transient
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        @Transient
        public final Builder configurationType(ConfigurationType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final String getMetricsLevel() {
            return metricsLevel;
        }

        public final void setMetricsLevel(String metricsLevel) {
            this.metricsLevel = metricsLevel;
        }

        @Override
        @Transient
        public final Builder metricsLevel(String metricsLevel) {
            this.metricsLevel = metricsLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder metricsLevel(MetricsLevel metricsLevel) {
            this.metricsLevel(metricsLevel == null ? null : metricsLevel.toString());
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        @Transient
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        @Override
        public MonitoringConfigurationDescription build() {
            return new MonitoringConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
