/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a SQL-based Kinesis Data Analytics application's output configuration, in which you identify an
 * in-application stream and a destination where you want the in-application stream data to be written. The destination
 * can be a Kinesis data stream or a Kinesis Data Firehose delivery stream.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Output implements SdkPojo, Serializable, ToCopyableBuilder<Output.Builder, Output> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Output::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<KinesisStreamsOutput> KINESIS_STREAMS_OUTPUT_FIELD = SdkField
            .<KinesisStreamsOutput> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamsOutput")
            .getter(getter(Output::kinesisStreamsOutput)).setter(setter(Builder::kinesisStreamsOutput))
            .constructor(KinesisStreamsOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsOutput").build())
            .build();

    private static final SdkField<KinesisFirehoseOutput> KINESIS_FIREHOSE_OUTPUT_FIELD = SdkField
            .<KinesisFirehoseOutput> builder(MarshallingType.SDK_POJO).memberName("KinesisFirehoseOutput")
            .getter(getter(Output::kinesisFirehoseOutput)).setter(setter(Builder::kinesisFirehoseOutput))
            .constructor(KinesisFirehoseOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseOutput").build())
            .build();

    private static final SdkField<LambdaOutput> LAMBDA_OUTPUT_FIELD = SdkField.<LambdaOutput> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaOutput").getter(getter(Output::lambdaOutput)).setter(setter(Builder::lambdaOutput))
            .constructor(LambdaOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaOutput").build()).build();

    private static final SdkField<DestinationSchema> DESTINATION_SCHEMA_FIELD = SdkField
            .<DestinationSchema> builder(MarshallingType.SDK_POJO).memberName("DestinationSchema")
            .getter(getter(Output::destinationSchema)).setter(setter(Builder::destinationSchema))
            .constructor(DestinationSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            KINESIS_STREAMS_OUTPUT_FIELD, KINESIS_FIREHOSE_OUTPUT_FIELD, LAMBDA_OUTPUT_FIELD, DESTINATION_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final KinesisStreamsOutput kinesisStreamsOutput;

    private final KinesisFirehoseOutput kinesisFirehoseOutput;

    private final LambdaOutput lambdaOutput;

    private final DestinationSchema destinationSchema;

    private Output(BuilderImpl builder) {
        this.name = builder.name;
        this.kinesisStreamsOutput = builder.kinesisStreamsOutput;
        this.kinesisFirehoseOutput = builder.kinesisFirehoseOutput;
        this.lambdaOutput = builder.lambdaOutput;
        this.destinationSchema = builder.destinationSchema;
    }

    /**
     * <p>
     * The name of the in-application stream.
     * </p>
     * 
     * @return The name of the in-application stream.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Identifies a Kinesis data stream as the destination.
     * </p>
     * 
     * @return Identifies a Kinesis data stream as the destination.
     */
    public final KinesisStreamsOutput kinesisStreamsOutput() {
        return kinesisStreamsOutput;
    }

    /**
     * <p>
     * Identifies a Kinesis Data Firehose delivery stream as the destination.
     * </p>
     * 
     * @return Identifies a Kinesis Data Firehose delivery stream as the destination.
     */
    public final KinesisFirehoseOutput kinesisFirehoseOutput() {
        return kinesisFirehoseOutput;
    }

    /**
     * <p>
     * Identifies an Amazon Lambda function as the destination.
     * </p>
     * 
     * @return Identifies an Amazon Lambda function as the destination.
     */
    public final LambdaOutput lambdaOutput() {
        return lambdaOutput;
    }

    /**
     * <p>
     * Describes the data format when records are written to the destination.
     * </p>
     * 
     * @return Describes the data format when records are written to the destination.
     */
    public final DestinationSchema destinationSchema() {
        return destinationSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsOutput());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseOutput());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaOutput());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(kinesisStreamsOutput(), other.kinesisStreamsOutput())
                && Objects.equals(kinesisFirehoseOutput(), other.kinesisFirehoseOutput())
                && Objects.equals(lambdaOutput(), other.lambdaOutput())
                && Objects.equals(destinationSchema(), other.destinationSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Output").add("Name", name()).add("KinesisStreamsOutput", kinesisStreamsOutput())
                .add("KinesisFirehoseOutput", kinesisFirehoseOutput()).add("LambdaOutput", lambdaOutput())
                .add("DestinationSchema", destinationSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "KinesisStreamsOutput":
            return Optional.ofNullable(clazz.cast(kinesisStreamsOutput()));
        case "KinesisFirehoseOutput":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseOutput()));
        case "LambdaOutput":
            return Optional.ofNullable(clazz.cast(lambdaOutput()));
        case "DestinationSchema":
            return Optional.ofNullable(clazz.cast(destinationSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Output> {
        /**
         * <p>
         * The name of the in-application stream.
         * </p>
         * 
         * @param name
         *        The name of the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Identifies a Kinesis data stream as the destination.
         * </p>
         * 
         * @param kinesisStreamsOutput
         *        Identifies a Kinesis data stream as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutput(KinesisStreamsOutput kinesisStreamsOutput);

        /**
         * <p>
         * Identifies a Kinesis data stream as the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsOutput.Builder} avoiding the need
         * to create one manually via {@link KinesisStreamsOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisStreamsOutput(KinesisStreamsOutput)}.
         * 
         * @param kinesisStreamsOutput
         *        a consumer that will call methods on {@link KinesisStreamsOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsOutput(KinesisStreamsOutput)
         */
        default Builder kinesisStreamsOutput(Consumer<KinesisStreamsOutput.Builder> kinesisStreamsOutput) {
            return kinesisStreamsOutput(KinesisStreamsOutput.builder().applyMutation(kinesisStreamsOutput).build());
        }

        /**
         * <p>
         * Identifies a Kinesis Data Firehose delivery stream as the destination.
         * </p>
         * 
         * @param kinesisFirehoseOutput
         *        Identifies a Kinesis Data Firehose delivery stream as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutput(KinesisFirehoseOutput kinesisFirehoseOutput);

        /**
         * <p>
         * Identifies a Kinesis Data Firehose delivery stream as the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseOutput.Builder} avoiding the need
         * to create one manually via {@link KinesisFirehoseOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisFirehoseOutput(KinesisFirehoseOutput)}.
         * 
         * @param kinesisFirehoseOutput
         *        a consumer that will call methods on {@link KinesisFirehoseOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseOutput(KinesisFirehoseOutput)
         */
        default Builder kinesisFirehoseOutput(Consumer<KinesisFirehoseOutput.Builder> kinesisFirehoseOutput) {
            return kinesisFirehoseOutput(KinesisFirehoseOutput.builder().applyMutation(kinesisFirehoseOutput).build());
        }

        /**
         * <p>
         * Identifies an Amazon Lambda function as the destination.
         * </p>
         * 
         * @param lambdaOutput
         *        Identifies an Amazon Lambda function as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaOutput(LambdaOutput lambdaOutput);

        /**
         * <p>
         * Identifies an Amazon Lambda function as the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaOutput.Builder} avoiding the need to
         * create one manually via {@link LambdaOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaOutput(LambdaOutput)}.
         * 
         * @param lambdaOutput
         *        a consumer that will call methods on {@link LambdaOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaOutput(LambdaOutput)
         */
        default Builder lambdaOutput(Consumer<LambdaOutput.Builder> lambdaOutput) {
            return lambdaOutput(LambdaOutput.builder().applyMutation(lambdaOutput).build());
        }

        /**
         * <p>
         * Describes the data format when records are written to the destination.
         * </p>
         * 
         * @param destinationSchema
         *        Describes the data format when records are written to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchema(DestinationSchema destinationSchema);

        /**
         * <p>
         * Describes the data format when records are written to the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationSchema.Builder} avoiding the need to
         * create one manually via {@link DestinationSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSchema(DestinationSchema)}.
         * 
         * @param destinationSchema
         *        a consumer that will call methods on {@link DestinationSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSchema(DestinationSchema)
         */
        default Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return destinationSchema(DestinationSchema.builder().applyMutation(destinationSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private KinesisStreamsOutput kinesisStreamsOutput;

        private KinesisFirehoseOutput kinesisFirehoseOutput;

        private LambdaOutput lambdaOutput;

        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            name(model.name);
            kinesisStreamsOutput(model.kinesisStreamsOutput);
            kinesisFirehoseOutput(model.kinesisFirehoseOutput);
            lambdaOutput(model.lambdaOutput);
            destinationSchema(model.destinationSchema);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KinesisStreamsOutput.Builder getKinesisStreamsOutput() {
            return kinesisStreamsOutput != null ? kinesisStreamsOutput.toBuilder() : null;
        }

        public final void setKinesisStreamsOutput(KinesisStreamsOutput.BuilderImpl kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput != null ? kinesisStreamsOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisStreamsOutput(KinesisStreamsOutput kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput;
            return this;
        }

        public final KinesisFirehoseOutput.Builder getKinesisFirehoseOutput() {
            return kinesisFirehoseOutput != null ? kinesisFirehoseOutput.toBuilder() : null;
        }

        public final void setKinesisFirehoseOutput(KinesisFirehoseOutput.BuilderImpl kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput != null ? kinesisFirehoseOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisFirehoseOutput(KinesisFirehoseOutput kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput;
            return this;
        }

        public final LambdaOutput.Builder getLambdaOutput() {
            return lambdaOutput != null ? lambdaOutput.toBuilder() : null;
        }

        public final void setLambdaOutput(LambdaOutput.BuilderImpl lambdaOutput) {
            this.lambdaOutput = lambdaOutput != null ? lambdaOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaOutput(LambdaOutput lambdaOutput) {
            this.lambdaOutput = lambdaOutput;
            return this;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return destinationSchema != null ? destinationSchema.toBuilder() : null;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        @Override
        public Output build() {
            return new Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
