/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to parameters for how an application executes multiple tasks simultaneously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParallelismConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ParallelismConfigurationUpdate.Builder, ParallelismConfigurationUpdate> {
    private static final SdkField<String> CONFIGURATION_TYPE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationTypeUpdate")
            .getter(getter(ParallelismConfigurationUpdate::configurationTypeUpdateAsString))
            .setter(setter(Builder::configurationTypeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTypeUpdate").build())
            .build();

    private static final SdkField<Integer> PARALLELISM_UPDATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelismUpdate").getter(getter(ParallelismConfigurationUpdate::parallelismUpdate))
            .setter(setter(Builder::parallelismUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismUpdate").build()).build();

    private static final SdkField<Integer> PARALLELISM_PER_KPU_UPDATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelismPerKPUUpdate").getter(getter(ParallelismConfigurationUpdate::parallelismPerKPUUpdate))
            .setter(setter(Builder::parallelismPerKPUUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismPerKPUUpdate").build())
            .build();

    private static final SdkField<Boolean> AUTO_SCALING_ENABLED_UPDATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AutoScalingEnabledUpdate")
            .getter(getter(ParallelismConfigurationUpdate::autoScalingEnabledUpdate))
            .setter(setter(Builder::autoScalingEnabledUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingEnabledUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_TYPE_UPDATE_FIELD, PARALLELISM_UPDATE_FIELD, PARALLELISM_PER_KPU_UPDATE_FIELD,
            AUTO_SCALING_ENABLED_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationTypeUpdate;

    private final Integer parallelismUpdate;

    private final Integer parallelismPerKPUUpdate;

    private final Boolean autoScalingEnabledUpdate;

    private ParallelismConfigurationUpdate(BuilderImpl builder) {
        this.configurationTypeUpdate = builder.configurationTypeUpdate;
        this.parallelismUpdate = builder.parallelismUpdate;
        this.parallelismPerKPUUpdate = builder.parallelismPerKPUUpdate;
        this.autoScalingEnabledUpdate = builder.autoScalingEnabledUpdate;
    }

    /**
     * <p>
     * Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics service,
     * or if a custom parallelism is used. You must set this property to <code>CUSTOM</code> in order to change your
     * application's <code>AutoScalingEnabled</code>, <code>Parallelism</code>, or <code>ParallelismPerKPU</code>
     * properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationTypeUpdate} will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics
     *         service, or if a custom parallelism is used. You must set this property to <code>CUSTOM</code> in order
     *         to change your application's <code>AutoScalingEnabled</code>, <code>Parallelism</code>, or
     *         <code>ParallelismPerKPU</code> properties.
     * @see ConfigurationType
     */
    public final ConfigurationType configurationTypeUpdate() {
        return ConfigurationType.fromValue(configurationTypeUpdate);
    }

    /**
     * <p>
     * Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics service,
     * or if a custom parallelism is used. You must set this property to <code>CUSTOM</code> in order to change your
     * application's <code>AutoScalingEnabled</code>, <code>Parallelism</code>, or <code>ParallelismPerKPU</code>
     * properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationTypeUpdate} will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics
     *         service, or if a custom parallelism is used. You must set this property to <code>CUSTOM</code> in order
     *         to change your application's <code>AutoScalingEnabled</code>, <code>Parallelism</code>, or
     *         <code>ParallelismPerKPU</code> properties.
     * @see ConfigurationType
     */
    public final String configurationTypeUpdateAsString() {
        return configurationTypeUpdate;
    }

    /**
     * <p>
     * Describes updates to the initial number of parallel tasks an application can perform. If
     * <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
     * <code>CurrentParallelism</code> value in response to application load. The service can increase
     * <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code> times the
     * maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by
     * requesting a limit increase. If application load is reduced, the service will reduce
     * <code>CurrentParallelism</code> down to the <code>Parallelism</code> setting.
     * </p>
     * 
     * @return Describes updates to the initial number of parallel tasks an application can perform. If
     *         <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
     *         <code>CurrentParallelism</code> value in response to application load. The service can increase
     *         <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code>
     *         times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can
     *         be increased by requesting a limit increase. If application load is reduced, the service will reduce
     *         <code>CurrentParallelism</code> down to the <code>Parallelism</code> setting.
     */
    public final Integer parallelismUpdate() {
        return parallelismUpdate;
    }

    /**
     * <p>
     * Describes updates to the number of parallel tasks an application can perform per Kinesis Processing Unit (KPU)
     * used by the application.
     * </p>
     * 
     * @return Describes updates to the number of parallel tasks an application can perform per Kinesis Processing Unit
     *         (KPU) used by the application.
     */
    public final Integer parallelismPerKPUUpdate() {
        return parallelismPerKPUUpdate;
    }

    /**
     * <p>
     * Describes updates to whether the Kinesis Data Analytics service can increase the parallelism of a Flink-based
     * Kinesis Data Analytics application in response to increased throughput.
     * </p>
     * 
     * @return Describes updates to whether the Kinesis Data Analytics service can increase the parallelism of a
     *         Flink-based Kinesis Data Analytics application in response to increased throughput.
     */
    public final Boolean autoScalingEnabledUpdate() {
        return autoScalingEnabledUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismPerKPUUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingEnabledUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelismConfigurationUpdate)) {
            return false;
        }
        ParallelismConfigurationUpdate other = (ParallelismConfigurationUpdate) obj;
        return Objects.equals(configurationTypeUpdateAsString(), other.configurationTypeUpdateAsString())
                && Objects.equals(parallelismUpdate(), other.parallelismUpdate())
                && Objects.equals(parallelismPerKPUUpdate(), other.parallelismPerKPUUpdate())
                && Objects.equals(autoScalingEnabledUpdate(), other.autoScalingEnabledUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParallelismConfigurationUpdate")
                .add("ConfigurationTypeUpdate", configurationTypeUpdateAsString()).add("ParallelismUpdate", parallelismUpdate())
                .add("ParallelismPerKPUUpdate", parallelismPerKPUUpdate())
                .add("AutoScalingEnabledUpdate", autoScalingEnabledUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationTypeUpdate":
            return Optional.ofNullable(clazz.cast(configurationTypeUpdateAsString()));
        case "ParallelismUpdate":
            return Optional.ofNullable(clazz.cast(parallelismUpdate()));
        case "ParallelismPerKPUUpdate":
            return Optional.ofNullable(clazz.cast(parallelismPerKPUUpdate()));
        case "AutoScalingEnabledUpdate":
            return Optional.ofNullable(clazz.cast(autoScalingEnabledUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParallelismConfigurationUpdate, T> g) {
        return obj -> g.apply((ParallelismConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParallelismConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics
         * service, or if a custom parallelism is used. You must set this property to <code>CUSTOM</code> in order to
         * change your application's <code>AutoScalingEnabled</code>, <code>Parallelism</code>, or
         * <code>ParallelismPerKPU</code> properties.
         * </p>
         * 
         * @param configurationTypeUpdate
         *        Describes updates to whether the application uses the default parallelism for the Kinesis Data
         *        Analytics service, or if a custom parallelism is used. You must set this property to
         *        <code>CUSTOM</code> in order to change your application's <code>AutoScalingEnabled</code>,
         *        <code>Parallelism</code>, or <code>ParallelismPerKPU</code> properties.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationTypeUpdate(String configurationTypeUpdate);

        /**
         * <p>
         * Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics
         * service, or if a custom parallelism is used. You must set this property to <code>CUSTOM</code> in order to
         * change your application's <code>AutoScalingEnabled</code>, <code>Parallelism</code>, or
         * <code>ParallelismPerKPU</code> properties.
         * </p>
         * 
         * @param configurationTypeUpdate
         *        Describes updates to whether the application uses the default parallelism for the Kinesis Data
         *        Analytics service, or if a custom parallelism is used. You must set this property to
         *        <code>CUSTOM</code> in order to change your application's <code>AutoScalingEnabled</code>,
         *        <code>Parallelism</code>, or <code>ParallelismPerKPU</code> properties.
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate);

        /**
         * <p>
         * Describes updates to the initial number of parallel tasks an application can perform. If
         * <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
         * <code>CurrentParallelism</code> value in response to application load. The service can increase
         * <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code> times
         * the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be
         * increased by requesting a limit increase. If application load is reduced, the service will reduce
         * <code>CurrentParallelism</code> down to the <code>Parallelism</code> setting.
         * </p>
         * 
         * @param parallelismUpdate
         *        Describes updates to the initial number of parallel tasks an application can perform. If
         *        <code>AutoScalingEnabled</code> is set to True, then Kinesis Data Analytics can increase the
         *        <code>CurrentParallelism</code> value in response to application load. The service can increase
         *        <code>CurrentParallelism</code> up to the maximum parallelism, which is <code>ParalellismPerKPU</code>
         *        times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and
         *        can be increased by requesting a limit increase. If application load is reduced, the service will
         *        reduce <code>CurrentParallelism</code> down to the <code>Parallelism</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismUpdate(Integer parallelismUpdate);

        /**
         * <p>
         * Describes updates to the number of parallel tasks an application can perform per Kinesis Processing Unit
         * (KPU) used by the application.
         * </p>
         * 
         * @param parallelismPerKPUUpdate
         *        Describes updates to the number of parallel tasks an application can perform per Kinesis Processing
         *        Unit (KPU) used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismPerKPUUpdate(Integer parallelismPerKPUUpdate);

        /**
         * <p>
         * Describes updates to whether the Kinesis Data Analytics service can increase the parallelism of a Flink-based
         * Kinesis Data Analytics application in response to increased throughput.
         * </p>
         * 
         * @param autoScalingEnabledUpdate
         *        Describes updates to whether the Kinesis Data Analytics service can increase the parallelism of a
         *        Flink-based Kinesis Data Analytics application in response to increased throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingEnabledUpdate(Boolean autoScalingEnabledUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String configurationTypeUpdate;

        private Integer parallelismUpdate;

        private Integer parallelismPerKPUUpdate;

        private Boolean autoScalingEnabledUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ParallelismConfigurationUpdate model) {
            configurationTypeUpdate(model.configurationTypeUpdate);
            parallelismUpdate(model.parallelismUpdate);
            parallelismPerKPUUpdate(model.parallelismPerKPUUpdate);
            autoScalingEnabledUpdate(model.autoScalingEnabledUpdate);
        }

        public final String getConfigurationTypeUpdate() {
            return configurationTypeUpdate;
        }

        public final void setConfigurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
        }

        @Override
        @Transient
        public final Builder configurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
            return this;
        }

        @Override
        @Transient
        public final Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate) {
            this.configurationTypeUpdate(configurationTypeUpdate == null ? null : configurationTypeUpdate.toString());
            return this;
        }

        public final Integer getParallelismUpdate() {
            return parallelismUpdate;
        }

        public final void setParallelismUpdate(Integer parallelismUpdate) {
            this.parallelismUpdate = parallelismUpdate;
        }

        @Override
        @Transient
        public final Builder parallelismUpdate(Integer parallelismUpdate) {
            this.parallelismUpdate = parallelismUpdate;
            return this;
        }

        public final Integer getParallelismPerKPUUpdate() {
            return parallelismPerKPUUpdate;
        }

        public final void setParallelismPerKPUUpdate(Integer parallelismPerKPUUpdate) {
            this.parallelismPerKPUUpdate = parallelismPerKPUUpdate;
        }

        @Override
        @Transient
        public final Builder parallelismPerKPUUpdate(Integer parallelismPerKPUUpdate) {
            this.parallelismPerKPUUpdate = parallelismPerKPUUpdate;
            return this;
        }

        public final Boolean getAutoScalingEnabledUpdate() {
            return autoScalingEnabledUpdate;
        }

        public final void setAutoScalingEnabledUpdate(Boolean autoScalingEnabledUpdate) {
            this.autoScalingEnabledUpdate = autoScalingEnabledUpdate;
        }

        @Override
        @Transient
        public final Builder autoScalingEnabledUpdate(Boolean autoScalingEnabledUpdate) {
            this.autoScalingEnabledUpdate = autoScalingEnabledUpdate;
            return this;
        }

        @Override
        public ParallelismConfigurationUpdate build() {
            return new ParallelismConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
