/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a snapshot of application state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotDetails implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotDetails.Builder, SnapshotDetails> {
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(SnapshotDetails::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> SNAPSHOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotStatus").getter(getter(SnapshotDetails::snapshotStatusAsString))
            .setter(setter(Builder::snapshotStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotStatus").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(SnapshotDetails::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<Instant> SNAPSHOT_CREATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("SnapshotCreationTimestamp")
            .getter(getter(SnapshotDetails::snapshotCreationTimestamp)).setter(setter(Builder::snapshotCreationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_NAME_FIELD,
            SNAPSHOT_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, SNAPSHOT_CREATION_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotName;

    private final String snapshotStatus;

    private final Long applicationVersionId;

    private final Instant snapshotCreationTimestamp;

    private SnapshotDetails(BuilderImpl builder) {
        this.snapshotName = builder.snapshotName;
        this.snapshotStatus = builder.snapshotStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.snapshotCreationTimestamp = builder.snapshotCreationTimestamp;
    }

    /**
     * <p>
     * The identifier for the application snapshot.
     * </p>
     * 
     * @return The identifier for the application snapshot.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The status of the application snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snapshotStatus}
     * will return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #snapshotStatusAsString}.
     * </p>
     * 
     * @return The status of the application snapshot.
     * @see SnapshotStatus
     */
    public final SnapshotStatus snapshotStatus() {
        return SnapshotStatus.fromValue(snapshotStatus);
    }

    /**
     * <p>
     * The status of the application snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snapshotStatus}
     * will return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #snapshotStatusAsString}.
     * </p>
     * 
     * @return The status of the application snapshot.
     * @see SnapshotStatus
     */
    public final String snapshotStatusAsString() {
        return snapshotStatus;
    }

    /**
     * <p>
     * The current application version ID when the snapshot was created.
     * </p>
     * 
     * @return The current application version ID when the snapshot was created.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The timestamp of the application snapshot.
     * </p>
     * 
     * @return The timestamp of the application snapshot.
     */
    public final Instant snapshotCreationTimestamp() {
        return snapshotCreationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetails)) {
            return false;
        }
        SnapshotDetails other = (SnapshotDetails) obj;
        return Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(snapshotStatusAsString(), other.snapshotStatusAsString())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(snapshotCreationTimestamp(), other.snapshotCreationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotDetails").add("SnapshotName", snapshotName())
                .add("SnapshotStatus", snapshotStatusAsString()).add("ApplicationVersionId", applicationVersionId())
                .add("SnapshotCreationTimestamp", snapshotCreationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "SnapshotStatus":
            return Optional.ofNullable(clazz.cast(snapshotStatusAsString()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "SnapshotCreationTimestamp":
            return Optional.ofNullable(clazz.cast(snapshotCreationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDetails, T> g) {
        return obj -> g.apply((SnapshotDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotDetails> {
        /**
         * <p>
         * The identifier for the application snapshot.
         * </p>
         * 
         * @param snapshotName
         *        The identifier for the application snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The status of the application snapshot.
         * </p>
         * 
         * @param snapshotStatus
         *        The status of the application snapshot.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder snapshotStatus(String snapshotStatus);

        /**
         * <p>
         * The status of the application snapshot.
         * </p>
         * 
         * @param snapshotStatus
         *        The status of the application snapshot.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder snapshotStatus(SnapshotStatus snapshotStatus);

        /**
         * <p>
         * The current application version ID when the snapshot was created.
         * </p>
         * 
         * @param applicationVersionId
         *        The current application version ID when the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The timestamp of the application snapshot.
         * </p>
         * 
         * @param snapshotCreationTimestamp
         *        The timestamp of the application snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreationTimestamp(Instant snapshotCreationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotName;

        private String snapshotStatus;

        private Long applicationVersionId;

        private Instant snapshotCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetails model) {
            snapshotName(model.snapshotName);
            snapshotStatus(model.snapshotStatus);
            applicationVersionId(model.applicationVersionId);
            snapshotCreationTimestamp(model.snapshotCreationTimestamp);
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        @Transient
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSnapshotStatus() {
            return snapshotStatus;
        }

        public final void setSnapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
        }

        @Override
        @Transient
        public final Builder snapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder snapshotStatus(SnapshotStatus snapshotStatus) {
            this.snapshotStatus(snapshotStatus == null ? null : snapshotStatus.toString());
            return this;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        @Transient
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final Instant getSnapshotCreationTimestamp() {
            return snapshotCreationTimestamp;
        }

        public final void setSnapshotCreationTimestamp(Instant snapshotCreationTimestamp) {
            this.snapshotCreationTimestamp = snapshotCreationTimestamp;
        }

        @Override
        @Transient
        public final Builder snapshotCreationTimestamp(Instant snapshotCreationTimestamp) {
            this.snapshotCreationTimestamp = snapshotCreationTimestamp;
            return this;
        }

        @Override
        public SnapshotDetails build() {
            return new SnapshotDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
