/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2Client;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeValidationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidApplicationConfigurationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidRequestException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Exception;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.LimitExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TooManyTagsException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnableToDetectSchemaException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationInputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationPresignedUrlRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DiscoverInputSchemaRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationVersionsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.RollbackApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.StartApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.StopApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UpdateApplicationMaintenanceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisAnalyticsV2Client
implements KinesisAnalyticsV2Client {
    private static final Logger log = Logger.loggerFor(DefaultKinesisAnalyticsV2Client.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisAnalyticsV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kinesisanalytics";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationCloudWatchLoggingOptionResponse addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationCloudWatchLoggingOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, addApplicationCloudWatchLoggingOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationCloudWatchLoggingOption");
            AddApplicationCloudWatchLoggingOptionResponse addApplicationCloudWatchLoggingOptionResponse = (AddApplicationCloudWatchLoggingOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationCloudWatchLoggingOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationCloudWatchLoggingOptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addApplicationCloudWatchLoggingOptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$addApplicationCloudWatchLoggingOption$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationInputResponse addApplicationInput(AddApplicationInputRequest addApplicationInputRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, CodeValidationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, addApplicationInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationInput");
            AddApplicationInputResponse addApplicationInputResponse = (AddApplicationInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddApplicationInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addApplicationInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$addApplicationInput$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationInputProcessingConfigurationResponse addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputProcessingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, addApplicationInputProcessingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationInputProcessingConfiguration");
            AddApplicationInputProcessingConfigurationResponse addApplicationInputProcessingConfigurationResponse = (AddApplicationInputProcessingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInputProcessingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationInputProcessingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addApplicationInputProcessingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$addApplicationInputProcessingConfiguration$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationOutputResponse addApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, addApplicationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationOutput");
            AddApplicationOutputResponse addApplicationOutputResponse = (AddApplicationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addApplicationOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$addApplicationOutput$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationReferenceDataSourceResponse addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationReferenceDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, addApplicationReferenceDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationReferenceDataSource");
            AddApplicationReferenceDataSourceResponse addApplicationReferenceDataSourceResponse = (AddApplicationReferenceDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationReferenceDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationReferenceDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addApplicationReferenceDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$addApplicationReferenceDataSource$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationVpcConfigurationResponse addApplicationVpcConfiguration(AddApplicationVpcConfigurationRequest addApplicationVpcConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationVpcConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, addApplicationVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationVpcConfiguration");
            AddApplicationVpcConfigurationResponse addApplicationVpcConfigurationResponse = (AddApplicationVpcConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationVpcConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addApplicationVpcConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddApplicationVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addApplicationVpcConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$addApplicationVpcConfiguration$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws CodeValidationException, ResourceInUseException, LimitExceededException, InvalidArgumentException, InvalidRequestException, TooManyTagsException, ConcurrentModificationException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplication");
            CreateApplicationResponse createApplicationResponse = (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$createApplication$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationPresignedUrlResponse createApplicationPresignedUrl(CreateApplicationPresignedUrlRequest createApplicationPresignedUrlRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationPresignedUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, createApplicationPresignedUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplicationPresignedUrl");
            CreateApplicationPresignedUrlResponse createApplicationPresignedUrlResponse = (CreateApplicationPresignedUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationPresignedUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationPresignedUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationPresignedUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationPresignedUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$createApplicationPresignedUrl$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationSnapshotResponse createApplicationSnapshot(CreateApplicationSnapshotRequest createApplicationSnapshotRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, UnsupportedOperationException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, createApplicationSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplicationSnapshot");
            CreateApplicationSnapshotResponse createApplicationSnapshotResponse = (CreateApplicationSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$createApplicationSnapshot$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws ConcurrentModificationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplication");
            DeleteApplicationResponse deleteApplicationResponse = (DeleteApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplication$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationCloudWatchLoggingOptionResponse deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationCloudWatchLoggingOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationCloudWatchLoggingOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationCloudWatchLoggingOption");
            DeleteApplicationCloudWatchLoggingOptionResponse deleteApplicationCloudWatchLoggingOptionResponse = (DeleteApplicationCloudWatchLoggingOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationCloudWatchLoggingOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationCloudWatchLoggingOptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationCloudWatchLoggingOptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplicationCloudWatchLoggingOption$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationInputProcessingConfigurationResponse deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationInputProcessingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationInputProcessingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationInputProcessingConfiguration");
            DeleteApplicationInputProcessingConfigurationResponse deleteApplicationInputProcessingConfigurationResponse = (DeleteApplicationInputProcessingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationInputProcessingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationInputProcessingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationInputProcessingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplicationInputProcessingConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationOutputResponse deleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationOutput");
            DeleteApplicationOutputResponse deleteApplicationOutputResponse = (DeleteApplicationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplicationOutput$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationReferenceDataSourceResponse deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationReferenceDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationReferenceDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationReferenceDataSource");
            DeleteApplicationReferenceDataSourceResponse deleteApplicationReferenceDataSourceResponse = (DeleteApplicationReferenceDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationReferenceDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationReferenceDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationReferenceDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplicationReferenceDataSource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationSnapshotResponse deleteApplicationSnapshot(DeleteApplicationSnapshotRequest deleteApplicationSnapshotRequest) throws ResourceInUseException, InvalidArgumentException, UnsupportedOperationException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationSnapshot");
            DeleteApplicationSnapshotResponse deleteApplicationSnapshotResponse = (DeleteApplicationSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplicationSnapshot$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationVpcConfigurationResponse deleteApplicationVpcConfiguration(DeleteApplicationVpcConfigurationRequest deleteApplicationVpcConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationVpcConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteApplicationVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationVpcConfiguration");
            DeleteApplicationVpcConfigurationResponse deleteApplicationVpcConfigurationResponse = (DeleteApplicationVpcConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationVpcConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationVpcConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationVpcConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$deleteApplicationVpcConfiguration$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationResponse describeApplication(DescribeApplicationRequest describeApplicationRequest) throws ResourceNotFoundException, InvalidArgumentException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, describeApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplication");
            DescribeApplicationResponse describeApplicationResponse = (DescribeApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$describeApplication$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationSnapshotResponse describeApplicationSnapshot(DescribeApplicationSnapshotRequest describeApplicationSnapshotRequest) throws ResourceNotFoundException, InvalidArgumentException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, describeApplicationSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationSnapshot");
            DescribeApplicationSnapshotResponse describeApplicationSnapshotResponse = (DescribeApplicationSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$describeApplicationSnapshot$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationVersionResponse describeApplicationVersion(DescribeApplicationVersionRequest describeApplicationVersionRequest) throws InvalidArgumentException, ResourceNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, describeApplicationVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationVersion");
            DescribeApplicationVersionResponse describeApplicationVersionResponse = (DescribeApplicationVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$describeApplicationVersion$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverInputSchemaResponse discoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest) throws InvalidArgumentException, UnableToDetectSchemaException, ResourceProvisionedThroughputExceededException, ServiceUnavailableException, InvalidRequestException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInputSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, discoverInputSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInputSchema");
            DiscoverInputSchemaResponse discoverInputSchemaResponse = (DiscoverInputSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInputSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)discoverInputSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DiscoverInputSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return discoverInputSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$discoverInputSchema$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationSnapshotsResponse listApplicationSnapshots(ListApplicationSnapshotsRequest listApplicationSnapshotsRequest) throws InvalidArgumentException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, listApplicationSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationSnapshots");
            ListApplicationSnapshotsResponse listApplicationSnapshotsResponse = (ListApplicationSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$listApplicationSnapshots$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationVersionsResponse listApplicationVersions(ListApplicationVersionsRequest listApplicationVersionsRequest) throws InvalidArgumentException, ResourceNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, listApplicationVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationVersions");
            ListApplicationVersionsResponse listApplicationVersionsResponse = (ListApplicationVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$listApplicationVersions$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, listApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplications");
            ListApplicationsResponse listApplicationsResponse = (ListApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$listApplications$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$listTagsForResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollbackApplicationResponse rollbackApplication(RollbackApplicationRequest rollbackApplicationRequest) throws ResourceNotFoundException, InvalidArgumentException, ResourceInUseException, InvalidRequestException, ConcurrentModificationException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RollbackApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, rollbackApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RollbackApplication");
            RollbackApplicationResponse rollbackApplicationResponse = (RollbackApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RollbackApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rollbackApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RollbackApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rollbackApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$rollbackApplication$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartApplicationResponse startApplication(StartApplicationRequest startApplicationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidApplicationConfigurationException, InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, startApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartApplication");
            StartApplicationResponse startApplicationResponse = (StartApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$startApplication$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopApplicationResponse stopApplication(StopApplicationRequest stopApplicationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidRequestException, InvalidApplicationConfigurationException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, stopApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopApplication");
            StopApplicationResponse stopApplicationResponse = (StopApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$stopApplication$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ResourceInUseException, TooManyTagsException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ResourceInUseException, TooManyTagsException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws CodeValidationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException, LimitExceededException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplication");
            UpdateApplicationResponse updateApplicationResponse = (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$updateApplication$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationMaintenanceConfigurationResponse updateApplicationMaintenanceConfiguration(UpdateApplicationMaintenanceConfigurationRequest updateApplicationMaintenanceConfigurationRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, UnsupportedOperationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationMaintenanceConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2Client.resolveMetricPublishers(this.clientConfiguration, updateApplicationMaintenanceConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplicationMaintenanceConfiguration");
            UpdateApplicationMaintenanceConfigurationResponse updateApplicationMaintenanceConfigurationResponse = (UpdateApplicationMaintenanceConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationMaintenanceConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationMaintenanceConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApplicationMaintenanceConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApplicationMaintenanceConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2Client.lambda$updateApplicationMaintenanceConfiguration$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisAnalyticsV2Exception::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeValidationException").exceptionBuilderSupplier(CodeValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateApplicationMaintenanceConfiguration$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplication$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopApplication$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startApplication$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rollbackApplication$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplications$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationVersions$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationSnapshots$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInputSchema$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationVersion$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationSnapshot$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplication$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationVpcConfiguration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationSnapshot$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationReferenceDataSource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationOutput$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationInputProcessingConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationCloudWatchLoggingOption$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplication$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplicationSnapshot$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplicationPresignedUrl$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplication$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationVpcConfiguration$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationReferenceDataSource$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationOutput$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationInputProcessingConfiguration$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationInput$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationCloudWatchLoggingOption$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

