/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationReferenceDataSourceResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<AddApplicationReferenceDataSourceResponse.Builder, AddApplicationReferenceDataSourceResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(AddApplicationReferenceDataSourceResponse::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(AddApplicationReferenceDataSourceResponse::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<List<ReferenceDataSourceDescription>> REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD = SdkField
            .<List<ReferenceDataSourceDescription>> builder(MarshallingType.LIST)
            .memberName("ReferenceDataSourceDescriptions")
            .getter(getter(AddApplicationReferenceDataSourceResponse::referenceDataSourceDescriptions))
            .setter(setter(Builder::referenceDataSourceDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceDescriptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceDataSourceDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceDataSourceDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_VERSION_ID_FIELD, REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD));

    private final String applicationARN;

    private final Long applicationVersionId;

    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;

    private AddApplicationReferenceDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
    }

    /**
     * <p>
     * The application Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * The updated application version ID. Kinesis Data Analytics increments this ID when the application is updated.
     * </p>
     * 
     * @return The updated application version ID. Kinesis Data Analytics increments this ID when the application is
     *         updated.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceDataSourceDescriptions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReferenceDataSourceDescriptions() {
        return referenceDataSourceDescriptions != null && !(referenceDataSourceDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes reference data sources configured for the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceDataSourceDescriptions}
     * method.
     * </p>
     * 
     * @return Describes reference data sources configured for the application.
     */
    public final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return referenceDataSourceDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReferenceDataSourceDescriptions() ? referenceDataSourceDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceResponse)) {
            return false;
        }
        AddApplicationReferenceDataSourceResponse other = (AddApplicationReferenceDataSourceResponse) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && hasReferenceDataSourceDescriptions() == other.hasReferenceDataSourceDescriptions()
                && Objects.equals(referenceDataSourceDescriptions(), other.referenceDataSourceDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AddApplicationReferenceDataSourceResponse")
                .add("ApplicationARN", applicationARN())
                .add("ApplicationVersionId", applicationVersionId())
                .add("ReferenceDataSourceDescriptions",
                        hasReferenceDataSourceDescriptions() ? referenceDataSourceDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "ReferenceDataSourceDescriptions":
            return Optional.ofNullable(clazz.cast(referenceDataSourceDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationReferenceDataSourceResponse, T> g) {
        return obj -> g.apply((AddApplicationReferenceDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationReferenceDataSourceResponse> {
        /**
         * <p>
         * The application Amazon Resource Name (ARN).
         * </p>
         * 
         * @param applicationARN
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * The updated application version ID. Kinesis Data Analytics increments this ID when the application is
         * updated.
         * </p>
         * 
         * @param applicationVersionId
         *        The updated application version ID. Kinesis Data Analytics increments this ID when the application is
         *        updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * Describes reference data sources configured for the application.
         * </p>
         * 
         * @param referenceDataSourceDescriptions
         *        Describes reference data sources configured for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions);

        /**
         * <p>
         * Describes reference data sources configured for the application.
         * </p>
         * 
         * @param referenceDataSourceDescriptions
         *        Describes reference data sources configured for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions);

        /**
         * <p>
         * Describes reference data sources configured for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReferenceDataSourceDescription>.Builder} avoiding the need to create one manually via {@link List
         * <ReferenceDataSourceDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReferenceDataSourceDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #referenceDataSourceDescriptions(List<ReferenceDataSourceDescription>)}.
         * 
         * @param referenceDataSourceDescriptions
         *        a consumer that will call methods on {@link List<ReferenceDataSourceDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceDataSourceDescriptions(List<ReferenceDataSourceDescription>)
         */
        Builder referenceDataSourceDescriptions(
                Consumer<ReferenceDataSourceDescription.Builder>... referenceDataSourceDescriptions);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String applicationARN;

        private Long applicationVersionId;

        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceResponse model) {
            super(model);
            applicationARN(model.applicationARN);
            applicationVersionId(model.applicationVersionId);
            referenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final List<ReferenceDataSourceDescription.Builder> getReferenceDataSourceDescriptions() {
            List<ReferenceDataSourceDescription.Builder> result = ReferenceDataSourceDescriptionsCopier
                    .copyToBuilder(this.referenceDataSourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceDataSourceDescriptions(
                Collection<ReferenceDataSourceDescription.BuilderImpl> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier
                    .copyFromBuilder(referenceDataSourceDescriptions);
        }

        @Override
        public final Builder referenceDataSourceDescriptions(
                Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions) {
            referenceDataSourceDescriptions(Arrays.asList(referenceDataSourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(
                Consumer<ReferenceDataSourceDescription.Builder>... referenceDataSourceDescriptions) {
            referenceDataSourceDescriptions(Stream.of(referenceDataSourceDescriptions)
                    .map(c -> ReferenceDataSourceDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddApplicationReferenceDataSourceResponse build() {
            return new AddApplicationReferenceDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
