/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes code configuration for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationCodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationCodeConfiguration.Builder, ApplicationCodeConfiguration> {
    private static final SdkField<CodeContent> CODE_CONTENT_FIELD = SdkField.<CodeContent> builder(MarshallingType.SDK_POJO)
            .memberName("CodeContent").getter(getter(ApplicationCodeConfiguration::codeContent))
            .setter(setter(Builder::codeContent)).constructor(CodeContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContent").build()).build();

    private static final SdkField<String> CODE_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeContentType").getter(getter(ApplicationCodeConfiguration::codeContentTypeAsString))
            .setter(setter(Builder::codeContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_CONTENT_FIELD,
            CODE_CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeContent codeContent;

    private final String codeContentType;

    private ApplicationCodeConfiguration(BuilderImpl builder) {
        this.codeContent = builder.codeContent;
        this.codeContentType = builder.codeContentType;
    }

    /**
     * <p>
     * The location and type of the application code.
     * </p>
     * 
     * @return The location and type of the application code.
     */
    public final CodeContent codeContent() {
        return codeContent;
    }

    /**
     * <p>
     * Specifies whether the code content is in text or zip format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codeContentType}
     * will return {@link CodeContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeContentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the code content is in text or zip format.
     * @see CodeContentType
     */
    public final CodeContentType codeContentType() {
        return CodeContentType.fromValue(codeContentType);
    }

    /**
     * <p>
     * Specifies whether the code content is in text or zip format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codeContentType}
     * will return {@link CodeContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeContentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the code content is in text or zip format.
     * @see CodeContentType
     */
    public final String codeContentTypeAsString() {
        return codeContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeContent());
        hashCode = 31 * hashCode + Objects.hashCode(codeContentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCodeConfiguration)) {
            return false;
        }
        ApplicationCodeConfiguration other = (ApplicationCodeConfiguration) obj;
        return Objects.equals(codeContent(), other.codeContent())
                && Objects.equals(codeContentTypeAsString(), other.codeContentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationCodeConfiguration").add("CodeContent", codeContent())
                .add("CodeContentType", codeContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeContent":
            return Optional.ofNullable(clazz.cast(codeContent()));
        case "CodeContentType":
            return Optional.ofNullable(clazz.cast(codeContentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCodeConfiguration, T> g) {
        return obj -> g.apply((ApplicationCodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationCodeConfiguration> {
        /**
         * <p>
         * The location and type of the application code.
         * </p>
         * 
         * @param codeContent
         *        The location and type of the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeContent(CodeContent codeContent);

        /**
         * <p>
         * The location and type of the application code.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeContent.Builder} avoiding the need to
         * create one manually via {@link CodeContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeContent.Builder#build()} is called immediately and its result
         * is passed to {@link #codeContent(CodeContent)}.
         * 
         * @param codeContent
         *        a consumer that will call methods on {@link CodeContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeContent(CodeContent)
         */
        default Builder codeContent(Consumer<CodeContent.Builder> codeContent) {
            return codeContent(CodeContent.builder().applyMutation(codeContent).build());
        }

        /**
         * <p>
         * Specifies whether the code content is in text or zip format.
         * </p>
         * 
         * @param codeContentType
         *        Specifies whether the code content is in text or zip format.
         * @see CodeContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeContentType
         */
        Builder codeContentType(String codeContentType);

        /**
         * <p>
         * Specifies whether the code content is in text or zip format.
         * </p>
         * 
         * @param codeContentType
         *        Specifies whether the code content is in text or zip format.
         * @see CodeContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeContentType
         */
        Builder codeContentType(CodeContentType codeContentType);
    }

    static final class BuilderImpl implements Builder {
        private CodeContent codeContent;

        private String codeContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCodeConfiguration model) {
            codeContent(model.codeContent);
            codeContentType(model.codeContentType);
        }

        public final CodeContent.Builder getCodeContent() {
            return codeContent != null ? codeContent.toBuilder() : null;
        }

        public final void setCodeContent(CodeContent.BuilderImpl codeContent) {
            this.codeContent = codeContent != null ? codeContent.build() : null;
        }

        @Override
        public final Builder codeContent(CodeContent codeContent) {
            this.codeContent = codeContent;
            return this;
        }

        public final String getCodeContentType() {
            return codeContentType;
        }

        public final void setCodeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
        }

        @Override
        public final Builder codeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
            return this;
        }

        @Override
        public final Builder codeContentType(CodeContentType codeContentType) {
            this.codeContentType(codeContentType == null ? null : codeContentType.toString());
            return this;
        }

        @Override
        public ApplicationCodeConfiguration build() {
            return new ApplicationCodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
