/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes details about the application code and starting parameters for a Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationConfigurationDescription.Builder, ApplicationConfigurationDescription> {
    private static final SdkField<SqlApplicationConfigurationDescription> SQL_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<SqlApplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("SqlApplicationConfigurationDescription")
            .getter(getter(ApplicationConfigurationDescription::sqlApplicationConfigurationDescription))
            .setter(setter(Builder::sqlApplicationConfigurationDescription))
            .constructor(SqlApplicationConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SqlApplicationConfigurationDescription").build()).build();

    private static final SdkField<ApplicationCodeConfigurationDescription> APPLICATION_CODE_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationCodeConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationCodeConfigurationDescription")
            .getter(getter(ApplicationConfigurationDescription::applicationCodeConfigurationDescription))
            .setter(setter(Builder::applicationCodeConfigurationDescription))
            .constructor(ApplicationCodeConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationCodeConfigurationDescription").build()).build();

    private static final SdkField<RunConfigurationDescription> RUN_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<RunConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("RunConfigurationDescription")
            .getter(getter(ApplicationConfigurationDescription::runConfigurationDescription))
            .setter(setter(Builder::runConfigurationDescription))
            .constructor(RunConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfigurationDescription")
                    .build()).build();

    private static final SdkField<FlinkApplicationConfigurationDescription> FLINK_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<FlinkApplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("FlinkApplicationConfigurationDescription")
            .getter(getter(ApplicationConfigurationDescription::flinkApplicationConfigurationDescription))
            .setter(setter(Builder::flinkApplicationConfigurationDescription))
            .constructor(FlinkApplicationConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("FlinkApplicationConfigurationDescription").build()).build();

    private static final SdkField<EnvironmentPropertyDescriptions> ENVIRONMENT_PROPERTY_DESCRIPTIONS_FIELD = SdkField
            .<EnvironmentPropertyDescriptions> builder(MarshallingType.SDK_POJO)
            .memberName("EnvironmentPropertyDescriptions")
            .getter(getter(ApplicationConfigurationDescription::environmentPropertyDescriptions))
            .setter(setter(Builder::environmentPropertyDescriptions))
            .constructor(EnvironmentPropertyDescriptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentPropertyDescriptions")
                    .build()).build();

    private static final SdkField<ApplicationSnapshotConfigurationDescription> APPLICATION_SNAPSHOT_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationSnapshotConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationSnapshotConfigurationDescription")
            .getter(getter(ApplicationConfigurationDescription::applicationSnapshotConfigurationDescription))
            .setter(setter(Builder::applicationSnapshotConfigurationDescription))
            .constructor(ApplicationSnapshotConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationSnapshotConfigurationDescription").build()).build();

    private static final SdkField<List<VpcConfigurationDescription>> VPC_CONFIGURATION_DESCRIPTIONS_FIELD = SdkField
            .<List<VpcConfigurationDescription>> builder(MarshallingType.LIST)
            .memberName("VpcConfigurationDescriptions")
            .getter(getter(ApplicationConfigurationDescription::vpcConfigurationDescriptions))
            .setter(setter(Builder::vpcConfigurationDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationDescriptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcConfigurationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcConfigurationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ZeppelinApplicationConfigurationDescription> ZEPPELIN_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ZeppelinApplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ZeppelinApplicationConfigurationDescription")
            .getter(getter(ApplicationConfigurationDescription::zeppelinApplicationConfigurationDescription))
            .setter(setter(Builder::zeppelinApplicationConfigurationDescription))
            .constructor(ZeppelinApplicationConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ZeppelinApplicationConfigurationDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SQL_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, APPLICATION_CODE_CONFIGURATION_DESCRIPTION_FIELD,
            RUN_CONFIGURATION_DESCRIPTION_FIELD, FLINK_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD,
            ENVIRONMENT_PROPERTY_DESCRIPTIONS_FIELD, APPLICATION_SNAPSHOT_CONFIGURATION_DESCRIPTION_FIELD,
            VPC_CONFIGURATION_DESCRIPTIONS_FIELD, ZEPPELIN_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription;

    private final ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription;

    private final RunConfigurationDescription runConfigurationDescription;

    private final FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription;

    private final EnvironmentPropertyDescriptions environmentPropertyDescriptions;

    private final ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription;

    private final List<VpcConfigurationDescription> vpcConfigurationDescriptions;

    private final ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription;

    private ApplicationConfigurationDescription(BuilderImpl builder) {
        this.sqlApplicationConfigurationDescription = builder.sqlApplicationConfigurationDescription;
        this.applicationCodeConfigurationDescription = builder.applicationCodeConfigurationDescription;
        this.runConfigurationDescription = builder.runConfigurationDescription;
        this.flinkApplicationConfigurationDescription = builder.flinkApplicationConfigurationDescription;
        this.environmentPropertyDescriptions = builder.environmentPropertyDescriptions;
        this.applicationSnapshotConfigurationDescription = builder.applicationSnapshotConfigurationDescription;
        this.vpcConfigurationDescriptions = builder.vpcConfigurationDescriptions;
        this.zeppelinApplicationConfigurationDescription = builder.zeppelinApplicationConfigurationDescription;
    }

    /**
     * <p>
     * The details about inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return The details about inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics
     *         application.
     */
    public final SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription() {
        return sqlApplicationConfigurationDescription;
    }

    /**
     * <p>
     * The details about the application code for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return The details about the application code for a Flink-based Kinesis Data Analytics application.
     */
    public final ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription() {
        return applicationCodeConfigurationDescription;
    }

    /**
     * <p>
     * The details about the starting properties for a Kinesis Data Analytics application.
     * </p>
     * 
     * @return The details about the starting properties for a Kinesis Data Analytics application.
     */
    public final RunConfigurationDescription runConfigurationDescription() {
        return runConfigurationDescription;
    }

    /**
     * <p>
     * The details about a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return The details about a Flink-based Kinesis Data Analytics application.
     */
    public final FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription() {
        return flinkApplicationConfigurationDescription;
    }

    /**
     * <p>
     * Describes execution properties for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes execution properties for a Flink-based Kinesis Data Analytics application.
     */
    public final EnvironmentPropertyDescriptions environmentPropertyDescriptions() {
        return environmentPropertyDescriptions;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     */
    public final ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription() {
        return applicationSnapshotConfigurationDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcConfigurationDescriptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcConfigurationDescriptions() {
        return vpcConfigurationDescriptions != null && !(vpcConfigurationDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of descriptions of VPC configurations available to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcConfigurationDescriptions} method.
     * </p>
     * 
     * @return The array of descriptions of VPC configurations available to the application.
     */
    public final List<VpcConfigurationDescription> vpcConfigurationDescriptions() {
        return vpcConfigurationDescriptions;
    }

    /**
     * <p>
     * The configuration parameters for a Kinesis Data Analytics Studio notebook.
     * </p>
     * 
     * @return The configuration parameters for a Kinesis Data Analytics Studio notebook.
     */
    public final ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription() {
        return zeppelinApplicationConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlApplicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCodeConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(runConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(flinkApplicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(environmentPropertyDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSnapshotConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConfigurationDescriptions() ? vpcConfigurationDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(zeppelinApplicationConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfigurationDescription)) {
            return false;
        }
        ApplicationConfigurationDescription other = (ApplicationConfigurationDescription) obj;
        return Objects.equals(sqlApplicationConfigurationDescription(), other.sqlApplicationConfigurationDescription())
                && Objects.equals(applicationCodeConfigurationDescription(), other.applicationCodeConfigurationDescription())
                && Objects.equals(runConfigurationDescription(), other.runConfigurationDescription())
                && Objects.equals(flinkApplicationConfigurationDescription(), other.flinkApplicationConfigurationDescription())
                && Objects.equals(environmentPropertyDescriptions(), other.environmentPropertyDescriptions())
                && Objects.equals(applicationSnapshotConfigurationDescription(),
                        other.applicationSnapshotConfigurationDescription())
                && hasVpcConfigurationDescriptions() == other.hasVpcConfigurationDescriptions()
                && Objects.equals(vpcConfigurationDescriptions(), other.vpcConfigurationDescriptions())
                && Objects.equals(zeppelinApplicationConfigurationDescription(),
                        other.zeppelinApplicationConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationConfigurationDescription")
                .add("SqlApplicationConfigurationDescription", sqlApplicationConfigurationDescription())
                .add("ApplicationCodeConfigurationDescription", applicationCodeConfigurationDescription())
                .add("RunConfigurationDescription", runConfigurationDescription())
                .add("FlinkApplicationConfigurationDescription", flinkApplicationConfigurationDescription())
                .add("EnvironmentPropertyDescriptions", environmentPropertyDescriptions())
                .add("ApplicationSnapshotConfigurationDescription", applicationSnapshotConfigurationDescription())
                .add("VpcConfigurationDescriptions", hasVpcConfigurationDescriptions() ? vpcConfigurationDescriptions() : null)
                .add("ZeppelinApplicationConfigurationDescription", zeppelinApplicationConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlApplicationConfigurationDescription":
            return Optional.ofNullable(clazz.cast(sqlApplicationConfigurationDescription()));
        case "ApplicationCodeConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationCodeConfigurationDescription()));
        case "RunConfigurationDescription":
            return Optional.ofNullable(clazz.cast(runConfigurationDescription()));
        case "FlinkApplicationConfigurationDescription":
            return Optional.ofNullable(clazz.cast(flinkApplicationConfigurationDescription()));
        case "EnvironmentPropertyDescriptions":
            return Optional.ofNullable(clazz.cast(environmentPropertyDescriptions()));
        case "ApplicationSnapshotConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationSnapshotConfigurationDescription()));
        case "VpcConfigurationDescriptions":
            return Optional.ofNullable(clazz.cast(vpcConfigurationDescriptions()));
        case "ZeppelinApplicationConfigurationDescription":
            return Optional.ofNullable(clazz.cast(zeppelinApplicationConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationConfigurationDescription> {
        /**
         * <p>
         * The details about inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics
         * application.
         * </p>
         * 
         * @param sqlApplicationConfigurationDescription
         *        The details about inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlApplicationConfigurationDescription(
                SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription);

        /**
         * <p>
         * The details about inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics
         * application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SqlApplicationConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link SqlApplicationConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlApplicationConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sqlApplicationConfigurationDescription(SqlApplicationConfigurationDescription)}.
         * 
         * @param sqlApplicationConfigurationDescription
         *        a consumer that will call methods on {@link SqlApplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlApplicationConfigurationDescription(SqlApplicationConfigurationDescription)
         */
        default Builder sqlApplicationConfigurationDescription(
                Consumer<SqlApplicationConfigurationDescription.Builder> sqlApplicationConfigurationDescription) {
            return sqlApplicationConfigurationDescription(SqlApplicationConfigurationDescription.builder()
                    .applyMutation(sqlApplicationConfigurationDescription).build());
        }

        /**
         * <p>
         * The details about the application code for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param applicationCodeConfigurationDescription
         *        The details about the application code for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCodeConfigurationDescription(
                ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription);

        /**
         * <p>
         * The details about the application code for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationCodeConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ApplicationCodeConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationCodeConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #applicationCodeConfigurationDescription(ApplicationCodeConfigurationDescription)}.
         * 
         * @param applicationCodeConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationCodeConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationCodeConfigurationDescription(ApplicationCodeConfigurationDescription)
         */
        default Builder applicationCodeConfigurationDescription(
                Consumer<ApplicationCodeConfigurationDescription.Builder> applicationCodeConfigurationDescription) {
            return applicationCodeConfigurationDescription(ApplicationCodeConfigurationDescription.builder()
                    .applyMutation(applicationCodeConfigurationDescription).build());
        }

        /**
         * <p>
         * The details about the starting properties for a Kinesis Data Analytics application.
         * </p>
         * 
         * @param runConfigurationDescription
         *        The details about the starting properties for a Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfigurationDescription(RunConfigurationDescription runConfigurationDescription);

        /**
         * <p>
         * The details about the starting properties for a Kinesis Data Analytics application.
         * </p>
         * This is a convenience method that creates an instance of the {@link RunConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link RunConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #runConfigurationDescription(RunConfigurationDescription)}.
         * 
         * @param runConfigurationDescription
         *        a consumer that will call methods on {@link RunConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfigurationDescription(RunConfigurationDescription)
         */
        default Builder runConfigurationDescription(Consumer<RunConfigurationDescription.Builder> runConfigurationDescription) {
            return runConfigurationDescription(RunConfigurationDescription.builder().applyMutation(runConfigurationDescription)
                    .build());
        }

        /**
         * <p>
         * The details about a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param flinkApplicationConfigurationDescription
         *        The details about a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkApplicationConfigurationDescription(
                FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription);

        /**
         * <p>
         * The details about a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FlinkApplicationConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link FlinkApplicationConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlinkApplicationConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #flinkApplicationConfigurationDescription(FlinkApplicationConfigurationDescription)}.
         * 
         * @param flinkApplicationConfigurationDescription
         *        a consumer that will call methods on {@link FlinkApplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkApplicationConfigurationDescription(FlinkApplicationConfigurationDescription)
         */
        default Builder flinkApplicationConfigurationDescription(
                Consumer<FlinkApplicationConfigurationDescription.Builder> flinkApplicationConfigurationDescription) {
            return flinkApplicationConfigurationDescription(FlinkApplicationConfigurationDescription.builder()
                    .applyMutation(flinkApplicationConfigurationDescription).build());
        }

        /**
         * <p>
         * Describes execution properties for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param environmentPropertyDescriptions
         *        Describes execution properties for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentPropertyDescriptions(EnvironmentPropertyDescriptions environmentPropertyDescriptions);

        /**
         * <p>
         * Describes execution properties for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentPropertyDescriptions.Builder}
         * avoiding the need to create one manually via {@link EnvironmentPropertyDescriptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentPropertyDescriptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #environmentPropertyDescriptions(EnvironmentPropertyDescriptions)}.
         * 
         * @param environmentPropertyDescriptions
         *        a consumer that will call methods on {@link EnvironmentPropertyDescriptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentPropertyDescriptions(EnvironmentPropertyDescriptions)
         */
        default Builder environmentPropertyDescriptions(
                Consumer<EnvironmentPropertyDescriptions.Builder> environmentPropertyDescriptions) {
            return environmentPropertyDescriptions(EnvironmentPropertyDescriptions.builder()
                    .applyMutation(environmentPropertyDescriptions).build());
        }

        /**
         * <p>
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param applicationSnapshotConfigurationDescription
         *        Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSnapshotConfigurationDescription(
                ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription);

        /**
         * <p>
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationSnapshotConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ApplicationSnapshotConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSnapshotConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #applicationSnapshotConfigurationDescription(ApplicationSnapshotConfigurationDescription)}.
         * 
         * @param applicationSnapshotConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationSnapshotConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSnapshotConfigurationDescription(ApplicationSnapshotConfigurationDescription)
         */
        default Builder applicationSnapshotConfigurationDescription(
                Consumer<ApplicationSnapshotConfigurationDescription.Builder> applicationSnapshotConfigurationDescription) {
            return applicationSnapshotConfigurationDescription(ApplicationSnapshotConfigurationDescription.builder()
                    .applyMutation(applicationSnapshotConfigurationDescription).build());
        }

        /**
         * <p>
         * The array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurationDescriptions
         *        The array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationDescriptions(Collection<VpcConfigurationDescription> vpcConfigurationDescriptions);

        /**
         * <p>
         * The array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurationDescriptions
         *        The array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationDescriptions(VpcConfigurationDescription... vpcConfigurationDescriptions);

        /**
         * <p>
         * The array of descriptions of VPC configurations available to the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <VpcConfigurationDescription>.Builder} avoiding the need to create one manually via {@link List
         * <VpcConfigurationDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcConfigurationDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #vpcConfigurationDescriptions(List<VpcConfigurationDescription>)}.
         * 
         * @param vpcConfigurationDescriptions
         *        a consumer that will call methods on {@link List<VpcConfigurationDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfigurationDescriptions(List<VpcConfigurationDescription>)
         */
        Builder vpcConfigurationDescriptions(Consumer<VpcConfigurationDescription.Builder>... vpcConfigurationDescriptions);

        /**
         * <p>
         * The configuration parameters for a Kinesis Data Analytics Studio notebook.
         * </p>
         * 
         * @param zeppelinApplicationConfigurationDescription
         *        The configuration parameters for a Kinesis Data Analytics Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeppelinApplicationConfigurationDescription(
                ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription);

        /**
         * <p>
         * The configuration parameters for a Kinesis Data Analytics Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ZeppelinApplicationConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ZeppelinApplicationConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ZeppelinApplicationConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #zeppelinApplicationConfigurationDescription(ZeppelinApplicationConfigurationDescription)}.
         * 
         * @param zeppelinApplicationConfigurationDescription
         *        a consumer that will call methods on {@link ZeppelinApplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zeppelinApplicationConfigurationDescription(ZeppelinApplicationConfigurationDescription)
         */
        default Builder zeppelinApplicationConfigurationDescription(
                Consumer<ZeppelinApplicationConfigurationDescription.Builder> zeppelinApplicationConfigurationDescription) {
            return zeppelinApplicationConfigurationDescription(ZeppelinApplicationConfigurationDescription.builder()
                    .applyMutation(zeppelinApplicationConfigurationDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription;

        private ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription;

        private RunConfigurationDescription runConfigurationDescription;

        private FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription;

        private EnvironmentPropertyDescriptions environmentPropertyDescriptions;

        private ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription;

        private List<VpcConfigurationDescription> vpcConfigurationDescriptions = DefaultSdkAutoConstructList.getInstance();

        private ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfigurationDescription model) {
            sqlApplicationConfigurationDescription(model.sqlApplicationConfigurationDescription);
            applicationCodeConfigurationDescription(model.applicationCodeConfigurationDescription);
            runConfigurationDescription(model.runConfigurationDescription);
            flinkApplicationConfigurationDescription(model.flinkApplicationConfigurationDescription);
            environmentPropertyDescriptions(model.environmentPropertyDescriptions);
            applicationSnapshotConfigurationDescription(model.applicationSnapshotConfigurationDescription);
            vpcConfigurationDescriptions(model.vpcConfigurationDescriptions);
            zeppelinApplicationConfigurationDescription(model.zeppelinApplicationConfigurationDescription);
        }

        public final SqlApplicationConfigurationDescription.Builder getSqlApplicationConfigurationDescription() {
            return sqlApplicationConfigurationDescription != null ? sqlApplicationConfigurationDescription.toBuilder() : null;
        }

        public final void setSqlApplicationConfigurationDescription(
                SqlApplicationConfigurationDescription.BuilderImpl sqlApplicationConfigurationDescription) {
            this.sqlApplicationConfigurationDescription = sqlApplicationConfigurationDescription != null ? sqlApplicationConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder sqlApplicationConfigurationDescription(
                SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription) {
            this.sqlApplicationConfigurationDescription = sqlApplicationConfigurationDescription;
            return this;
        }

        public final ApplicationCodeConfigurationDescription.Builder getApplicationCodeConfigurationDescription() {
            return applicationCodeConfigurationDescription != null ? applicationCodeConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationCodeConfigurationDescription(
                ApplicationCodeConfigurationDescription.BuilderImpl applicationCodeConfigurationDescription) {
            this.applicationCodeConfigurationDescription = applicationCodeConfigurationDescription != null ? applicationCodeConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder applicationCodeConfigurationDescription(
                ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription) {
            this.applicationCodeConfigurationDescription = applicationCodeConfigurationDescription;
            return this;
        }

        public final RunConfigurationDescription.Builder getRunConfigurationDescription() {
            return runConfigurationDescription != null ? runConfigurationDescription.toBuilder() : null;
        }

        public final void setRunConfigurationDescription(RunConfigurationDescription.BuilderImpl runConfigurationDescription) {
            this.runConfigurationDescription = runConfigurationDescription != null ? runConfigurationDescription.build() : null;
        }

        @Override
        public final Builder runConfigurationDescription(RunConfigurationDescription runConfigurationDescription) {
            this.runConfigurationDescription = runConfigurationDescription;
            return this;
        }

        public final FlinkApplicationConfigurationDescription.Builder getFlinkApplicationConfigurationDescription() {
            return flinkApplicationConfigurationDescription != null ? flinkApplicationConfigurationDescription.toBuilder() : null;
        }

        public final void setFlinkApplicationConfigurationDescription(
                FlinkApplicationConfigurationDescription.BuilderImpl flinkApplicationConfigurationDescription) {
            this.flinkApplicationConfigurationDescription = flinkApplicationConfigurationDescription != null ? flinkApplicationConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder flinkApplicationConfigurationDescription(
                FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription) {
            this.flinkApplicationConfigurationDescription = flinkApplicationConfigurationDescription;
            return this;
        }

        public final EnvironmentPropertyDescriptions.Builder getEnvironmentPropertyDescriptions() {
            return environmentPropertyDescriptions != null ? environmentPropertyDescriptions.toBuilder() : null;
        }

        public final void setEnvironmentPropertyDescriptions(
                EnvironmentPropertyDescriptions.BuilderImpl environmentPropertyDescriptions) {
            this.environmentPropertyDescriptions = environmentPropertyDescriptions != null ? environmentPropertyDescriptions
                    .build() : null;
        }

        @Override
        public final Builder environmentPropertyDescriptions(EnvironmentPropertyDescriptions environmentPropertyDescriptions) {
            this.environmentPropertyDescriptions = environmentPropertyDescriptions;
            return this;
        }

        public final ApplicationSnapshotConfigurationDescription.Builder getApplicationSnapshotConfigurationDescription() {
            return applicationSnapshotConfigurationDescription != null ? applicationSnapshotConfigurationDescription.toBuilder()
                    : null;
        }

        public final void setApplicationSnapshotConfigurationDescription(
                ApplicationSnapshotConfigurationDescription.BuilderImpl applicationSnapshotConfigurationDescription) {
            this.applicationSnapshotConfigurationDescription = applicationSnapshotConfigurationDescription != null ? applicationSnapshotConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder applicationSnapshotConfigurationDescription(
                ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription) {
            this.applicationSnapshotConfigurationDescription = applicationSnapshotConfigurationDescription;
            return this;
        }

        public final List<VpcConfigurationDescription.Builder> getVpcConfigurationDescriptions() {
            List<VpcConfigurationDescription.Builder> result = VpcConfigurationDescriptionsCopier
                    .copyToBuilder(this.vpcConfigurationDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConfigurationDescriptions(
                Collection<VpcConfigurationDescription.BuilderImpl> vpcConfigurationDescriptions) {
            this.vpcConfigurationDescriptions = VpcConfigurationDescriptionsCopier.copyFromBuilder(vpcConfigurationDescriptions);
        }

        @Override
        public final Builder vpcConfigurationDescriptions(Collection<VpcConfigurationDescription> vpcConfigurationDescriptions) {
            this.vpcConfigurationDescriptions = VpcConfigurationDescriptionsCopier.copy(vpcConfigurationDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationDescriptions(VpcConfigurationDescription... vpcConfigurationDescriptions) {
            vpcConfigurationDescriptions(Arrays.asList(vpcConfigurationDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationDescriptions(
                Consumer<VpcConfigurationDescription.Builder>... vpcConfigurationDescriptions) {
            vpcConfigurationDescriptions(Stream.of(vpcConfigurationDescriptions)
                    .map(c -> VpcConfigurationDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ZeppelinApplicationConfigurationDescription.Builder getZeppelinApplicationConfigurationDescription() {
            return zeppelinApplicationConfigurationDescription != null ? zeppelinApplicationConfigurationDescription.toBuilder()
                    : null;
        }

        public final void setZeppelinApplicationConfigurationDescription(
                ZeppelinApplicationConfigurationDescription.BuilderImpl zeppelinApplicationConfigurationDescription) {
            this.zeppelinApplicationConfigurationDescription = zeppelinApplicationConfigurationDescription != null ? zeppelinApplicationConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder zeppelinApplicationConfigurationDescription(
                ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription) {
            this.zeppelinApplicationConfigurationDescription = zeppelinApplicationConfigurationDescription;
            return this;
        }

        @Override
        public ApplicationConfigurationDescription build() {
            return new ApplicationConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
