/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to the configuration parameters for the default Amazon Glue database. You use this database for SQL queries
 * that you write in a Kinesis Data Analytics Studio notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogConfigurationUpdate.Builder, CatalogConfigurationUpdate> {
    private static final SdkField<GlueDataCatalogConfigurationUpdate> GLUE_DATA_CATALOG_CONFIGURATION_UPDATE_FIELD = SdkField
            .<GlueDataCatalogConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("GlueDataCatalogConfigurationUpdate")
            .getter(getter(CatalogConfigurationUpdate::glueDataCatalogConfigurationUpdate))
            .setter(setter(Builder::glueDataCatalogConfigurationUpdate))
            .constructor(GlueDataCatalogConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueDataCatalogConfigurationUpdate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GLUE_DATA_CATALOG_CONFIGURATION_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final GlueDataCatalogConfigurationUpdate glueDataCatalogConfigurationUpdate;

    private CatalogConfigurationUpdate(BuilderImpl builder) {
        this.glueDataCatalogConfigurationUpdate = builder.glueDataCatalogConfigurationUpdate;
    }

    /**
     * <p>
     * Updates to the configuration parameters for the default Amazon Glue database. You use this database for SQL
     * queries that you write in a Kinesis Data Analytics Studio notebook.
     * </p>
     * 
     * @return Updates to the configuration parameters for the default Amazon Glue database. You use this database for
     *         SQL queries that you write in a Kinesis Data Analytics Studio notebook.
     */
    public final GlueDataCatalogConfigurationUpdate glueDataCatalogConfigurationUpdate() {
        return glueDataCatalogConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueDataCatalogConfigurationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogConfigurationUpdate)) {
            return false;
        }
        CatalogConfigurationUpdate other = (CatalogConfigurationUpdate) obj;
        return Objects.equals(glueDataCatalogConfigurationUpdate(), other.glueDataCatalogConfigurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogConfigurationUpdate")
                .add("GlueDataCatalogConfigurationUpdate", glueDataCatalogConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlueDataCatalogConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(glueDataCatalogConfigurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogConfigurationUpdate, T> g) {
        return obj -> g.apply((CatalogConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogConfigurationUpdate> {
        /**
         * <p>
         * Updates to the configuration parameters for the default Amazon Glue database. You use this database for SQL
         * queries that you write in a Kinesis Data Analytics Studio notebook.
         * </p>
         * 
         * @param glueDataCatalogConfigurationUpdate
         *        Updates to the configuration parameters for the default Amazon Glue database. You use this database
         *        for SQL queries that you write in a Kinesis Data Analytics Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueDataCatalogConfigurationUpdate(GlueDataCatalogConfigurationUpdate glueDataCatalogConfigurationUpdate);

        /**
         * <p>
         * Updates to the configuration parameters for the default Amazon Glue database. You use this database for SQL
         * queries that you write in a Kinesis Data Analytics Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GlueDataCatalogConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link GlueDataCatalogConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link GlueDataCatalogConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #glueDataCatalogConfigurationUpdate(GlueDataCatalogConfigurationUpdate)}.
         * 
         * @param glueDataCatalogConfigurationUpdate
         *        a consumer that will call methods on {@link GlueDataCatalogConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueDataCatalogConfigurationUpdate(GlueDataCatalogConfigurationUpdate)
         */
        default Builder glueDataCatalogConfigurationUpdate(
                Consumer<GlueDataCatalogConfigurationUpdate.Builder> glueDataCatalogConfigurationUpdate) {
            return glueDataCatalogConfigurationUpdate(GlueDataCatalogConfigurationUpdate.builder()
                    .applyMutation(glueDataCatalogConfigurationUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueDataCatalogConfigurationUpdate glueDataCatalogConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogConfigurationUpdate model) {
            glueDataCatalogConfigurationUpdate(model.glueDataCatalogConfigurationUpdate);
        }

        public final GlueDataCatalogConfigurationUpdate.Builder getGlueDataCatalogConfigurationUpdate() {
            return glueDataCatalogConfigurationUpdate != null ? glueDataCatalogConfigurationUpdate.toBuilder() : null;
        }

        public final void setGlueDataCatalogConfigurationUpdate(
                GlueDataCatalogConfigurationUpdate.BuilderImpl glueDataCatalogConfigurationUpdate) {
            this.glueDataCatalogConfigurationUpdate = glueDataCatalogConfigurationUpdate != null ? glueDataCatalogConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder glueDataCatalogConfigurationUpdate(
                GlueDataCatalogConfigurationUpdate glueDataCatalogConfigurationUpdate) {
            this.glueDataCatalogConfigurationUpdate = glueDataCatalogConfigurationUpdate;
            return this;
        }

        @Override
        public CatalogConfigurationUpdate build() {
            return new CatalogConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
