/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes details about the code of a Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeContentDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeContentDescription.Builder, CodeContentDescription> {
    private static final SdkField<String> TEXT_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextContent").getter(getter(CodeContentDescription::textContent)).setter(setter(Builder::textContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextContent").build()).build();

    private static final SdkField<String> CODE_MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeMD5").getter(getter(CodeContentDescription::codeMD5)).setter(setter(Builder::codeMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeMD5").build()).build();

    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("CodeSize")
            .getter(getter(CodeContentDescription::codeSize)).setter(setter(Builder::codeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()).build();

    private static final SdkField<S3ApplicationCodeLocationDescription> S3_APPLICATION_CODE_LOCATION_DESCRIPTION_FIELD = SdkField
            .<S3ApplicationCodeLocationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("S3ApplicationCodeLocationDescription")
            .getter(getter(CodeContentDescription::s3ApplicationCodeLocationDescription))
            .setter(setter(Builder::s3ApplicationCodeLocationDescription))
            .constructor(S3ApplicationCodeLocationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("S3ApplicationCodeLocationDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_CONTENT_FIELD,
            CODE_MD5_FIELD, CODE_SIZE_FIELD, S3_APPLICATION_CODE_LOCATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String textContent;

    private final String codeMD5;

    private final Long codeSize;

    private final S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription;

    private CodeContentDescription(BuilderImpl builder) {
        this.textContent = builder.textContent;
        this.codeMD5 = builder.codeMD5;
        this.codeSize = builder.codeSize;
        this.s3ApplicationCodeLocationDescription = builder.s3ApplicationCodeLocationDescription;
    }

    /**
     * <p>
     * The text-format code
     * </p>
     * 
     * @return The text-format code
     */
    public final String textContent() {
        return textContent;
    }

    /**
     * <p>
     * The checksum that can be used to validate zip-format code.
     * </p>
     * 
     * @return The checksum that can be used to validate zip-format code.
     */
    public final String codeMD5() {
        return codeMD5;
    }

    /**
     * <p>
     * The size in bytes of the application code. Can be used to validate zip-format code.
     * </p>
     * 
     * @return The size in bytes of the application code. Can be used to validate zip-format code.
     */
    public final Long codeSize() {
        return codeSize;
    }

    /**
     * <p>
     * The S3 bucket Amazon Resource Name (ARN), file key, and object version of the application code stored in Amazon
     * S3.
     * </p>
     * 
     * @return The S3 bucket Amazon Resource Name (ARN), file key, and object version of the application code stored in
     *         Amazon S3.
     */
    public final S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription() {
        return s3ApplicationCodeLocationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textContent());
        hashCode = 31 * hashCode + Objects.hashCode(codeMD5());
        hashCode = 31 * hashCode + Objects.hashCode(codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(s3ApplicationCodeLocationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeContentDescription)) {
            return false;
        }
        CodeContentDescription other = (CodeContentDescription) obj;
        return Objects.equals(textContent(), other.textContent()) && Objects.equals(codeMD5(), other.codeMD5())
                && Objects.equals(codeSize(), other.codeSize())
                && Objects.equals(s3ApplicationCodeLocationDescription(), other.s3ApplicationCodeLocationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeContentDescription").add("TextContent", textContent()).add("CodeMD5", codeMD5())
                .add("CodeSize", codeSize()).add("S3ApplicationCodeLocationDescription", s3ApplicationCodeLocationDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextContent":
            return Optional.ofNullable(clazz.cast(textContent()));
        case "CodeMD5":
            return Optional.ofNullable(clazz.cast(codeMD5()));
        case "CodeSize":
            return Optional.ofNullable(clazz.cast(codeSize()));
        case "S3ApplicationCodeLocationDescription":
            return Optional.ofNullable(clazz.cast(s3ApplicationCodeLocationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeContentDescription, T> g) {
        return obj -> g.apply((CodeContentDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeContentDescription> {
        /**
         * <p>
         * The text-format code
         * </p>
         * 
         * @param textContent
         *        The text-format code
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textContent(String textContent);

        /**
         * <p>
         * The checksum that can be used to validate zip-format code.
         * </p>
         * 
         * @param codeMD5
         *        The checksum that can be used to validate zip-format code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeMD5(String codeMD5);

        /**
         * <p>
         * The size in bytes of the application code. Can be used to validate zip-format code.
         * </p>
         * 
         * @param codeSize
         *        The size in bytes of the application code. Can be used to validate zip-format code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSize(Long codeSize);

        /**
         * <p>
         * The S3 bucket Amazon Resource Name (ARN), file key, and object version of the application code stored in
         * Amazon S3.
         * </p>
         * 
         * @param s3ApplicationCodeLocationDescription
         *        The S3 bucket Amazon Resource Name (ARN), file key, and object version of the application code stored
         *        in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription);

        /**
         * <p>
         * The S3 bucket Amazon Resource Name (ARN), file key, and object version of the application code stored in
         * Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link S3ApplicationCodeLocationDescription.Builder} avoiding the need to create one manually via
         * {@link S3ApplicationCodeLocationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ApplicationCodeLocationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription)}.
         * 
         * @param s3ApplicationCodeLocationDescription
         *        a consumer that will call methods on {@link S3ApplicationCodeLocationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription)
         */
        default Builder s3ApplicationCodeLocationDescription(
                Consumer<S3ApplicationCodeLocationDescription.Builder> s3ApplicationCodeLocationDescription) {
            return s3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription.builder()
                    .applyMutation(s3ApplicationCodeLocationDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String textContent;

        private String codeMD5;

        private Long codeSize;

        private S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeContentDescription model) {
            textContent(model.textContent);
            codeMD5(model.codeMD5);
            codeSize(model.codeSize);
            s3ApplicationCodeLocationDescription(model.s3ApplicationCodeLocationDescription);
        }

        public final String getTextContent() {
            return textContent;
        }

        public final void setTextContent(String textContent) {
            this.textContent = textContent;
        }

        @Override
        public final Builder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public final String getCodeMD5() {
            return codeMD5;
        }

        public final void setCodeMD5(String codeMD5) {
            this.codeMD5 = codeMD5;
        }

        @Override
        public final Builder codeMD5(String codeMD5) {
            this.codeMD5 = codeMD5;
            return this;
        }

        public final Long getCodeSize() {
            return codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final S3ApplicationCodeLocationDescription.Builder getS3ApplicationCodeLocationDescription() {
            return s3ApplicationCodeLocationDescription != null ? s3ApplicationCodeLocationDescription.toBuilder() : null;
        }

        public final void setS3ApplicationCodeLocationDescription(
                S3ApplicationCodeLocationDescription.BuilderImpl s3ApplicationCodeLocationDescription) {
            this.s3ApplicationCodeLocationDescription = s3ApplicationCodeLocationDescription != null ? s3ApplicationCodeLocationDescription
                    .build() : null;
        }

        @Override
        public final Builder s3ApplicationCodeLocationDescription(
                S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription) {
            this.s3ApplicationCodeLocationDescription = s3ApplicationCodeLocationDescription;
            return this;
        }

        @Override
        public CodeContentDescription build() {
            return new CodeContentDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
