/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update to the code of an application. Not supported for Apache Zeppelin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeContentUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeContentUpdate.Builder, CodeContentUpdate> {
    private static final SdkField<String> TEXT_CONTENT_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextContentUpdate").getter(getter(CodeContentUpdate::textContentUpdate))
            .setter(setter(Builder::textContentUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextContentUpdate").build()).build();

    private static final SdkField<SdkBytes> ZIP_FILE_CONTENT_UPDATE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES).memberName("ZipFileContentUpdate")
            .getter(getter(CodeContentUpdate::zipFileContentUpdate)).setter(setter(Builder::zipFileContentUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFileContentUpdate").build())
            .build();

    private static final SdkField<S3ContentLocationUpdate> S3_CONTENT_LOCATION_UPDATE_FIELD = SdkField
            .<S3ContentLocationUpdate> builder(MarshallingType.SDK_POJO).memberName("S3ContentLocationUpdate")
            .getter(getter(CodeContentUpdate::s3ContentLocationUpdate)).setter(setter(Builder::s3ContentLocationUpdate))
            .constructor(S3ContentLocationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocationUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_CONTENT_UPDATE_FIELD,
            ZIP_FILE_CONTENT_UPDATE_FIELD, S3_CONTENT_LOCATION_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String textContentUpdate;

    private final SdkBytes zipFileContentUpdate;

    private final S3ContentLocationUpdate s3ContentLocationUpdate;

    private CodeContentUpdate(BuilderImpl builder) {
        this.textContentUpdate = builder.textContentUpdate;
        this.zipFileContentUpdate = builder.zipFileContentUpdate;
        this.s3ContentLocationUpdate = builder.s3ContentLocationUpdate;
    }

    /**
     * <p>
     * Describes an update to the text code for an application.
     * </p>
     * 
     * @return Describes an update to the text code for an application.
     */
    public final String textContentUpdate() {
        return textContentUpdate;
    }

    /**
     * <p>
     * Describes an update to the zipped code for an application.
     * </p>
     * 
     * @return Describes an update to the zipped code for an application.
     */
    public final SdkBytes zipFileContentUpdate() {
        return zipFileContentUpdate;
    }

    /**
     * <p>
     * Describes an update to the location of code for an application.
     * </p>
     * 
     * @return Describes an update to the location of code for an application.
     */
    public final S3ContentLocationUpdate s3ContentLocationUpdate() {
        return s3ContentLocationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textContentUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(zipFileContentUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(s3ContentLocationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeContentUpdate)) {
            return false;
        }
        CodeContentUpdate other = (CodeContentUpdate) obj;
        return Objects.equals(textContentUpdate(), other.textContentUpdate())
                && Objects.equals(zipFileContentUpdate(), other.zipFileContentUpdate())
                && Objects.equals(s3ContentLocationUpdate(), other.s3ContentLocationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeContentUpdate").add("TextContentUpdate", textContentUpdate())
                .add("ZipFileContentUpdate", zipFileContentUpdate()).add("S3ContentLocationUpdate", s3ContentLocationUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextContentUpdate":
            return Optional.ofNullable(clazz.cast(textContentUpdate()));
        case "ZipFileContentUpdate":
            return Optional.ofNullable(clazz.cast(zipFileContentUpdate()));
        case "S3ContentLocationUpdate":
            return Optional.ofNullable(clazz.cast(s3ContentLocationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeContentUpdate, T> g) {
        return obj -> g.apply((CodeContentUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeContentUpdate> {
        /**
         * <p>
         * Describes an update to the text code for an application.
         * </p>
         * 
         * @param textContentUpdate
         *        Describes an update to the text code for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textContentUpdate(String textContentUpdate);

        /**
         * <p>
         * Describes an update to the zipped code for an application.
         * </p>
         * 
         * @param zipFileContentUpdate
         *        Describes an update to the zipped code for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipFileContentUpdate(SdkBytes zipFileContentUpdate);

        /**
         * <p>
         * Describes an update to the location of code for an application.
         * </p>
         * 
         * @param s3ContentLocationUpdate
         *        Describes an update to the location of code for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ContentLocationUpdate(S3ContentLocationUpdate s3ContentLocationUpdate);

        /**
         * <p>
         * Describes an update to the location of code for an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ContentLocationUpdate.Builder} avoiding
         * the need to create one manually via {@link S3ContentLocationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ContentLocationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #s3ContentLocationUpdate(S3ContentLocationUpdate)}.
         * 
         * @param s3ContentLocationUpdate
         *        a consumer that will call methods on {@link S3ContentLocationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ContentLocationUpdate(S3ContentLocationUpdate)
         */
        default Builder s3ContentLocationUpdate(Consumer<S3ContentLocationUpdate.Builder> s3ContentLocationUpdate) {
            return s3ContentLocationUpdate(S3ContentLocationUpdate.builder().applyMutation(s3ContentLocationUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String textContentUpdate;

        private SdkBytes zipFileContentUpdate;

        private S3ContentLocationUpdate s3ContentLocationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeContentUpdate model) {
            textContentUpdate(model.textContentUpdate);
            zipFileContentUpdate(model.zipFileContentUpdate);
            s3ContentLocationUpdate(model.s3ContentLocationUpdate);
        }

        public final String getTextContentUpdate() {
            return textContentUpdate;
        }

        public final void setTextContentUpdate(String textContentUpdate) {
            this.textContentUpdate = textContentUpdate;
        }

        @Override
        public final Builder textContentUpdate(String textContentUpdate) {
            this.textContentUpdate = textContentUpdate;
            return this;
        }

        public final ByteBuffer getZipFileContentUpdate() {
            return zipFileContentUpdate == null ? null : zipFileContentUpdate.asByteBuffer();
        }

        public final void setZipFileContentUpdate(ByteBuffer zipFileContentUpdate) {
            zipFileContentUpdate(zipFileContentUpdate == null ? null : SdkBytes.fromByteBuffer(zipFileContentUpdate));
        }

        @Override
        public final Builder zipFileContentUpdate(SdkBytes zipFileContentUpdate) {
            this.zipFileContentUpdate = zipFileContentUpdate;
            return this;
        }

        public final S3ContentLocationUpdate.Builder getS3ContentLocationUpdate() {
            return s3ContentLocationUpdate != null ? s3ContentLocationUpdate.toBuilder() : null;
        }

        public final void setS3ContentLocationUpdate(S3ContentLocationUpdate.BuilderImpl s3ContentLocationUpdate) {
            this.s3ContentLocationUpdate = s3ContentLocationUpdate != null ? s3ContentLocationUpdate.build() : null;
        }

        @Override
        public final Builder s3ContentLocationUpdate(S3ContentLocationUpdate s3ContentLocationUpdate) {
            this.s3ContentLocationUpdate = s3ContentLocationUpdate;
            return this;
        }

        @Override
        public CodeContentUpdate build() {
            return new CodeContentUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
