/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeployAsApplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeployAsApplicationConfiguration.Builder, DeployAsApplicationConfiguration> {
    private static final SdkField<S3ContentBaseLocation> S3_CONTENT_LOCATION_FIELD = SdkField
            .<S3ContentBaseLocation> builder(MarshallingType.SDK_POJO).memberName("S3ContentLocation")
            .getter(getter(DeployAsApplicationConfiguration::s3ContentLocation)).setter(setter(Builder::s3ContentLocation))
            .constructor(S3ContentBaseLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONTENT_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3ContentBaseLocation s3ContentLocation;

    private DeployAsApplicationConfiguration(BuilderImpl builder) {
        this.s3ContentLocation = builder.s3ContentLocation;
    }

    /**
     * <p>
     * The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the Amazon
     * Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version
     * number of the Amazon S3 object that contains the data.
     * </p>
     * 
     * @return The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the
     *         Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and
     *         the version number of the Amazon S3 object that contains the data.
     */
    public final S3ContentBaseLocation s3ContentLocation() {
        return s3ContentLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ContentLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployAsApplicationConfiguration)) {
            return false;
        }
        DeployAsApplicationConfiguration other = (DeployAsApplicationConfiguration) obj;
        return Objects.equals(s3ContentLocation(), other.s3ContentLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeployAsApplicationConfiguration").add("S3ContentLocation", s3ContentLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ContentLocation":
            return Optional.ofNullable(clazz.cast(s3ContentLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeployAsApplicationConfiguration, T> g) {
        return obj -> g.apply((DeployAsApplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeployAsApplicationConfiguration> {
        /**
         * <p>
         * The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the
         * Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the
         * version number of the Amazon S3 object that contains the data.
         * </p>
         * 
         * @param s3ContentLocation
         *        The description of an Amazon S3 object that contains the Amazon Data Analytics application, including
         *        the Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the
         *        data, and the version number of the Amazon S3 object that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ContentLocation(S3ContentBaseLocation s3ContentLocation);

        /**
         * <p>
         * The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the
         * Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the
         * version number of the Amazon S3 object that contains the data.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ContentBaseLocation.Builder} avoiding
         * the need to create one manually via {@link S3ContentBaseLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ContentBaseLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ContentLocation(S3ContentBaseLocation)}.
         * 
         * @param s3ContentLocation
         *        a consumer that will call methods on {@link S3ContentBaseLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ContentLocation(S3ContentBaseLocation)
         */
        default Builder s3ContentLocation(Consumer<S3ContentBaseLocation.Builder> s3ContentLocation) {
            return s3ContentLocation(S3ContentBaseLocation.builder().applyMutation(s3ContentLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ContentBaseLocation s3ContentLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployAsApplicationConfiguration model) {
            s3ContentLocation(model.s3ContentLocation);
        }

        public final S3ContentBaseLocation.Builder getS3ContentLocation() {
            return s3ContentLocation != null ? s3ContentLocation.toBuilder() : null;
        }

        public final void setS3ContentLocation(S3ContentBaseLocation.BuilderImpl s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation != null ? s3ContentLocation.build() : null;
        }

        @Override
        public final Builder s3ContentLocation(S3ContentBaseLocation s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation;
            return this;
        }

        @Override
        public DeployAsApplicationConfiguration build() {
            return new DeployAsApplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
