/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a SQL-based Kinesis Data Analytics application, describes the record format and relevant mapping information that
 * should be applied to schematize the records on the stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordFormat implements SdkPojo, Serializable, ToCopyableBuilder<RecordFormat.Builder, RecordFormat> {
    private static final SdkField<String> RECORD_FORMAT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordFormatType").getter(getter(RecordFormat::recordFormatTypeAsString))
            .setter(setter(Builder::recordFormatType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordFormatType").build()).build();

    private static final SdkField<MappingParameters> MAPPING_PARAMETERS_FIELD = SdkField
            .<MappingParameters> builder(MarshallingType.SDK_POJO).memberName("MappingParameters")
            .getter(getter(RecordFormat::mappingParameters)).setter(setter(Builder::mappingParameters))
            .constructor(MappingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappingParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FORMAT_TYPE_FIELD,
            MAPPING_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordFormatType;

    private final MappingParameters mappingParameters;

    private RecordFormat(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
        this.mappingParameters = builder.mappingParameters;
    }

    /**
     * <p>
     * The type of record format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeAsString}.
     * </p>
     * 
     * @return The type of record format.
     * @see RecordFormatType
     */
    public final RecordFormatType recordFormatType() {
        return RecordFormatType.fromValue(recordFormatType);
    }

    /**
     * <p>
     * The type of record format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeAsString}.
     * </p>
     * 
     * @return The type of record format.
     * @see RecordFormatType
     */
    public final String recordFormatTypeAsString() {
        return recordFormatType;
    }

    /**
     * <p>
     * When you configure application input at the time of creating or updating an application, provides additional
     * mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some
     * delimiter) on the streaming source.
     * </p>
     * 
     * @return When you configure application input at the time of creating or updating an application, provides
     *         additional mapping information specific to the record format (such as JSON, CSV, or record fields
     *         delimited by some delimiter) on the streaming source.
     */
    public final MappingParameters mappingParameters() {
        return mappingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordFormatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordFormat)) {
            return false;
        }
        RecordFormat other = (RecordFormat) obj;
        return Objects.equals(recordFormatTypeAsString(), other.recordFormatTypeAsString())
                && Objects.equals(mappingParameters(), other.mappingParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordFormat").add("RecordFormatType", recordFormatTypeAsString())
                .add("MappingParameters", mappingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordFormatType":
            return Optional.ofNullable(clazz.cast(recordFormatTypeAsString()));
        case "MappingParameters":
            return Optional.ofNullable(clazz.cast(mappingParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordFormat, T> g) {
        return obj -> g.apply((RecordFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordFormat> {
        /**
         * <p>
         * The type of record format.
         * </p>
         * 
         * @param recordFormatType
         *        The type of record format.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(String recordFormatType);

        /**
         * <p>
         * The type of record format.
         * </p>
         * 
         * @param recordFormatType
         *        The type of record format.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(RecordFormatType recordFormatType);

        /**
         * <p>
         * When you configure application input at the time of creating or updating an application, provides additional
         * mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some
         * delimiter) on the streaming source.
         * </p>
         * 
         * @param mappingParameters
         *        When you configure application input at the time of creating or updating an application, provides
         *        additional mapping information specific to the record format (such as JSON, CSV, or record fields
         *        delimited by some delimiter) on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingParameters(MappingParameters mappingParameters);

        /**
         * <p>
         * When you configure application input at the time of creating or updating an application, provides additional
         * mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some
         * delimiter) on the streaming source.
         * </p>
         * This is a convenience method that creates an instance of the {@link MappingParameters.Builder} avoiding the
         * need to create one manually via {@link MappingParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MappingParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #mappingParameters(MappingParameters)}.
         * 
         * @param mappingParameters
         *        a consumer that will call methods on {@link MappingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappingParameters(MappingParameters)
         */
        default Builder mappingParameters(Consumer<MappingParameters.Builder> mappingParameters) {
            return mappingParameters(MappingParameters.builder().applyMutation(mappingParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String recordFormatType;

        private MappingParameters mappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordFormat model) {
            recordFormatType(model.recordFormatType);
            mappingParameters(model.mappingParameters);
        }

        public final String getRecordFormatType() {
            return recordFormatType;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType == null ? null : recordFormatType.toString());
            return this;
        }

        public final MappingParameters.Builder getMappingParameters() {
            return mappingParameters != null ? mappingParameters.toBuilder() : null;
        }

        public final void setMappingParameters(MappingParameters.BuilderImpl mappingParameters) {
            this.mappingParameters = mappingParameters != null ? mappingParameters.build() : null;
        }

        @Override
        public final Builder mappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
            return this;
        }

        @Override
        public RecordFormat build() {
            return new RecordFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
