/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlApplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlApplicationConfiguration.Builder, SqlApplicationConfiguration> {
    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField
            .<List<Input>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(SqlApplicationConfiguration::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Input> builder(MarshallingType.SDK_POJO)
                                            .constructor(Input::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(SqlApplicationConfiguration::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReferenceDataSource>> REFERENCE_DATA_SOURCES_FIELD = SdkField
            .<List<ReferenceDataSource>> builder(MarshallingType.LIST)
            .memberName("ReferenceDataSources")
            .getter(getter(SqlApplicationConfiguration::referenceDataSources))
            .setter(setter(Builder::referenceDataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceDataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceDataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUTS_FIELD, OUTPUTS_FIELD,
            REFERENCE_DATA_SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Input> inputs;

    private final List<Output> outputs;

    private final List<ReferenceDataSource> referenceDataSources;

    private SqlApplicationConfiguration(BuilderImpl builder) {
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.referenceDataSources = builder.referenceDataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>Input</a> objects describing the input streams used by the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The array of <a>Input</a> objects describing the input streams used by the application.
     */
    public final List<Input> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>Output</a> objects describing the destination streams used by the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The array of <a>Output</a> objects describing the destination streams used by the application.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceDataSources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceDataSources() {
        return referenceDataSources != null && !(referenceDataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceDataSources} method.
     * </p>
     * 
     * @return The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the
     *         application.
     */
    public final List<ReferenceDataSource> referenceDataSources() {
        return referenceDataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceDataSources() ? referenceDataSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlApplicationConfiguration)) {
            return false;
        }
        SqlApplicationConfiguration other = (SqlApplicationConfiguration) obj;
        return hasInputs() == other.hasInputs() && Objects.equals(inputs(), other.inputs()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && hasReferenceDataSources() == other.hasReferenceDataSources()
                && Objects.equals(referenceDataSources(), other.referenceDataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlApplicationConfiguration").add("Inputs", hasInputs() ? inputs() : null)
                .add("Outputs", hasOutputs() ? outputs() : null)
                .add("ReferenceDataSources", hasReferenceDataSources() ? referenceDataSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "ReferenceDataSources":
            return Optional.ofNullable(clazz.cast(referenceDataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlApplicationConfiguration, T> g) {
        return obj -> g.apply((SqlApplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlApplicationConfiguration> {
        /**
         * <p>
         * The array of <a>Input</a> objects describing the input streams used by the application.
         * </p>
         * 
         * @param inputs
         *        The array of <a>Input</a> objects describing the input streams used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<Input> inputs);

        /**
         * <p>
         * The array of <a>Input</a> objects describing the input streams used by the application.
         * </p>
         * 
         * @param inputs
         *        The array of <a>Input</a> objects describing the input streams used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Input... inputs);

        /**
         * <p>
         * The array of <a>Input</a> objects describing the input streams used by the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Input>.Builder} avoiding the need to
         * create one manually via {@link List<Input>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Input>.Builder#build()} is called immediately and its result
         * is passed to {@link #inputs(List<Input>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on {@link List<Input>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(List<Input>)
         */
        Builder inputs(Consumer<Input.Builder>... inputs);

        /**
         * <p>
         * The array of <a>Output</a> objects describing the destination streams used by the application.
         * </p>
         * 
         * @param outputs
         *        The array of <a>Output</a> objects describing the destination streams used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * The array of <a>Output</a> objects describing the destination streams used by the application.
         * </p>
         * 
         * @param outputs
         *        The array of <a>Output</a> objects describing the destination streams used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * The array of <a>Output</a> objects describing the destination streams used by the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Output>.Builder} avoiding the need
         * to create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the
         * application.
         * </p>
         * 
         * @param referenceDataSources
         *        The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSources(Collection<ReferenceDataSource> referenceDataSources);

        /**
         * <p>
         * The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the
         * application.
         * </p>
         * 
         * @param referenceDataSources
         *        The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSources(ReferenceDataSource... referenceDataSources);

        /**
         * <p>
         * The array of <a>ReferenceDataSource</a> objects describing the reference data sources used by the
         * application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReferenceDataSource>.Builder}
         * avoiding the need to create one manually via {@link List<ReferenceDataSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReferenceDataSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #referenceDataSources(List<ReferenceDataSource>)}.
         * 
         * @param referenceDataSources
         *        a consumer that will call methods on {@link List<ReferenceDataSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceDataSources(List<ReferenceDataSource>)
         */
        Builder referenceDataSources(Consumer<ReferenceDataSource.Builder>... referenceDataSources);
    }

    static final class BuilderImpl implements Builder {
        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private List<ReferenceDataSource> referenceDataSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlApplicationConfiguration model) {
            inputs(model.inputs);
            outputs(model.outputs);
            referenceDataSources(model.referenceDataSources);
        }

        public final List<Input.Builder> getInputs() {
            List<Input.Builder> result = InputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> Input.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReferenceDataSource.Builder> getReferenceDataSources() {
            List<ReferenceDataSource.Builder> result = ReferenceDataSourcesCopier.copyToBuilder(this.referenceDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceDataSources(Collection<ReferenceDataSource.BuilderImpl> referenceDataSources) {
            this.referenceDataSources = ReferenceDataSourcesCopier.copyFromBuilder(referenceDataSources);
        }

        @Override
        public final Builder referenceDataSources(Collection<ReferenceDataSource> referenceDataSources) {
            this.referenceDataSources = ReferenceDataSourcesCopier.copy(referenceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSources(ReferenceDataSource... referenceDataSources) {
            referenceDataSources(Arrays.asList(referenceDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSources(Consumer<ReferenceDataSource.Builder>... referenceDataSources) {
            referenceDataSources(Stream.of(referenceDataSources).map(c -> ReferenceDataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SqlApplicationConfiguration build() {
            return new SqlApplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
