/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlApplicationConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlApplicationConfigurationDescription.Builder, SqlApplicationConfigurationDescription> {
    private static final SdkField<List<InputDescription>> INPUT_DESCRIPTIONS_FIELD = SdkField
            .<List<InputDescription>> builder(MarshallingType.LIST)
            .memberName("InputDescriptions")
            .getter(getter(SqlApplicationConfigurationDescription::inputDescriptions))
            .setter(setter(Builder::inputDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputDescription>> OUTPUT_DESCRIPTIONS_FIELD = SdkField
            .<List<OutputDescription>> builder(MarshallingType.LIST)
            .memberName("OutputDescriptions")
            .getter(getter(SqlApplicationConfigurationDescription::outputDescriptions))
            .setter(setter(Builder::outputDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReferenceDataSourceDescription>> REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD = SdkField
            .<List<ReferenceDataSourceDescription>> builder(MarshallingType.LIST)
            .memberName("ReferenceDataSourceDescriptions")
            .getter(getter(SqlApplicationConfigurationDescription::referenceDataSourceDescriptions))
            .setter(setter(Builder::referenceDataSourceDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceDescriptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceDataSourceDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceDataSourceDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DESCRIPTIONS_FIELD,
            OUTPUT_DESCRIPTIONS_FIELD, REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InputDescription> inputDescriptions;

    private final List<OutputDescription> outputDescriptions;

    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;

    private SqlApplicationConfigurationDescription(BuilderImpl builder) {
        this.inputDescriptions = builder.inputDescriptions;
        this.outputDescriptions = builder.outputDescriptions;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDescriptions() {
        return inputDescriptions != null && !(inputDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>InputDescription</a> objects describing the input streams used by the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDescriptions} method.
     * </p>
     * 
     * @return The array of <a>InputDescription</a> objects describing the input streams used by the application.
     */
    public final List<InputDescription> inputDescriptions() {
        return inputDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputDescriptions() {
        return outputDescriptions != null && !(outputDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>OutputDescription</a> objects describing the destination streams used by the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputDescriptions} method.
     * </p>
     * 
     * @return The array of <a>OutputDescription</a> objects describing the destination streams used by the application.
     */
    public final List<OutputDescription> outputDescriptions() {
        return outputDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceDataSourceDescriptions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReferenceDataSourceDescriptions() {
        return referenceDataSourceDescriptions != null && !(referenceDataSourceDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used by the
     * application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceDataSourceDescriptions}
     * method.
     * </p>
     * 
     * @return The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used by
     *         the application.
     */
    public final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return referenceDataSourceDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDescriptions() ? inputDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputDescriptions() ? outputDescriptions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReferenceDataSourceDescriptions() ? referenceDataSourceDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlApplicationConfigurationDescription)) {
            return false;
        }
        SqlApplicationConfigurationDescription other = (SqlApplicationConfigurationDescription) obj;
        return hasInputDescriptions() == other.hasInputDescriptions()
                && Objects.equals(inputDescriptions(), other.inputDescriptions())
                && hasOutputDescriptions() == other.hasOutputDescriptions()
                && Objects.equals(outputDescriptions(), other.outputDescriptions())
                && hasReferenceDataSourceDescriptions() == other.hasReferenceDataSourceDescriptions()
                && Objects.equals(referenceDataSourceDescriptions(), other.referenceDataSourceDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SqlApplicationConfigurationDescription")
                .add("InputDescriptions", hasInputDescriptions() ? inputDescriptions() : null)
                .add("OutputDescriptions", hasOutputDescriptions() ? outputDescriptions() : null)
                .add("ReferenceDataSourceDescriptions",
                        hasReferenceDataSourceDescriptions() ? referenceDataSourceDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputDescriptions":
            return Optional.ofNullable(clazz.cast(inputDescriptions()));
        case "OutputDescriptions":
            return Optional.ofNullable(clazz.cast(outputDescriptions()));
        case "ReferenceDataSourceDescriptions":
            return Optional.ofNullable(clazz.cast(referenceDataSourceDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((SqlApplicationConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlApplicationConfigurationDescription> {
        /**
         * <p>
         * The array of <a>InputDescription</a> objects describing the input streams used by the application.
         * </p>
         * 
         * @param inputDescriptions
         *        The array of <a>InputDescription</a> objects describing the input streams used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescriptions(Collection<InputDescription> inputDescriptions);

        /**
         * <p>
         * The array of <a>InputDescription</a> objects describing the input streams used by the application.
         * </p>
         * 
         * @param inputDescriptions
         *        The array of <a>InputDescription</a> objects describing the input streams used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescriptions(InputDescription... inputDescriptions);

        /**
         * <p>
         * The array of <a>InputDescription</a> objects describing the input streams used by the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<InputDescription>.Builder} avoiding
         * the need to create one manually via {@link List<InputDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputDescription>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputDescriptions(List<InputDescription>)}.
         * 
         * @param inputDescriptions
         *        a consumer that will call methods on {@link List<InputDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDescriptions(List<InputDescription>)
         */
        Builder inputDescriptions(Consumer<InputDescription.Builder>... inputDescriptions);

        /**
         * <p>
         * The array of <a>OutputDescription</a> objects describing the destination streams used by the application.
         * </p>
         * 
         * @param outputDescriptions
         *        The array of <a>OutputDescription</a> objects describing the destination streams used by the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDescriptions(Collection<OutputDescription> outputDescriptions);

        /**
         * <p>
         * The array of <a>OutputDescription</a> objects describing the destination streams used by the application.
         * </p>
         * 
         * @param outputDescriptions
         *        The array of <a>OutputDescription</a> objects describing the destination streams used by the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDescriptions(OutputDescription... outputDescriptions);

        /**
         * <p>
         * The array of <a>OutputDescription</a> objects describing the destination streams used by the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OutputDescription>.Builder} avoiding
         * the need to create one manually via {@link List<OutputDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #outputDescriptions(List<OutputDescription>)}.
         * 
         * @param outputDescriptions
         *        a consumer that will call methods on {@link List<OutputDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDescriptions(List<OutputDescription>)
         */
        Builder outputDescriptions(Consumer<OutputDescription.Builder>... outputDescriptions);

        /**
         * <p>
         * The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used by the
         * application.
         * </p>
         * 
         * @param referenceDataSourceDescriptions
         *        The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used
         *        by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions);

        /**
         * <p>
         * The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used by the
         * application.
         * </p>
         * 
         * @param referenceDataSourceDescriptions
         *        The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used
         *        by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions);

        /**
         * <p>
         * The array of <a>ReferenceDataSourceDescription</a> objects describing the reference data sources used by the
         * application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReferenceDataSourceDescription>.Builder} avoiding the need to create one manually via {@link List
         * <ReferenceDataSourceDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReferenceDataSourceDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #referenceDataSourceDescriptions(List<ReferenceDataSourceDescription>)}.
         * 
         * @param referenceDataSourceDescriptions
         *        a consumer that will call methods on {@link List<ReferenceDataSourceDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceDataSourceDescriptions(List<ReferenceDataSourceDescription>)
         */
        Builder referenceDataSourceDescriptions(
                Consumer<ReferenceDataSourceDescription.Builder>... referenceDataSourceDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private List<InputDescription> inputDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<OutputDescription> outputDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlApplicationConfigurationDescription model) {
            inputDescriptions(model.inputDescriptions);
            outputDescriptions(model.outputDescriptions);
            referenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
        }

        public final List<InputDescription.Builder> getInputDescriptions() {
            List<InputDescription.Builder> result = InputDescriptionsCopier.copyToBuilder(this.inputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDescriptions(Collection<InputDescription.BuilderImpl> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copyFromBuilder(inputDescriptions);
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription... inputDescriptions) {
            inputDescriptions(Arrays.asList(inputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(Consumer<InputDescription.Builder>... inputDescriptions) {
            inputDescriptions(Stream.of(inputDescriptions).map(c -> InputDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputDescription.Builder> getOutputDescriptions() {
            List<OutputDescription.Builder> result = OutputDescriptionsCopier.copyToBuilder(this.outputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputDescriptions(Collection<OutputDescription.BuilderImpl> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copyFromBuilder(outputDescriptions);
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription... outputDescriptions) {
            outputDescriptions(Arrays.asList(outputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(Consumer<OutputDescription.Builder>... outputDescriptions) {
            outputDescriptions(Stream.of(outputDescriptions).map(c -> OutputDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReferenceDataSourceDescription.Builder> getReferenceDataSourceDescriptions() {
            List<ReferenceDataSourceDescription.Builder> result = ReferenceDataSourceDescriptionsCopier
                    .copyToBuilder(this.referenceDataSourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceDataSourceDescriptions(
                Collection<ReferenceDataSourceDescription.BuilderImpl> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier
                    .copyFromBuilder(referenceDataSourceDescriptions);
        }

        @Override
        public final Builder referenceDataSourceDescriptions(
                Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions) {
            referenceDataSourceDescriptions(Arrays.asList(referenceDataSourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(
                Consumer<ReferenceDataSourceDescription.Builder>... referenceDataSourceDescriptions) {
            referenceDataSourceDescriptions(Stream.of(referenceDataSourceDescriptions)
                    .map(c -> ReferenceDataSourceDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SqlApplicationConfigurationDescription build() {
            return new SqlApplicationConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
