/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the starting parameters for a SQL-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlRunConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlRunConfiguration.Builder, SqlRunConfiguration> {
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(SqlRunConfiguration::inputId)).setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()).build();

    private static final SdkField<InputStartingPositionConfiguration> INPUT_STARTING_POSITION_CONFIGURATION_FIELD = SdkField
            .<InputStartingPositionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InputStartingPositionConfiguration")
            .getter(getter(SqlRunConfiguration::inputStartingPositionConfiguration))
            .setter(setter(Builder::inputStartingPositionConfiguration))
            .constructor(InputStartingPositionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStartingPositionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ID_FIELD,
            INPUT_STARTING_POSITION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputId;

    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private SqlRunConfiguration(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    /**
     * <p>
     * The input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
     * </p>
     * 
     * @return The input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * <p>
     * The point at which you want the application to start processing records from the streaming source.
     * </p>
     * 
     * @return The point at which you want the application to start processing records from the streaming source.
     */
    public final InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return inputStartingPositionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(inputStartingPositionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlRunConfiguration)) {
            return false;
        }
        SqlRunConfiguration other = (SqlRunConfiguration) obj;
        return Objects.equals(inputId(), other.inputId())
                && Objects.equals(inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlRunConfiguration").add("InputId", inputId())
                .add("InputStartingPositionConfiguration", inputStartingPositionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputStartingPositionConfiguration":
            return Optional.ofNullable(clazz.cast(inputStartingPositionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlRunConfiguration, T> g) {
        return obj -> g.apply((SqlRunConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlRunConfiguration> {
        /**
         * <p>
         * The input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
         * </p>
         * 
         * @param inputId
         *        The input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * The point at which you want the application to start processing records from the streaming source.
         * </p>
         * 
         * @param inputStartingPositionConfiguration
         *        The point at which you want the application to start processing records from the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration);

        /**
         * <p>
         * The point at which you want the application to start processing records from the streaming source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InputStartingPositionConfiguration.Builder} avoiding the need to create one manually via
         * {@link InputStartingPositionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputStartingPositionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputStartingPositionConfiguration(InputStartingPositionConfiguration)}.
         * 
         * @param inputStartingPositionConfiguration
         *        a consumer that will call methods on {@link InputStartingPositionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputStartingPositionConfiguration(InputStartingPositionConfiguration)
         */
        default Builder inputStartingPositionConfiguration(
                Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return inputStartingPositionConfiguration(InputStartingPositionConfiguration.builder()
                    .applyMutation(inputStartingPositionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputId;

        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlRunConfiguration model) {
            inputId(model.inputId);
            inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.toBuilder() : null;
        }

        public final void setInputStartingPositionConfiguration(
                InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        @Override
        public SqlRunConfiguration build() {
            return new SqlRunConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
