/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(UpdateApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(UpdateApplicationRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<ApplicationConfigurationUpdate> APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationConfigurationUpdate")
            .getter(getter(UpdateApplicationRequest::applicationConfigurationUpdate))
            .setter(setter(Builder::applicationConfigurationUpdate))
            .constructor(ApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfigurationUpdate")
                    .build()).build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_UPDATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceExecutionRoleUpdate")
            .getter(getter(UpdateApplicationRequest::serviceExecutionRoleUpdate))
            .setter(setter(Builder::serviceExecutionRoleUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRoleUpdate").build())
            .build();

    private static final SdkField<RunConfigurationUpdate> RUN_CONFIGURATION_UPDATE_FIELD = SdkField
            .<RunConfigurationUpdate> builder(MarshallingType.SDK_POJO).memberName("RunConfigurationUpdate")
            .getter(getter(UpdateApplicationRequest::runConfigurationUpdate)).setter(setter(Builder::runConfigurationUpdate))
            .constructor(RunConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfigurationUpdate").build())
            .build();

    private static final SdkField<List<CloudWatchLoggingOptionUpdate>> CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD = SdkField
            .<List<CloudWatchLoggingOptionUpdate>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptionUpdates")
            .getter(getter(UpdateApplicationRequest::cloudWatchLoggingOptionUpdates))
            .setter(setter(Builder::cloudWatchLoggingOptionUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionUpdates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOptionUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOptionUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONDITIONAL_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionalToken").getter(getter(UpdateApplicationRequest::conditionalToken))
            .setter(setter(Builder::conditionalToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, APPLICATION_CONFIGURATION_UPDATE_FIELD, SERVICE_EXECUTION_ROLE_UPDATE_FIELD,
            RUN_CONFIGURATION_UPDATE_FIELD, CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD, CONDITIONAL_TOKEN_FIELD));

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final ApplicationConfigurationUpdate applicationConfigurationUpdate;

    private final String serviceExecutionRoleUpdate;

    private final RunConfigurationUpdate runConfigurationUpdate;

    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private final String conditionalToken;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.applicationConfigurationUpdate = builder.applicationConfigurationUpdate;
        this.serviceExecutionRoleUpdate = builder.serviceExecutionRoleUpdate;
        this.runConfigurationUpdate = builder.runConfigurationUpdate;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
        this.conditionalToken = builder.conditionalToken;
    }

    /**
     * <p>
     * The name of the application to update.
     * </p>
     * 
     * @return The name of the application to update.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     * <code>ConditionalToken</code>.You can retrieve the application version ID using <a>DescribeApplication</a>. For
     * better concurrency support, use the <code>ConditionalToken</code> parameter instead of
     * <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @return The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     *         <code>ConditionalToken</code>.You can retrieve the application version ID using
     *         <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
     *         parameter instead of <code>CurrentApplicationVersionId</code>.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * Describes application configuration updates.
     * </p>
     * 
     * @return Describes application configuration updates.
     */
    public final ApplicationConfigurationUpdate applicationConfigurationUpdate() {
        return applicationConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to the service execution role.
     * </p>
     * 
     * @return Describes updates to the service execution role.
     */
    public final String serviceExecutionRoleUpdate() {
        return serviceExecutionRoleUpdate;
    }

    /**
     * <p>
     * Describes updates to the application's starting parameters.
     * </p>
     * 
     * @return Describes updates to the application's starting parameters.
     */
    public final RunConfigurationUpdate runConfigurationUpdate() {
        return runConfigurationUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchLoggingOptionUpdates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudWatchLoggingOptionUpdates() {
        return cloudWatchLoggingOptionUpdates != null && !(cloudWatchLoggingOptionUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes application Amazon CloudWatch logging option updates. You can only update existing CloudWatch logging
     * options with this action. To add a new CloudWatch logging option, use
     * <a>AddApplicationCloudWatchLoggingOption</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchLoggingOptionUpdates} method.
     * </p>
     * 
     * @return Describes application Amazon CloudWatch logging option updates. You can only update existing CloudWatch
     *         logging options with this action. To add a new CloudWatch logging option, use
     *         <a>AddApplicationCloudWatchLoggingOption</a>.
     */
    public final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return cloudWatchLoggingOptionUpdates;
    }

    /**
     * <p>
     * A value you use to implement strong concurrency for application updates. You must provide the
     * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's current
     * <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use the
     * <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @return A value you use to implement strong concurrency for application updates. You must provide the
     *         <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
     *         current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support,
     *         use the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     */
    public final String conditionalToken() {
        return conditionalToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRoleUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(runConfigurationUpdate());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCloudWatchLoggingOptionUpdates() ? cloudWatchLoggingOptionUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conditionalToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(applicationConfigurationUpdate(), other.applicationConfigurationUpdate())
                && Objects.equals(serviceExecutionRoleUpdate(), other.serviceExecutionRoleUpdate())
                && Objects.equals(runConfigurationUpdate(), other.runConfigurationUpdate())
                && hasCloudWatchLoggingOptionUpdates() == other.hasCloudWatchLoggingOptionUpdates()
                && Objects.equals(cloudWatchLoggingOptionUpdates(), other.cloudWatchLoggingOptionUpdates())
                && Objects.equals(conditionalToken(), other.conditionalToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateApplicationRequest")
                .add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId())
                .add("ApplicationConfigurationUpdate", applicationConfigurationUpdate())
                .add("ServiceExecutionRoleUpdate", serviceExecutionRoleUpdate())
                .add("RunConfigurationUpdate", runConfigurationUpdate())
                .add("CloudWatchLoggingOptionUpdates",
                        hasCloudWatchLoggingOptionUpdates() ? cloudWatchLoggingOptionUpdates() : null)
                .add("ConditionalToken", conditionalToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "ApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationConfigurationUpdate()));
        case "ServiceExecutionRoleUpdate":
            return Optional.ofNullable(clazz.cast(serviceExecutionRoleUpdate()));
        case "RunConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(runConfigurationUpdate()));
        case "CloudWatchLoggingOptionUpdates":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionUpdates()));
        case "ConditionalToken":
            return Optional.ofNullable(clazz.cast(conditionalToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The name of the application to update.
         * </p>
         * 
         * @param applicationName
         *        The name of the application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
         * <code>ConditionalToken</code>.You can retrieve the application version ID using <a>DescribeApplication</a>.
         * For better concurrency support, use the <code>ConditionalToken</code> parameter instead of
         * <code>CurrentApplicationVersionId</code>.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or
         *        the <code>ConditionalToken</code>.You can retrieve the application version ID using
         *        <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
         *        parameter instead of <code>CurrentApplicationVersionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * Describes application configuration updates.
         * </p>
         * 
         * @param applicationConfigurationUpdate
         *        Describes application configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfigurationUpdate(ApplicationConfigurationUpdate applicationConfigurationUpdate);

        /**
         * <p>
         * Describes application configuration updates.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link ApplicationConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationConfigurationUpdate(ApplicationConfigurationUpdate)}.
         * 
         * @param applicationConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfigurationUpdate(ApplicationConfigurationUpdate)
         */
        default Builder applicationConfigurationUpdate(
                Consumer<ApplicationConfigurationUpdate.Builder> applicationConfigurationUpdate) {
            return applicationConfigurationUpdate(ApplicationConfigurationUpdate.builder()
                    .applyMutation(applicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to the service execution role.
         * </p>
         * 
         * @param serviceExecutionRoleUpdate
         *        Describes updates to the service execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRoleUpdate(String serviceExecutionRoleUpdate);

        /**
         * <p>
         * Describes updates to the application's starting parameters.
         * </p>
         * 
         * @param runConfigurationUpdate
         *        Describes updates to the application's starting parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfigurationUpdate(RunConfigurationUpdate runConfigurationUpdate);

        /**
         * <p>
         * Describes updates to the application's starting parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link RunConfigurationUpdate.Builder} avoiding
         * the need to create one manually via {@link RunConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunConfigurationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #runConfigurationUpdate(RunConfigurationUpdate)}.
         * 
         * @param runConfigurationUpdate
         *        a consumer that will call methods on {@link RunConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfigurationUpdate(RunConfigurationUpdate)
         */
        default Builder runConfigurationUpdate(Consumer<RunConfigurationUpdate.Builder> runConfigurationUpdate) {
            return runConfigurationUpdate(RunConfigurationUpdate.builder().applyMutation(runConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes application Amazon CloudWatch logging option updates. You can only update existing CloudWatch
         * logging options with this action. To add a new CloudWatch logging option, use
         * <a>AddApplicationCloudWatchLoggingOption</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        Describes application Amazon CloudWatch logging option updates. You can only update existing
         *        CloudWatch logging options with this action. To add a new CloudWatch logging option, use
         *        <a>AddApplicationCloudWatchLoggingOption</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates);

        /**
         * <p>
         * Describes application Amazon CloudWatch logging option updates. You can only update existing CloudWatch
         * logging options with this action. To add a new CloudWatch logging option, use
         * <a>AddApplicationCloudWatchLoggingOption</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        Describes application Amazon CloudWatch logging option updates. You can only update existing
         *        CloudWatch logging options with this action. To add a new CloudWatch logging option, use
         *        <a>AddApplicationCloudWatchLoggingOption</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates);

        /**
         * <p>
         * Describes application Amazon CloudWatch logging option updates. You can only update existing CloudWatch
         * logging options with this action. To add a new CloudWatch logging option, use
         * <a>AddApplicationCloudWatchLoggingOption</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <CloudWatchLoggingOptionUpdate>.Builder} avoiding the need to create one manually via {@link List
         * <CloudWatchLoggingOptionUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLoggingOptionUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #cloudWatchLoggingOptionUpdates(List<CloudWatchLoggingOptionUpdate>)}.
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        a consumer that will call methods on {@link List<CloudWatchLoggingOptionUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptionUpdates(List<CloudWatchLoggingOptionUpdate>)
         */
        Builder cloudWatchLoggingOptionUpdates(Consumer<CloudWatchLoggingOptionUpdate.Builder>... cloudWatchLoggingOptionUpdates);

        /**
         * <p>
         * A value you use to implement strong concurrency for application updates. You must provide the
         * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
         * current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use
         * the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
         * </p>
         * 
         * @param conditionalToken
         *        A value you use to implement strong concurrency for application updates. You must provide the
         *        <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the
         *        application's current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better
         *        concurrency support, use the <code>ConditionalToken</code> parameter instead of
         *        <code>CurrentApplicationVersionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalToken(String conditionalToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private ApplicationConfigurationUpdate applicationConfigurationUpdate;

        private String serviceExecutionRoleUpdate;

        private RunConfigurationUpdate runConfigurationUpdate;

        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates = DefaultSdkAutoConstructList.getInstance();

        private String conditionalToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            applicationConfigurationUpdate(model.applicationConfigurationUpdate);
            serviceExecutionRoleUpdate(model.serviceExecutionRoleUpdate);
            runConfigurationUpdate(model.runConfigurationUpdate);
            cloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
            conditionalToken(model.conditionalToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final ApplicationConfigurationUpdate.Builder getApplicationConfigurationUpdate() {
            return applicationConfigurationUpdate != null ? applicationConfigurationUpdate.toBuilder() : null;
        }

        public final void setApplicationConfigurationUpdate(
                ApplicationConfigurationUpdate.BuilderImpl applicationConfigurationUpdate) {
            this.applicationConfigurationUpdate = applicationConfigurationUpdate != null ? applicationConfigurationUpdate.build()
                    : null;
        }

        @Override
        public final Builder applicationConfigurationUpdate(ApplicationConfigurationUpdate applicationConfigurationUpdate) {
            this.applicationConfigurationUpdate = applicationConfigurationUpdate;
            return this;
        }

        public final String getServiceExecutionRoleUpdate() {
            return serviceExecutionRoleUpdate;
        }

        public final void setServiceExecutionRoleUpdate(String serviceExecutionRoleUpdate) {
            this.serviceExecutionRoleUpdate = serviceExecutionRoleUpdate;
        }

        @Override
        public final Builder serviceExecutionRoleUpdate(String serviceExecutionRoleUpdate) {
            this.serviceExecutionRoleUpdate = serviceExecutionRoleUpdate;
            return this;
        }

        public final RunConfigurationUpdate.Builder getRunConfigurationUpdate() {
            return runConfigurationUpdate != null ? runConfigurationUpdate.toBuilder() : null;
        }

        public final void setRunConfigurationUpdate(RunConfigurationUpdate.BuilderImpl runConfigurationUpdate) {
            this.runConfigurationUpdate = runConfigurationUpdate != null ? runConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder runConfigurationUpdate(RunConfigurationUpdate runConfigurationUpdate) {
            this.runConfigurationUpdate = runConfigurationUpdate;
            return this;
        }

        public final List<CloudWatchLoggingOptionUpdate.Builder> getCloudWatchLoggingOptionUpdates() {
            List<CloudWatchLoggingOptionUpdate.Builder> result = CloudWatchLoggingOptionUpdatesCopier
                    .copyToBuilder(this.cloudWatchLoggingOptionUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptionUpdates(
                Collection<CloudWatchLoggingOptionUpdate.BuilderImpl> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier
                    .copyFromBuilder(cloudWatchLoggingOptionUpdates);
        }

        @Override
        public final Builder cloudWatchLoggingOptionUpdates(
                Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates) {
            cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(
                Consumer<CloudWatchLoggingOptionUpdate.Builder>... cloudWatchLoggingOptionUpdates) {
            cloudWatchLoggingOptionUpdates(Stream.of(cloudWatchLoggingOptionUpdates)
                    .map(c -> CloudWatchLoggingOptionUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConditionalToken() {
            return conditionalToken;
        }

        public final void setConditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
        }

        @Override
        public final Builder conditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
