/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to the configuration of Kinesis Data Analytics Studio notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZeppelinApplicationConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ZeppelinApplicationConfigurationUpdate.Builder, ZeppelinApplicationConfigurationUpdate> {
    private static final SdkField<ZeppelinMonitoringConfigurationUpdate> MONITORING_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ZeppelinMonitoringConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringConfigurationUpdate")
            .getter(getter(ZeppelinApplicationConfigurationUpdate::monitoringConfigurationUpdate))
            .setter(setter(Builder::monitoringConfigurationUpdate))
            .constructor(ZeppelinMonitoringConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfigurationUpdate")
                    .build()).build();

    private static final SdkField<CatalogConfigurationUpdate> CATALOG_CONFIGURATION_UPDATE_FIELD = SdkField
            .<CatalogConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("CatalogConfigurationUpdate")
            .getter(getter(ZeppelinApplicationConfigurationUpdate::catalogConfigurationUpdate))
            .setter(setter(Builder::catalogConfigurationUpdate))
            .constructor(CatalogConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfigurationUpdate").build())
            .build();

    private static final SdkField<DeployAsApplicationConfigurationUpdate> DEPLOY_AS_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<DeployAsApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("DeployAsApplicationConfigurationUpdate")
            .getter(getter(ZeppelinApplicationConfigurationUpdate::deployAsApplicationConfigurationUpdate))
            .setter(setter(Builder::deployAsApplicationConfigurationUpdate))
            .constructor(DeployAsApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DeployAsApplicationConfigurationUpdate").build()).build();

    private static final SdkField<List<CustomArtifactConfiguration>> CUSTOM_ARTIFACTS_CONFIGURATION_UPDATE_FIELD = SdkField
            .<List<CustomArtifactConfiguration>> builder(MarshallingType.LIST)
            .memberName("CustomArtifactsConfigurationUpdate")
            .getter(getter(ZeppelinApplicationConfigurationUpdate::customArtifactsConfigurationUpdate))
            .setter(setter(Builder::customArtifactsConfigurationUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomArtifactsConfigurationUpdate")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomArtifactConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomArtifactConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_CONFIGURATION_UPDATE_FIELD, CATALOG_CONFIGURATION_UPDATE_FIELD,
            DEPLOY_AS_APPLICATION_CONFIGURATION_UPDATE_FIELD, CUSTOM_ARTIFACTS_CONFIGURATION_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ZeppelinMonitoringConfigurationUpdate monitoringConfigurationUpdate;

    private final CatalogConfigurationUpdate catalogConfigurationUpdate;

    private final DeployAsApplicationConfigurationUpdate deployAsApplicationConfigurationUpdate;

    private final List<CustomArtifactConfiguration> customArtifactsConfigurationUpdate;

    private ZeppelinApplicationConfigurationUpdate(BuilderImpl builder) {
        this.monitoringConfigurationUpdate = builder.monitoringConfigurationUpdate;
        this.catalogConfigurationUpdate = builder.catalogConfigurationUpdate;
        this.deployAsApplicationConfigurationUpdate = builder.deployAsApplicationConfigurationUpdate;
        this.customArtifactsConfigurationUpdate = builder.customArtifactsConfigurationUpdate;
    }

    /**
     * <p>
     * Updates to the monitoring configuration of a Kinesis Data Analytics Studio notebook.
     * </p>
     * 
     * @return Updates to the monitoring configuration of a Kinesis Data Analytics Studio notebook.
     */
    public final ZeppelinMonitoringConfigurationUpdate monitoringConfigurationUpdate() {
        return monitoringConfigurationUpdate;
    }

    /**
     * <p>
     * Updates to the configuration of the Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics
     * Studio notebook.
     * </p>
     * 
     * @return Updates to the configuration of the Amazon Glue Data Catalog that is associated with the Kinesis Data
     *         Analytics Studio notebook.
     */
    public final CatalogConfigurationUpdate catalogConfigurationUpdate() {
        return catalogConfigurationUpdate;
    }

    /**
     * Returns the value of the DeployAsApplicationConfigurationUpdate property for this object.
     * 
     * @return The value of the DeployAsApplicationConfigurationUpdate property for this object.
     */
    public final DeployAsApplicationConfigurationUpdate deployAsApplicationConfigurationUpdate() {
        return deployAsApplicationConfigurationUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomArtifactsConfigurationUpdate
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCustomArtifactsConfigurationUpdate() {
        return customArtifactsConfigurationUpdate != null
                && !(customArtifactsConfigurationUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined functions (UDF).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomArtifactsConfigurationUpdate}
     * method.
     * </p>
     * 
     * @return Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined functions
     *         (UDF).
     */
    public final List<CustomArtifactConfiguration> customArtifactsConfigurationUpdate() {
        return customArtifactsConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(catalogConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(deployAsApplicationConfigurationUpdate());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCustomArtifactsConfigurationUpdate() ? customArtifactsConfigurationUpdate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeppelinApplicationConfigurationUpdate)) {
            return false;
        }
        ZeppelinApplicationConfigurationUpdate other = (ZeppelinApplicationConfigurationUpdate) obj;
        return Objects.equals(monitoringConfigurationUpdate(), other.monitoringConfigurationUpdate())
                && Objects.equals(catalogConfigurationUpdate(), other.catalogConfigurationUpdate())
                && Objects.equals(deployAsApplicationConfigurationUpdate(), other.deployAsApplicationConfigurationUpdate())
                && hasCustomArtifactsConfigurationUpdate() == other.hasCustomArtifactsConfigurationUpdate()
                && Objects.equals(customArtifactsConfigurationUpdate(), other.customArtifactsConfigurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ZeppelinApplicationConfigurationUpdate")
                .add("MonitoringConfigurationUpdate", monitoringConfigurationUpdate())
                .add("CatalogConfigurationUpdate", catalogConfigurationUpdate())
                .add("DeployAsApplicationConfigurationUpdate", deployAsApplicationConfigurationUpdate())
                .add("CustomArtifactsConfigurationUpdate",
                        hasCustomArtifactsConfigurationUpdate() ? customArtifactsConfigurationUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(monitoringConfigurationUpdate()));
        case "CatalogConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(catalogConfigurationUpdate()));
        case "DeployAsApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(deployAsApplicationConfigurationUpdate()));
        case "CustomArtifactsConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(customArtifactsConfigurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZeppelinApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((ZeppelinApplicationConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZeppelinApplicationConfigurationUpdate> {
        /**
         * <p>
         * Updates to the monitoring configuration of a Kinesis Data Analytics Studio notebook.
         * </p>
         * 
         * @param monitoringConfigurationUpdate
         *        Updates to the monitoring configuration of a Kinesis Data Analytics Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfigurationUpdate(ZeppelinMonitoringConfigurationUpdate monitoringConfigurationUpdate);

        /**
         * <p>
         * Updates to the monitoring configuration of a Kinesis Data Analytics Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ZeppelinMonitoringConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ZeppelinMonitoringConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ZeppelinMonitoringConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #monitoringConfigurationUpdate(ZeppelinMonitoringConfigurationUpdate)}.
         * 
         * @param monitoringConfigurationUpdate
         *        a consumer that will call methods on {@link ZeppelinMonitoringConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfigurationUpdate(ZeppelinMonitoringConfigurationUpdate)
         */
        default Builder monitoringConfigurationUpdate(
                Consumer<ZeppelinMonitoringConfigurationUpdate.Builder> monitoringConfigurationUpdate) {
            return monitoringConfigurationUpdate(ZeppelinMonitoringConfigurationUpdate.builder()
                    .applyMutation(monitoringConfigurationUpdate).build());
        }

        /**
         * <p>
         * Updates to the configuration of the Amazon Glue Data Catalog that is associated with the Kinesis Data
         * Analytics Studio notebook.
         * </p>
         * 
         * @param catalogConfigurationUpdate
         *        Updates to the configuration of the Amazon Glue Data Catalog that is associated with the Kinesis Data
         *        Analytics Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogConfigurationUpdate(CatalogConfigurationUpdate catalogConfigurationUpdate);

        /**
         * <p>
         * Updates to the configuration of the Amazon Glue Data Catalog that is associated with the Kinesis Data
         * Analytics Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link CatalogConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link CatalogConfigurationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #catalogConfigurationUpdate(CatalogConfigurationUpdate)}.
         * 
         * @param catalogConfigurationUpdate
         *        a consumer that will call methods on {@link CatalogConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogConfigurationUpdate(CatalogConfigurationUpdate)
         */
        default Builder catalogConfigurationUpdate(Consumer<CatalogConfigurationUpdate.Builder> catalogConfigurationUpdate) {
            return catalogConfigurationUpdate(CatalogConfigurationUpdate.builder().applyMutation(catalogConfigurationUpdate)
                    .build());
        }

        /**
         * Sets the value of the DeployAsApplicationConfigurationUpdate property for this object.
         *
         * @param deployAsApplicationConfigurationUpdate
         *        The new value for the DeployAsApplicationConfigurationUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployAsApplicationConfigurationUpdate(
                DeployAsApplicationConfigurationUpdate deployAsApplicationConfigurationUpdate);

        /**
         * Sets the value of the DeployAsApplicationConfigurationUpdate property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link DeployAsApplicationConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link DeployAsApplicationConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeployAsApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #deployAsApplicationConfigurationUpdate(DeployAsApplicationConfigurationUpdate)}.
         * 
         * @param deployAsApplicationConfigurationUpdate
         *        a consumer that will call methods on {@link DeployAsApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployAsApplicationConfigurationUpdate(DeployAsApplicationConfigurationUpdate)
         */
        default Builder deployAsApplicationConfigurationUpdate(
                Consumer<DeployAsApplicationConfigurationUpdate.Builder> deployAsApplicationConfigurationUpdate) {
            return deployAsApplicationConfigurationUpdate(DeployAsApplicationConfigurationUpdate.builder()
                    .applyMutation(deployAsApplicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined functions
         * (UDF).
         * </p>
         * 
         * @param customArtifactsConfigurationUpdate
         *        Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined
         *        functions (UDF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customArtifactsConfigurationUpdate(Collection<CustomArtifactConfiguration> customArtifactsConfigurationUpdate);

        /**
         * <p>
         * Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined functions
         * (UDF).
         * </p>
         * 
         * @param customArtifactsConfigurationUpdate
         *        Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined
         *        functions (UDF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customArtifactsConfigurationUpdate(CustomArtifactConfiguration... customArtifactsConfigurationUpdate);

        /**
         * <p>
         * Updates to the customer artifacts. Custom artifacts are dependency JAR files and user-defined functions
         * (UDF).
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <CustomArtifactConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <CustomArtifactConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomArtifactConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #customArtifactsConfigurationUpdate(List<CustomArtifactConfiguration>)}.
         * 
         * @param customArtifactsConfigurationUpdate
         *        a consumer that will call methods on {@link List<CustomArtifactConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customArtifactsConfigurationUpdate(List<CustomArtifactConfiguration>)
         */
        Builder customArtifactsConfigurationUpdate(
                Consumer<CustomArtifactConfiguration.Builder>... customArtifactsConfigurationUpdate);
    }

    static final class BuilderImpl implements Builder {
        private ZeppelinMonitoringConfigurationUpdate monitoringConfigurationUpdate;

        private CatalogConfigurationUpdate catalogConfigurationUpdate;

        private DeployAsApplicationConfigurationUpdate deployAsApplicationConfigurationUpdate;

        private List<CustomArtifactConfiguration> customArtifactsConfigurationUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ZeppelinApplicationConfigurationUpdate model) {
            monitoringConfigurationUpdate(model.monitoringConfigurationUpdate);
            catalogConfigurationUpdate(model.catalogConfigurationUpdate);
            deployAsApplicationConfigurationUpdate(model.deployAsApplicationConfigurationUpdate);
            customArtifactsConfigurationUpdate(model.customArtifactsConfigurationUpdate);
        }

        public final ZeppelinMonitoringConfigurationUpdate.Builder getMonitoringConfigurationUpdate() {
            return monitoringConfigurationUpdate != null ? monitoringConfigurationUpdate.toBuilder() : null;
        }

        public final void setMonitoringConfigurationUpdate(
                ZeppelinMonitoringConfigurationUpdate.BuilderImpl monitoringConfigurationUpdate) {
            this.monitoringConfigurationUpdate = monitoringConfigurationUpdate != null ? monitoringConfigurationUpdate.build()
                    : null;
        }

        @Override
        public final Builder monitoringConfigurationUpdate(ZeppelinMonitoringConfigurationUpdate monitoringConfigurationUpdate) {
            this.monitoringConfigurationUpdate = monitoringConfigurationUpdate;
            return this;
        }

        public final CatalogConfigurationUpdate.Builder getCatalogConfigurationUpdate() {
            return catalogConfigurationUpdate != null ? catalogConfigurationUpdate.toBuilder() : null;
        }

        public final void setCatalogConfigurationUpdate(CatalogConfigurationUpdate.BuilderImpl catalogConfigurationUpdate) {
            this.catalogConfigurationUpdate = catalogConfigurationUpdate != null ? catalogConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder catalogConfigurationUpdate(CatalogConfigurationUpdate catalogConfigurationUpdate) {
            this.catalogConfigurationUpdate = catalogConfigurationUpdate;
            return this;
        }

        public final DeployAsApplicationConfigurationUpdate.Builder getDeployAsApplicationConfigurationUpdate() {
            return deployAsApplicationConfigurationUpdate != null ? deployAsApplicationConfigurationUpdate.toBuilder() : null;
        }

        public final void setDeployAsApplicationConfigurationUpdate(
                DeployAsApplicationConfigurationUpdate.BuilderImpl deployAsApplicationConfigurationUpdate) {
            this.deployAsApplicationConfigurationUpdate = deployAsApplicationConfigurationUpdate != null ? deployAsApplicationConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder deployAsApplicationConfigurationUpdate(
                DeployAsApplicationConfigurationUpdate deployAsApplicationConfigurationUpdate) {
            this.deployAsApplicationConfigurationUpdate = deployAsApplicationConfigurationUpdate;
            return this;
        }

        public final List<CustomArtifactConfiguration.Builder> getCustomArtifactsConfigurationUpdate() {
            List<CustomArtifactConfiguration.Builder> result = CustomArtifactsConfigurationListCopier
                    .copyToBuilder(this.customArtifactsConfigurationUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomArtifactsConfigurationUpdate(
                Collection<CustomArtifactConfiguration.BuilderImpl> customArtifactsConfigurationUpdate) {
            this.customArtifactsConfigurationUpdate = CustomArtifactsConfigurationListCopier
                    .copyFromBuilder(customArtifactsConfigurationUpdate);
        }

        @Override
        public final Builder customArtifactsConfigurationUpdate(
                Collection<CustomArtifactConfiguration> customArtifactsConfigurationUpdate) {
            this.customArtifactsConfigurationUpdate = CustomArtifactsConfigurationListCopier
                    .copy(customArtifactsConfigurationUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfigurationUpdate(CustomArtifactConfiguration... customArtifactsConfigurationUpdate) {
            customArtifactsConfigurationUpdate(Arrays.asList(customArtifactsConfigurationUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfigurationUpdate(
                Consumer<CustomArtifactConfiguration.Builder>... customArtifactsConfigurationUpdate) {
            customArtifactsConfigurationUpdate(Stream.of(customArtifactsConfigurationUpdate)
                    .map(c -> CustomArtifactConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ZeppelinApplicationConfigurationUpdate build() {
            return new ZeppelinApplicationConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
