/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application, including the application Amazon Resource Name (ARN), status, latest version, and input
 * and output configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationDetail.Builder, ApplicationDetail> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(ApplicationDetail::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationDescription").getter(getter(ApplicationDetail::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build())
            .build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(ApplicationDetail::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeEnvironment").getter(getter(ApplicationDetail::runtimeEnvironmentAsString))
            .setter(setter(Builder::runtimeEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build())
            .build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceExecutionRole").getter(getter(ApplicationDetail::serviceExecutionRole))
            .setter(setter(Builder::serviceExecutionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build())
            .build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus").getter(getter(ApplicationDetail::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(ApplicationDetail::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTimestamp").getter(getter(ApplicationDetail::createTimestamp))
            .setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTimestamp").getter(getter(ApplicationDetail::lastUpdateTimestamp))
            .setter(setter(Builder::lastUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build())
            .build();

    private static final SdkField<ApplicationConfigurationDescription> APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationConfigurationDescription")
            .getter(getter(ApplicationDetail::applicationConfigurationDescription))
            .setter(setter(Builder::applicationConfigurationDescription))
            .constructor(ApplicationConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationConfigurationDescription").build()).build();

    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<CloudWatchLoggingOptionDescription>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptionDescriptions")
            .getter(getter(ApplicationDetail::cloudWatchLoggingOptionDescriptions))
            .setter(setter(Builder::cloudWatchLoggingOptionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudWatchLoggingOptionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationMaintenanceConfigurationDescription> APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationMaintenanceConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationMaintenanceConfigurationDescription")
            .getter(getter(ApplicationDetail::applicationMaintenanceConfigurationDescription))
            .setter(setter(Builder::applicationMaintenanceConfigurationDescription))
            .constructor(ApplicationMaintenanceConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationMaintenanceConfigurationDescription").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_UPDATED_FROM_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionUpdatedFrom")
            .getter(getter(ApplicationDetail::applicationVersionUpdatedFrom))
            .setter(setter(Builder::applicationVersionUpdatedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionUpdatedFrom")
                    .build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ROLLED_BACK_FROM_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionRolledBackFrom")
            .getter(getter(ApplicationDetail::applicationVersionRolledBackFrom))
            .setter(setter(Builder::applicationVersionRolledBackFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionRolledBackFrom")
                    .build()).build();

    private static final SdkField<String> CONDITIONAL_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionalToken").getter(getter(ApplicationDetail::conditionalToken))
            .setter(setter(Builder::conditionalToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalToken").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ROLLED_BACK_TO_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionRolledBackTo")
            .getter(getter(ApplicationDetail::applicationVersionRolledBackTo))
            .setter(setter(Builder::applicationVersionRolledBackTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionRolledBackTo")
                    .build()).build();

    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationMode").getter(getter(ApplicationDetail::applicationModeAsString))
            .setter(setter(Builder::applicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_DESCRIPTION_FIELD, APPLICATION_NAME_FIELD, RUNTIME_ENVIRONMENT_FIELD, SERVICE_EXECUTION_ROLE_FIELD,
            APPLICATION_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, CREATE_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD,
            APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD,
            APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD, APPLICATION_VERSION_UPDATED_FROM_FIELD,
            APPLICATION_VERSION_ROLLED_BACK_FROM_FIELD, CONDITIONAL_TOKEN_FIELD, APPLICATION_VERSION_ROLLED_BACK_TO_FIELD,
            APPLICATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationARN;

    private final String applicationDescription;

    private final String applicationName;

    private final String runtimeEnvironment;

    private final String serviceExecutionRole;

    private final String applicationStatus;

    private final Long applicationVersionId;

    private final Instant createTimestamp;

    private final Instant lastUpdateTimestamp;

    private final ApplicationConfigurationDescription applicationConfigurationDescription;

    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

    private final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;

    private final Long applicationVersionUpdatedFrom;

    private final Long applicationVersionRolledBackFrom;

    private final String conditionalToken;

    private final Long applicationVersionRolledBackTo;

    private final String applicationMode;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationARN = builder.applicationARN;
        this.applicationDescription = builder.applicationDescription;
        this.applicationName = builder.applicationName;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.applicationStatus = builder.applicationStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.applicationConfigurationDescription = builder.applicationConfigurationDescription;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
        this.applicationMaintenanceConfigurationDescription = builder.applicationMaintenanceConfigurationDescription;
        this.applicationVersionUpdatedFrom = builder.applicationVersionUpdatedFrom;
        this.applicationVersionRolledBackFrom = builder.applicationVersionRolledBackFrom;
        this.conditionalToken = builder.conditionalToken;
        this.applicationVersionRolledBackTo = builder.applicationVersionRolledBackTo;
        this.applicationMode = builder.applicationMode;
    }

    /**
     * <p>
     * The ARN of the application.
     * </p>
     * 
     * @return The ARN of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>, <code>FLINK-1_8</code>
     * , or <code>FLINK-1_11</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>,
     *         <code>FLINK-1_8</code>, or <code>FLINK-1_11</code>).
     * @see RuntimeEnvironment
     */
    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(runtimeEnvironment);
    }

    /**
     * <p>
     * The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>, <code>FLINK-1_8</code>
     * , or <code>FLINK-1_11</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>,
     *         <code>FLINK-1_8</code>, or <code>FLINK-1_11</code>).
     * @see RuntimeEnvironment
     */
    public final String runtimeEnvironmentAsString() {
        return runtimeEnvironment;
    }

    /**
     * <p>
     * Specifies the IAM role that the application uses to access external resources.
     * </p>
     * 
     * @return Specifies the IAM role that the application uses to access external resources.
     */
    public final String serviceExecutionRole() {
        return serviceExecutionRole;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    /**
     * <p>
     * Provides the current application version. Kinesis Data Analytics updates the <code>ApplicationVersionId</code>
     * each time you update the application.
     * </p>
     * 
     * @return Provides the current application version. Kinesis Data Analytics updates the
     *         <code>ApplicationVersionId</code> each time you update the application.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The current timestamp when the application was created.
     * </p>
     * 
     * @return The current timestamp when the application was created.
     */
    public final Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * The current timestamp when the application was last updated.
     * </p>
     * 
     * @return The current timestamp when the application was last updated.
     */
    public final Instant lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * Describes details about the application code and starting parameters for a Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes details about the application code and starting parameters for a Kinesis Data Analytics
     *         application.
     */
    public final ApplicationConfigurationDescription applicationConfigurationDescription() {
        return applicationConfigurationDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchLoggingOptionDescriptions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions != null
                && !(cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the application Amazon CloudWatch logging options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchLoggingOptionDescriptions}
     * method.
     * </p>
     * 
     * @return Describes the application Amazon CloudWatch logging options.
     */
    public final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions;
    }

    /**
     * <p>
     * The details of the maintenance configuration for the application.
     * </p>
     * 
     * @return The details of the maintenance configuration for the application.
     */
    public final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription() {
        return applicationMaintenanceConfigurationDescription;
    }

    /**
     * <p>
     * The previous application version before the latest application update. <a>RollbackApplication</a> reverts the
     * application to this version.
     * </p>
     * 
     * @return The previous application version before the latest application update. <a>RollbackApplication</a> reverts
     *         the application to this version.
     */
    public final Long applicationVersionUpdatedFrom() {
        return applicationVersionUpdatedFrom;
    }

    /**
     * <p>
     * If you reverted the application using <a>RollbackApplication</a>, the application version when
     * <code>RollbackApplication</code> was called.
     * </p>
     * 
     * @return If you reverted the application using <a>RollbackApplication</a>, the application version when
     *         <code>RollbackApplication</code> was called.
     */
    public final Long applicationVersionRolledBackFrom() {
        return applicationVersionRolledBackFrom;
    }

    /**
     * <p>
     * A value you use to implement strong concurrency for application updates.
     * </p>
     * 
     * @return A value you use to implement strong concurrency for application updates.
     */
    public final String conditionalToken() {
        return conditionalToken;
    }

    /**
     * <p>
     * The version to which you want to roll back the application.
     * </p>
     * 
     * @return The version to which you want to roll back the application.
     */
    public final Long applicationVersionRolledBackTo() {
        return applicationVersionRolledBackTo;
    }

    /**
     * <p>
     * To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>. However,
     * for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>.
     *         However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     * @see ApplicationMode
     */
    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(applicationMode);
    }

    /**
     * <p>
     * To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>. However,
     * for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>.
     *         However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     * @see ApplicationMode
     */
    public final String applicationModeAsString() {
        return applicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfigurationDescription());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCloudWatchLoggingOptionDescriptions() ? cloudWatchLoggingOptionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationMaintenanceConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionUpdatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionRolledBackFrom());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalToken());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionRolledBackTo());
        hashCode = 31 * hashCode + Objects.hashCode(applicationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString())
                && Objects.equals(serviceExecutionRole(), other.serviceExecutionRole())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(createTimestamp(), other.createTimestamp())
                && Objects.equals(lastUpdateTimestamp(), other.lastUpdateTimestamp())
                && Objects.equals(applicationConfigurationDescription(), other.applicationConfigurationDescription())
                && hasCloudWatchLoggingOptionDescriptions() == other.hasCloudWatchLoggingOptionDescriptions()
                && Objects.equals(cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions())
                && Objects.equals(applicationMaintenanceConfigurationDescription(),
                        other.applicationMaintenanceConfigurationDescription())
                && Objects.equals(applicationVersionUpdatedFrom(), other.applicationVersionUpdatedFrom())
                && Objects.equals(applicationVersionRolledBackFrom(), other.applicationVersionRolledBackFrom())
                && Objects.equals(conditionalToken(), other.conditionalToken())
                && Objects.equals(applicationVersionRolledBackTo(), other.applicationVersionRolledBackTo())
                && Objects.equals(applicationModeAsString(), other.applicationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ApplicationDetail")
                .add("ApplicationARN", applicationARN())
                .add("ApplicationDescription", applicationDescription())
                .add("ApplicationName", applicationName())
                .add("RuntimeEnvironment", runtimeEnvironmentAsString())
                .add("ServiceExecutionRole", serviceExecutionRole())
                .add("ApplicationStatus", applicationStatusAsString())
                .add("ApplicationVersionId", applicationVersionId())
                .add("CreateTimestamp", createTimestamp())
                .add("LastUpdateTimestamp", lastUpdateTimestamp())
                .add("ApplicationConfigurationDescription", applicationConfigurationDescription())
                .add("CloudWatchLoggingOptionDescriptions",
                        hasCloudWatchLoggingOptionDescriptions() ? cloudWatchLoggingOptionDescriptions() : null)
                .add("ApplicationMaintenanceConfigurationDescription", applicationMaintenanceConfigurationDescription())
                .add("ApplicationVersionUpdatedFrom", applicationVersionUpdatedFrom())
                .add("ApplicationVersionRolledBackFrom", applicationVersionRolledBackFrom())
                .add("ConditionalToken", conditionalToken())
                .add("ApplicationVersionRolledBackTo", applicationVersionRolledBackTo())
                .add("ApplicationMode", applicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "RuntimeEnvironment":
            return Optional.ofNullable(clazz.cast(runtimeEnvironmentAsString()));
        case "ServiceExecutionRole":
            return Optional.ofNullable(clazz.cast(serviceExecutionRole()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "CreateTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "LastUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimestamp()));
        case "ApplicationConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationConfigurationDescription()));
        case "CloudWatchLoggingOptionDescriptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionDescriptions()));
        case "ApplicationMaintenanceConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationMaintenanceConfigurationDescription()));
        case "ApplicationVersionUpdatedFrom":
            return Optional.ofNullable(clazz.cast(applicationVersionUpdatedFrom()));
        case "ApplicationVersionRolledBackFrom":
            return Optional.ofNullable(clazz.cast(applicationVersionRolledBackFrom()));
        case "ConditionalToken":
            return Optional.ofNullable(clazz.cast(conditionalToken()));
        case "ApplicationVersionRolledBackTo":
            return Optional.ofNullable(clazz.cast(applicationVersionRolledBackTo()));
        case "ApplicationMode":
            return Optional.ofNullable(clazz.cast(applicationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDetail, T> g) {
        return obj -> g.apply((ApplicationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationDetail> {
        /**
         * <p>
         * The ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        The ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>,
         * <code>FLINK-1_8</code>, or <code>FLINK-1_11</code>).
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>,
         *        <code>FLINK-1_8</code>, or <code>FLINK-1_11</code>).
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(String runtimeEnvironment);

        /**
         * <p>
         * The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>,
         * <code>FLINK-1_8</code>, or <code>FLINK-1_11</code>).
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application (<code>SQL-1_0</code>, <code>FLINK-1_6</code>,
         *        <code>FLINK-1_8</code>, or <code>FLINK-1_11</code>).
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment);

        /**
         * <p>
         * Specifies the IAM role that the application uses to access external resources.
         * </p>
         * 
         * @param serviceExecutionRole
         *        Specifies the IAM role that the application uses to access external resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRole(String serviceExecutionRole);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * Provides the current application version. Kinesis Data Analytics updates the
         * <code>ApplicationVersionId</code> each time you update the application.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version. Kinesis Data Analytics updates the
         *        <code>ApplicationVersionId</code> each time you update the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The current timestamp when the application was created.
         * </p>
         * 
         * @param createTimestamp
         *        The current timestamp when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * <p>
         * The current timestamp when the application was last updated.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The current timestamp when the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Instant lastUpdateTimestamp);

        /**
         * <p>
         * Describes details about the application code and starting parameters for a Kinesis Data Analytics
         * application.
         * </p>
         * 
         * @param applicationConfigurationDescription
         *        Describes details about the application code and starting parameters for a Kinesis Data Analytics
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfigurationDescription(ApplicationConfigurationDescription applicationConfigurationDescription);

        /**
         * <p>
         * Describes details about the application code and starting parameters for a Kinesis Data Analytics
         * application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link ApplicationConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationConfigurationDescription(ApplicationConfigurationDescription)}.
         * 
         * @param applicationConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfigurationDescription(ApplicationConfigurationDescription)
         */
        default Builder applicationConfigurationDescription(
                Consumer<ApplicationConfigurationDescription.Builder> applicationConfigurationDescription) {
            return applicationConfigurationDescription(ApplicationConfigurationDescription.builder()
                    .applyMutation(applicationConfigurationDescription).build());
        }

        /**
         * <p>
         * Describes the application Amazon CloudWatch logging options.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        Describes the application Amazon CloudWatch logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * Describes the application Amazon CloudWatch logging options.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        Describes the application Amazon CloudWatch logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * Describes the application Amazon CloudWatch logging options.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CloudWatchLoggingOptionDescription>.Builder} avoiding the need to create one manually via {@link List
         * <CloudWatchLoggingOptionDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLoggingOptionDescription>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cloudWatchLoggingOptionDescriptions(List<CloudWatchLoggingOptionDescription>)}.
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        a consumer that will call methods on {@link List<CloudWatchLoggingOptionDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptionDescriptions(List<CloudWatchLoggingOptionDescription>)
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Consumer<CloudWatchLoggingOptionDescription.Builder>... cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * The details of the maintenance configuration for the application.
         * </p>
         * 
         * @param applicationMaintenanceConfigurationDescription
         *        The details of the maintenance configuration for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMaintenanceConfigurationDescription(
                ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription);

        /**
         * <p>
         * The details of the maintenance configuration for the application.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link ApplicationMaintenanceConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ApplicationMaintenanceConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationMaintenanceConfigurationDescription.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription)}.
         * 
         * @param applicationMaintenanceConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationMaintenanceConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription)
         */
        default Builder applicationMaintenanceConfigurationDescription(
                Consumer<ApplicationMaintenanceConfigurationDescription.Builder> applicationMaintenanceConfigurationDescription) {
            return applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription.builder()
                    .applyMutation(applicationMaintenanceConfigurationDescription).build());
        }

        /**
         * <p>
         * The previous application version before the latest application update. <a>RollbackApplication</a> reverts the
         * application to this version.
         * </p>
         * 
         * @param applicationVersionUpdatedFrom
         *        The previous application version before the latest application update. <a>RollbackApplication</a>
         *        reverts the application to this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom);

        /**
         * <p>
         * If you reverted the application using <a>RollbackApplication</a>, the application version when
         * <code>RollbackApplication</code> was called.
         * </p>
         * 
         * @param applicationVersionRolledBackFrom
         *        If you reverted the application using <a>RollbackApplication</a>, the application version when
         *        <code>RollbackApplication</code> was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionRolledBackFrom(Long applicationVersionRolledBackFrom);

        /**
         * <p>
         * A value you use to implement strong concurrency for application updates.
         * </p>
         * 
         * @param conditionalToken
         *        A value you use to implement strong concurrency for application updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalToken(String conditionalToken);

        /**
         * <p>
         * The version to which you want to roll back the application.
         * </p>
         * 
         * @param applicationVersionRolledBackTo
         *        The version to which you want to roll back the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionRolledBackTo(Long applicationVersionRolledBackTo);

        /**
         * <p>
         * To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>.
         * However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         * </p>
         * 
         * @param applicationMode
         *        To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>.
         *        However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(String applicationMode);

        /**
         * <p>
         * To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>.
         * However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         * </p>
         * 
         * @param applicationMode
         *        To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code>.
         *        However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(ApplicationMode applicationMode);
    }

    static final class BuilderImpl implements Builder {
        private String applicationARN;

        private String applicationDescription;

        private String applicationName;

        private String runtimeEnvironment;

        private String serviceExecutionRole;

        private String applicationStatus;

        private Long applicationVersionId;

        private Instant createTimestamp;

        private Instant lastUpdateTimestamp;

        private ApplicationConfigurationDescription applicationConfigurationDescription;

        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList
                .getInstance();

        private ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;

        private Long applicationVersionUpdatedFrom;

        private Long applicationVersionRolledBackFrom;

        private String conditionalToken;

        private Long applicationVersionRolledBackTo;

        private String applicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            applicationARN(model.applicationARN);
            applicationDescription(model.applicationDescription);
            applicationName(model.applicationName);
            runtimeEnvironment(model.runtimeEnvironment);
            serviceExecutionRole(model.serviceExecutionRole);
            applicationStatus(model.applicationStatus);
            applicationVersionId(model.applicationVersionId);
            createTimestamp(model.createTimestamp);
            lastUpdateTimestamp(model.lastUpdateTimestamp);
            applicationConfigurationDescription(model.applicationConfigurationDescription);
            cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
            applicationMaintenanceConfigurationDescription(model.applicationMaintenanceConfigurationDescription);
            applicationVersionUpdatedFrom(model.applicationVersionUpdatedFrom);
            applicationVersionRolledBackFrom(model.applicationVersionRolledBackFrom);
            conditionalToken(model.conditionalToken);
            applicationVersionRolledBackTo(model.applicationVersionRolledBackTo);
            applicationMode(model.applicationMode);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        @Transient
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        @Transient
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getRuntimeEnvironment() {
            return runtimeEnvironment;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        @Override
        @Transient
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        @Transient
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public final String getServiceExecutionRole() {
            return serviceExecutionRole;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        @Override
        @Transient
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        @Transient
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        @Transient
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        @Transient
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final ApplicationConfigurationDescription.Builder getApplicationConfigurationDescription() {
            return applicationConfigurationDescription != null ? applicationConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationConfigurationDescription(
                ApplicationConfigurationDescription.BuilderImpl applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription != null ? applicationConfigurationDescription
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder applicationConfigurationDescription(
                ApplicationConfigurationDescription applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription;
            return this;
        }

        public final List<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            List<CloudWatchLoggingOptionDescription.Builder> result = CloudWatchLoggingOptionDescriptionsCopier
                    .copyToBuilder(this.cloudWatchLoggingOptionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions) {
            cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                Consumer<CloudWatchLoggingOptionDescription.Builder>... cloudWatchLoggingOptionDescriptions) {
            cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions)
                    .map(c -> CloudWatchLoggingOptionDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationMaintenanceConfigurationDescription.Builder getApplicationMaintenanceConfigurationDescription() {
            return applicationMaintenanceConfigurationDescription != null ? applicationMaintenanceConfigurationDescription
                    .toBuilder() : null;
        }

        public final void setApplicationMaintenanceConfigurationDescription(
                ApplicationMaintenanceConfigurationDescription.BuilderImpl applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription != null ? applicationMaintenanceConfigurationDescription
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder applicationMaintenanceConfigurationDescription(
                ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription;
            return this;
        }

        public final Long getApplicationVersionUpdatedFrom() {
            return applicationVersionUpdatedFrom;
        }

        public final void setApplicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom) {
            this.applicationVersionUpdatedFrom = applicationVersionUpdatedFrom;
        }

        @Override
        @Transient
        public final Builder applicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom) {
            this.applicationVersionUpdatedFrom = applicationVersionUpdatedFrom;
            return this;
        }

        public final Long getApplicationVersionRolledBackFrom() {
            return applicationVersionRolledBackFrom;
        }

        public final void setApplicationVersionRolledBackFrom(Long applicationVersionRolledBackFrom) {
            this.applicationVersionRolledBackFrom = applicationVersionRolledBackFrom;
        }

        @Override
        @Transient
        public final Builder applicationVersionRolledBackFrom(Long applicationVersionRolledBackFrom) {
            this.applicationVersionRolledBackFrom = applicationVersionRolledBackFrom;
            return this;
        }

        public final String getConditionalToken() {
            return conditionalToken;
        }

        public final void setConditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
        }

        @Override
        @Transient
        public final Builder conditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
            return this;
        }

        public final Long getApplicationVersionRolledBackTo() {
            return applicationVersionRolledBackTo;
        }

        public final void setApplicationVersionRolledBackTo(Long applicationVersionRolledBackTo) {
            this.applicationVersionRolledBackTo = applicationVersionRolledBackTo;
        }

        @Override
        @Transient
        public final Builder applicationVersionRolledBackTo(Long applicationVersionRolledBackTo) {
            this.applicationVersionRolledBackTo = applicationVersionRolledBackTo;
            return this;
        }

        public final String getApplicationMode() {
            return applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        @Transient
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        @Override
        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
