/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to the checkpointing parameters for a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckpointConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<CheckpointConfigurationUpdate.Builder, CheckpointConfigurationUpdate> {
    private static final SdkField<String> CONFIGURATION_TYPE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationTypeUpdate").getter(getter(CheckpointConfigurationUpdate::configurationTypeUpdateAsString))
            .setter(setter(Builder::configurationTypeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTypeUpdate").build())
            .build();

    private static final SdkField<Boolean> CHECKPOINTING_ENABLED_UPDATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CheckpointingEnabledUpdate")
            .getter(getter(CheckpointConfigurationUpdate::checkpointingEnabledUpdate))
            .setter(setter(Builder::checkpointingEnabledUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointingEnabledUpdate").build())
            .build();

    private static final SdkField<Long> CHECKPOINT_INTERVAL_UPDATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CheckpointIntervalUpdate").getter(getter(CheckpointConfigurationUpdate::checkpointIntervalUpdate))
            .setter(setter(Builder::checkpointIntervalUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointIntervalUpdate").build())
            .build();

    private static final SdkField<Long> MIN_PAUSE_BETWEEN_CHECKPOINTS_UPDATE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MinPauseBetweenCheckpointsUpdate")
            .getter(getter(CheckpointConfigurationUpdate::minPauseBetweenCheckpointsUpdate))
            .setter(setter(Builder::minPauseBetweenCheckpointsUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinPauseBetweenCheckpointsUpdate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_TYPE_UPDATE_FIELD, CHECKPOINTING_ENABLED_UPDATE_FIELD, CHECKPOINT_INTERVAL_UPDATE_FIELD,
            MIN_PAUSE_BETWEEN_CHECKPOINTS_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationTypeUpdate;

    private final Boolean checkpointingEnabledUpdate;

    private final Long checkpointIntervalUpdate;

    private final Long minPauseBetweenCheckpointsUpdate;

    private CheckpointConfigurationUpdate(BuilderImpl builder) {
        this.configurationTypeUpdate = builder.configurationTypeUpdate;
        this.checkpointingEnabledUpdate = builder.checkpointingEnabledUpdate;
        this.checkpointIntervalUpdate = builder.checkpointIntervalUpdate;
        this.minPauseBetweenCheckpointsUpdate = builder.minPauseBetweenCheckpointsUpdate;
    }

    /**
     * <p>
     * Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data Analytics.
     * You must set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
     * <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.
     * </p>
     * <note>
     * <p>
     * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are set
     * to other values using APIs or application code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CheckpointingEnabled:</b> true
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CheckpointInterval:</b> 60000
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MinPauseBetweenCheckpoints:</b> 5000
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationTypeUpdate} will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data
     *         Analytics. You must set this property to <code>CUSTOM</code> in order to set the
     *         <code>CheckpointingEnabled</code>, <code>CheckpointInterval</code>, or
     *         <code>MinPauseBetweenCheckpoints</code> parameters. </p> <note>
     *         <p>
     *         If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they
     *         are set to other values using APIs or application code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CheckpointingEnabled:</b> true
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CheckpointInterval:</b> 60000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MinPauseBetweenCheckpoints:</b> 5000
     *         </p>
     *         </li>
     *         </ul>
     * @see ConfigurationType
     */
    public final ConfigurationType configurationTypeUpdate() {
        return ConfigurationType.fromValue(configurationTypeUpdate);
    }

    /**
     * <p>
     * Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data Analytics.
     * You must set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code>,
     * <code>CheckpointInterval</code>, or <code>MinPauseBetweenCheckpoints</code> parameters.
     * </p>
     * <note>
     * <p>
     * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are set
     * to other values using APIs or application code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CheckpointingEnabled:</b> true
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CheckpointInterval:</b> 60000
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MinPauseBetweenCheckpoints:</b> 5000
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationTypeUpdate} will return {@link ConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data
     *         Analytics. You must set this property to <code>CUSTOM</code> in order to set the
     *         <code>CheckpointingEnabled</code>, <code>CheckpointInterval</code>, or
     *         <code>MinPauseBetweenCheckpoints</code> parameters. </p> <note>
     *         <p>
     *         If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they
     *         are set to other values using APIs or application code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CheckpointingEnabled:</b> true
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CheckpointInterval:</b> 60000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MinPauseBetweenCheckpoints:</b> 5000
     *         </p>
     *         </li>
     *         </ul>
     * @see ConfigurationType
     */
    public final String configurationTypeUpdateAsString() {
        return configurationTypeUpdate;
    }

    /**
     * <p>
     * Describes updates to whether checkpointing is enabled for an application.
     * </p>
     * <note>
     * <p>
     * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
     * <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to another value using
     * this API or in application code.
     * </p>
     * </note>
     * 
     * @return Describes updates to whether checkpointing is enabled for an application.</p> <note>
     *         <p>
     *         If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will
     *         use a <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to another
     *         value using this API or in application code.
     *         </p>
     */
    public final Boolean checkpointingEnabledUpdate() {
        return checkpointingEnabledUpdate;
    }

    /**
     * <p>
     * Describes updates to the interval in milliseconds between checkpoint operations.
     * </p>
     * <note>
     * <p>
     * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
     * <code>CheckpointInterval</code> value of 60000, even if this value is set to another value using this API or in
     * application code.
     * </p>
     * </note>
     * 
     * @return Describes updates to the interval in milliseconds between checkpoint operations.</p> <note>
     *         <p>
     *         If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will
     *         use a <code>CheckpointInterval</code> value of 60000, even if this value is set to another value using
     *         this API or in application code.
     *         </p>
     */
    public final Long checkpointIntervalUpdate() {
        return checkpointIntervalUpdate;
    }

    /**
     * <p>
     * Describes updates to the minimum time in milliseconds after a checkpoint operation completes that a new
     * checkpoint operation can start.
     * </p>
     * <note>
     * <p>
     * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
     * <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or in application
     * code.
     * </p>
     * </note>
     * 
     * @return Describes updates to the minimum time in milliseconds after a checkpoint operation completes that a new
     *         checkpoint operation can start.</p> <note>
     *         <p>
     *         If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will
     *         use a <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or
     *         in application code.
     *         </p>
     */
    public final Long minPauseBetweenCheckpointsUpdate() {
        return minPauseBetweenCheckpointsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointingEnabledUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointIntervalUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(minPauseBetweenCheckpointsUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointConfigurationUpdate)) {
            return false;
        }
        CheckpointConfigurationUpdate other = (CheckpointConfigurationUpdate) obj;
        return Objects.equals(configurationTypeUpdateAsString(), other.configurationTypeUpdateAsString())
                && Objects.equals(checkpointingEnabledUpdate(), other.checkpointingEnabledUpdate())
                && Objects.equals(checkpointIntervalUpdate(), other.checkpointIntervalUpdate())
                && Objects.equals(minPauseBetweenCheckpointsUpdate(), other.minPauseBetweenCheckpointsUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckpointConfigurationUpdate")
                .add("ConfigurationTypeUpdate", configurationTypeUpdateAsString())
                .add("CheckpointingEnabledUpdate", checkpointingEnabledUpdate())
                .add("CheckpointIntervalUpdate", checkpointIntervalUpdate())
                .add("MinPauseBetweenCheckpointsUpdate", minPauseBetweenCheckpointsUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationTypeUpdate":
            return Optional.ofNullable(clazz.cast(configurationTypeUpdateAsString()));
        case "CheckpointingEnabledUpdate":
            return Optional.ofNullable(clazz.cast(checkpointingEnabledUpdate()));
        case "CheckpointIntervalUpdate":
            return Optional.ofNullable(clazz.cast(checkpointIntervalUpdate()));
        case "MinPauseBetweenCheckpointsUpdate":
            return Optional.ofNullable(clazz.cast(minPauseBetweenCheckpointsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckpointConfigurationUpdate, T> g) {
        return obj -> g.apply((CheckpointConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckpointConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data
         * Analytics. You must set this property to <code>CUSTOM</code> in order to set the
         * <code>CheckpointingEnabled</code>, <code>CheckpointInterval</code>, or
         * <code>MinPauseBetweenCheckpoints</code> parameters.
         * </p>
         * <note>
         * <p>
         * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are
         * set to other values using APIs or application code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CheckpointingEnabled:</b> true
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CheckpointInterval:</b> 60000
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MinPauseBetweenCheckpoints:</b> 5000
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param configurationTypeUpdate
         *        Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data
         *        Analytics. You must set this property to <code>CUSTOM</code> in order to set the
         *        <code>CheckpointingEnabled</code>, <code>CheckpointInterval</code>, or
         *        <code>MinPauseBetweenCheckpoints</code> parameters. </p> <note>
         *        <p>
         *        If this value is set to <code>DEFAULT</code>, the application will use the following values, even if
         *        they are set to other values using APIs or application code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CheckpointingEnabled:</b> true
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CheckpointInterval:</b> 60000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MinPauseBetweenCheckpoints:</b> 5000
         *        </p>
         *        </li>
         *        </ul>
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationTypeUpdate(String configurationTypeUpdate);

        /**
         * <p>
         * Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data
         * Analytics. You must set this property to <code>CUSTOM</code> in order to set the
         * <code>CheckpointingEnabled</code>, <code>CheckpointInterval</code>, or
         * <code>MinPauseBetweenCheckpoints</code> parameters.
         * </p>
         * <note>
         * <p>
         * If this value is set to <code>DEFAULT</code>, the application will use the following values, even if they are
         * set to other values using APIs or application code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CheckpointingEnabled:</b> true
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CheckpointInterval:</b> 60000
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MinPauseBetweenCheckpoints:</b> 5000
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param configurationTypeUpdate
         *        Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data
         *        Analytics. You must set this property to <code>CUSTOM</code> in order to set the
         *        <code>CheckpointingEnabled</code>, <code>CheckpointInterval</code>, or
         *        <code>MinPauseBetweenCheckpoints</code> parameters. </p> <note>
         *        <p>
         *        If this value is set to <code>DEFAULT</code>, the application will use the following values, even if
         *        they are set to other values using APIs or application code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CheckpointingEnabled:</b> true
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CheckpointInterval:</b> 60000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MinPauseBetweenCheckpoints:</b> 5000
         *        </p>
         *        </li>
         *        </ul>
         * @see ConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationType
         */
        Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate);

        /**
         * <p>
         * Describes updates to whether checkpointing is enabled for an application.
         * </p>
         * <note>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
         * <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to another value
         * using this API or in application code.
         * </p>
         * </note>
         * 
         * @param checkpointingEnabledUpdate
         *        Describes updates to whether checkpointing is enabled for an application.</p> <note>
         *        <p>
         *        If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application
         *        will use a <code>CheckpointingEnabled</code> value of <code>true</code>, even if this value is set to
         *        another value using this API or in application code.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointingEnabledUpdate(Boolean checkpointingEnabledUpdate);

        /**
         * <p>
         * Describes updates to the interval in milliseconds between checkpoint operations.
         * </p>
         * <note>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
         * <code>CheckpointInterval</code> value of 60000, even if this value is set to another value using this API or
         * in application code.
         * </p>
         * </note>
         * 
         * @param checkpointIntervalUpdate
         *        Describes updates to the interval in milliseconds between checkpoint operations.</p> <note>
         *        <p>
         *        If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application
         *        will use a <code>CheckpointInterval</code> value of 60000, even if this value is set to another value
         *        using this API or in application code.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointIntervalUpdate(Long checkpointIntervalUpdate);

        /**
         * <p>
         * Describes updates to the minimum time in milliseconds after a checkpoint operation completes that a new
         * checkpoint operation can start.
         * </p>
         * <note>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application will use a
         * <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or in
         * application code.
         * </p>
         * </note>
         * 
         * @param minPauseBetweenCheckpointsUpdate
         *        Describes updates to the minimum time in milliseconds after a checkpoint operation completes that a
         *        new checkpoint operation can start.</p> <note>
         *        <p>
         *        If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code>, the application
         *        will use a <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this
         *        API or in application code.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minPauseBetweenCheckpointsUpdate(Long minPauseBetweenCheckpointsUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String configurationTypeUpdate;

        private Boolean checkpointingEnabledUpdate;

        private Long checkpointIntervalUpdate;

        private Long minPauseBetweenCheckpointsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointConfigurationUpdate model) {
            configurationTypeUpdate(model.configurationTypeUpdate);
            checkpointingEnabledUpdate(model.checkpointingEnabledUpdate);
            checkpointIntervalUpdate(model.checkpointIntervalUpdate);
            minPauseBetweenCheckpointsUpdate(model.minPauseBetweenCheckpointsUpdate);
        }

        public final String getConfigurationTypeUpdate() {
            return configurationTypeUpdate;
        }

        public final void setConfigurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
        }

        @Override
        @Transient
        public final Builder configurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
            return this;
        }

        @Override
        @Transient
        public final Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate) {
            this.configurationTypeUpdate(configurationTypeUpdate == null ? null : configurationTypeUpdate.toString());
            return this;
        }

        public final Boolean getCheckpointingEnabledUpdate() {
            return checkpointingEnabledUpdate;
        }

        public final void setCheckpointingEnabledUpdate(Boolean checkpointingEnabledUpdate) {
            this.checkpointingEnabledUpdate = checkpointingEnabledUpdate;
        }

        @Override
        @Transient
        public final Builder checkpointingEnabledUpdate(Boolean checkpointingEnabledUpdate) {
            this.checkpointingEnabledUpdate = checkpointingEnabledUpdate;
            return this;
        }

        public final Long getCheckpointIntervalUpdate() {
            return checkpointIntervalUpdate;
        }

        public final void setCheckpointIntervalUpdate(Long checkpointIntervalUpdate) {
            this.checkpointIntervalUpdate = checkpointIntervalUpdate;
        }

        @Override
        @Transient
        public final Builder checkpointIntervalUpdate(Long checkpointIntervalUpdate) {
            this.checkpointIntervalUpdate = checkpointIntervalUpdate;
            return this;
        }

        public final Long getMinPauseBetweenCheckpointsUpdate() {
            return minPauseBetweenCheckpointsUpdate;
        }

        public final void setMinPauseBetweenCheckpointsUpdate(Long minPauseBetweenCheckpointsUpdate) {
            this.minPauseBetweenCheckpointsUpdate = minPauseBetweenCheckpointsUpdate;
        }

        @Override
        @Transient
        public final Builder minPauseBetweenCheckpointsUpdate(Long minPauseBetweenCheckpointsUpdate) {
            this.minPauseBetweenCheckpointsUpdate = minPauseBetweenCheckpointsUpdate;
            return this;
        }

        @Override
        public CheckpointConfigurationUpdate build() {
            return new CheckpointConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
