/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon CloudWatch logging option updates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLoggingOptionUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLoggingOptionUpdate.Builder, CloudWatchLoggingOptionUpdate> {
    private static final SdkField<String> CLOUD_WATCH_LOGGING_OPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLoggingOptionId").getter(getter(CloudWatchLoggingOptionUpdate::cloudWatchLoggingOptionId))
            .setter(setter(Builder::cloudWatchLoggingOptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionId").build())
            .build();

    private static final SdkField<String> LOG_STREAM_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStreamARNUpdate").getter(getter(CloudWatchLoggingOptionUpdate::logStreamARNUpdate))
            .setter(setter(Builder::logStreamARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamARNUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGGING_OPTION_ID_FIELD, LOG_STREAM_ARN_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLoggingOptionId;

    private final String logStreamARNUpdate;

    private CloudWatchLoggingOptionUpdate(BuilderImpl builder) {
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.logStreamARNUpdate = builder.logStreamARNUpdate;
    }

    /**
     * <p>
     * The ID of the CloudWatch logging option to update
     * </p>
     * 
     * @return The ID of the CloudWatch logging option to update
     */
    public final String cloudWatchLoggingOptionId() {
        return cloudWatchLoggingOptionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch log to receive application messages.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch log to receive application messages.
     */
    public final String logStreamARNUpdate() {
        return logStreamARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamARNUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptionUpdate)) {
            return false;
        }
        CloudWatchLoggingOptionUpdate other = (CloudWatchLoggingOptionUpdate) obj;
        return Objects.equals(cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId())
                && Objects.equals(logStreamARNUpdate(), other.logStreamARNUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLoggingOptionUpdate").add("CloudWatchLoggingOptionId", cloudWatchLoggingOptionId())
                .add("LogStreamARNUpdate", logStreamARNUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLoggingOptionId":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionId()));
        case "LogStreamARNUpdate":
            return Optional.ofNullable(clazz.cast(logStreamARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOptionUpdate, T> g) {
        return obj -> g.apply((CloudWatchLoggingOptionUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLoggingOptionUpdate> {
        /**
         * <p>
         * The ID of the CloudWatch logging option to update
         * </p>
         * 
         * @param cloudWatchLoggingOptionId
         *        The ID of the CloudWatch logging option to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch log to receive application messages.
         * </p>
         * 
         * @param logStreamARNUpdate
         *        The Amazon Resource Name (ARN) of the CloudWatch log to receive application messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamARNUpdate(String logStreamARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLoggingOptionId;

        private String logStreamARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptionUpdate model) {
            cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            logStreamARNUpdate(model.logStreamARNUpdate);
        }

        public final String getCloudWatchLoggingOptionId() {
            return cloudWatchLoggingOptionId;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final String getLogStreamARNUpdate() {
            return logStreamARNUpdate;
        }

        public final void setLogStreamARNUpdate(String logStreamARNUpdate) {
            this.logStreamARNUpdate = logStreamARNUpdate;
        }

        @Override
        @Transient
        public final Builder logStreamARNUpdate(String logStreamARNUpdate) {
            this.logStreamARNUpdate = logStreamARNUpdate;
            return this;
        }

        @Override
        public CloudWatchLoggingOptionUpdate build() {
            return new CloudWatchLoggingOptionUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
