/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information required to deploy an Amazon Data Analytics Studio notebook as an application with
 * durable state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeployAsApplicationConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DeployAsApplicationConfigurationDescription.Builder, DeployAsApplicationConfigurationDescription> {
    private static final SdkField<S3ContentBaseLocationDescription> S3_CONTENT_LOCATION_DESCRIPTION_FIELD = SdkField
            .<S3ContentBaseLocationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("S3ContentLocationDescription")
            .getter(getter(DeployAsApplicationConfigurationDescription::s3ContentLocationDescription))
            .setter(setter(Builder::s3ContentLocationDescription))
            .constructor(S3ContentBaseLocationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocationDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_CONTENT_LOCATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3ContentBaseLocationDescription s3ContentLocationDescription;

    private DeployAsApplicationConfigurationDescription(BuilderImpl builder) {
        this.s3ContentLocationDescription = builder.s3ContentLocationDescription;
    }

    /**
     * <p>
     * The location that holds the data required to specify an Amazon Data Analytics application.
     * </p>
     * 
     * @return The location that holds the data required to specify an Amazon Data Analytics application.
     */
    public final S3ContentBaseLocationDescription s3ContentLocationDescription() {
        return s3ContentLocationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ContentLocationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployAsApplicationConfigurationDescription)) {
            return false;
        }
        DeployAsApplicationConfigurationDescription other = (DeployAsApplicationConfigurationDescription) obj;
        return Objects.equals(s3ContentLocationDescription(), other.s3ContentLocationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeployAsApplicationConfigurationDescription")
                .add("S3ContentLocationDescription", s3ContentLocationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ContentLocationDescription":
            return Optional.ofNullable(clazz.cast(s3ContentLocationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeployAsApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((DeployAsApplicationConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeployAsApplicationConfigurationDescription> {
        /**
         * <p>
         * The location that holds the data required to specify an Amazon Data Analytics application.
         * </p>
         * 
         * @param s3ContentLocationDescription
         *        The location that holds the data required to specify an Amazon Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ContentLocationDescription(S3ContentBaseLocationDescription s3ContentLocationDescription);

        /**
         * <p>
         * The location that holds the data required to specify an Amazon Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link S3ContentBaseLocationDescription.Builder}
         * avoiding the need to create one manually via {@link S3ContentBaseLocationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ContentBaseLocationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3ContentLocationDescription(S3ContentBaseLocationDescription)}.
         * 
         * @param s3ContentLocationDescription
         *        a consumer that will call methods on {@link S3ContentBaseLocationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ContentLocationDescription(S3ContentBaseLocationDescription)
         */
        default Builder s3ContentLocationDescription(
                Consumer<S3ContentBaseLocationDescription.Builder> s3ContentLocationDescription) {
            return s3ContentLocationDescription(S3ContentBaseLocationDescription.builder()
                    .applyMutation(s3ContentLocationDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ContentBaseLocationDescription s3ContentLocationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployAsApplicationConfigurationDescription model) {
            s3ContentLocationDescription(model.s3ContentLocationDescription);
        }

        public final S3ContentBaseLocationDescription.Builder getS3ContentLocationDescription() {
            return s3ContentLocationDescription != null ? s3ContentLocationDescription.toBuilder() : null;
        }

        public final void setS3ContentLocationDescription(
                S3ContentBaseLocationDescription.BuilderImpl s3ContentLocationDescription) {
            this.s3ContentLocationDescription = s3ContentLocationDescription != null ? s3ContentLocationDescription.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder s3ContentLocationDescription(S3ContentBaseLocationDescription s3ContentLocationDescription) {
            this.s3ContentLocationDescription = s3ContentLocationDescription;
            return this;
        }

        @Override
        public DeployAsApplicationConfigurationDescription build() {
            return new DeployAsApplicationConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
