/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverInputSchemaResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<DiscoverInputSchemaResponse.Builder, DiscoverInputSchemaResponse> {
    private static final SdkField<SourceSchema> INPUT_SCHEMA_FIELD = SdkField.<SourceSchema> builder(MarshallingType.SDK_POJO)
            .memberName("InputSchema").getter(getter(DiscoverInputSchemaResponse::inputSchema))
            .setter(setter(Builder::inputSchema)).constructor(SourceSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSchema").build()).build();

    private static final SdkField<List<List<String>>> PARSED_INPUT_RECORDS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("ParsedInputRecords")
            .getter(getter(DiscoverInputSchemaResponse::parsedInputRecords))
            .setter(setter(Builder::parsedInputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParsedInputRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> PROCESSED_INPUT_RECORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProcessedInputRecords")
            .getter(getter(DiscoverInputSchemaResponse::processedInputRecords))
            .setter(setter(Builder::processedInputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedInputRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RAW_INPUT_RECORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RawInputRecords")
            .getter(getter(DiscoverInputSchemaResponse::rawInputRecords))
            .setter(setter(Builder::rawInputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawInputRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SCHEMA_FIELD,
            PARSED_INPUT_RECORDS_FIELD, PROCESSED_INPUT_RECORDS_FIELD, RAW_INPUT_RECORDS_FIELD));

    private final SourceSchema inputSchema;

    private final List<List<String>> parsedInputRecords;

    private final List<String> processedInputRecords;

    private final List<String> rawInputRecords;

    private DiscoverInputSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.inputSchema = builder.inputSchema;
        this.parsedInputRecords = builder.parsedInputRecords;
        this.processedInputRecords = builder.processedInputRecords;
        this.rawInputRecords = builder.rawInputRecords;
    }

    /**
     * <p>
     * The schema inferred from the streaming source. It identifies the format of the data in the streaming source and
     * how each data element maps to corresponding columns in the in-application stream that you can create.
     * </p>
     * 
     * @return The schema inferred from the streaming source. It identifies the format of the data in the streaming
     *         source and how each data element maps to corresponding columns in the in-application stream that you can
     *         create.
     */
    public final SourceSchema inputSchema() {
        return inputSchema;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParsedInputRecords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParsedInputRecords() {
        return parsedInputRecords != null && !(parsedInputRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of elements, where each element corresponds to a row in a stream record (a stream record can have more
     * than one row).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParsedInputRecords} method.
     * </p>
     * 
     * @return An array of elements, where each element corresponds to a row in a stream record (a stream record can
     *         have more than one row).
     */
    public final List<List<String>> parsedInputRecords() {
        return parsedInputRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessedInputRecords property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProcessedInputRecords() {
        return processedInputRecords != null && !(processedInputRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessedInputRecords} method.
     * </p>
     * 
     * @return The stream data that was modified by the processor specified in the
     *         <code>InputProcessingConfiguration</code> parameter.
     */
    public final List<String> processedInputRecords() {
        return processedInputRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the RawInputRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRawInputRecords() {
        return rawInputRecords != null && !(rawInputRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The raw stream data that was sampled to infer the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRawInputRecords} method.
     * </p>
     * 
     * @return The raw stream data that was sampled to infer the schema.
     */
    public final List<String> rawInputRecords() {
        return rawInputRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(hasParsedInputRecords() ? parsedInputRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessedInputRecords() ? processedInputRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRawInputRecords() ? rawInputRecords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaResponse)) {
            return false;
        }
        DiscoverInputSchemaResponse other = (DiscoverInputSchemaResponse) obj;
        return Objects.equals(inputSchema(), other.inputSchema()) && hasParsedInputRecords() == other.hasParsedInputRecords()
                && Objects.equals(parsedInputRecords(), other.parsedInputRecords())
                && hasProcessedInputRecords() == other.hasProcessedInputRecords()
                && Objects.equals(processedInputRecords(), other.processedInputRecords())
                && hasRawInputRecords() == other.hasRawInputRecords()
                && Objects.equals(rawInputRecords(), other.rawInputRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverInputSchemaResponse").add("InputSchema", inputSchema())
                .add("ParsedInputRecords", hasParsedInputRecords() ? parsedInputRecords() : null)
                .add("ProcessedInputRecords", hasProcessedInputRecords() ? processedInputRecords() : null)
                .add("RawInputRecords", hasRawInputRecords() ? rawInputRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputSchema":
            return Optional.ofNullable(clazz.cast(inputSchema()));
        case "ParsedInputRecords":
            return Optional.ofNullable(clazz.cast(parsedInputRecords()));
        case "ProcessedInputRecords":
            return Optional.ofNullable(clazz.cast(processedInputRecords()));
        case "RawInputRecords":
            return Optional.ofNullable(clazz.cast(rawInputRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInputSchemaResponse, T> g) {
        return obj -> g.apply((DiscoverInputSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DiscoverInputSchemaResponse> {
        /**
         * <p>
         * The schema inferred from the streaming source. It identifies the format of the data in the streaming source
         * and how each data element maps to corresponding columns in the in-application stream that you can create.
         * </p>
         * 
         * @param inputSchema
         *        The schema inferred from the streaming source. It identifies the format of the data in the streaming
         *        source and how each data element maps to corresponding columns in the in-application stream that you
         *        can create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SourceSchema inputSchema);

        /**
         * <p>
         * The schema inferred from the streaming source. It identifies the format of the data in the streaming source
         * and how each data element maps to corresponding columns in the in-application stream that you can create.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchema(SourceSchema)}.
         * 
         * @param inputSchema
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchema(SourceSchema)
         */
        default Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return inputSchema(SourceSchema.builder().applyMutation(inputSchema).build());
        }

        /**
         * <p>
         * An array of elements, where each element corresponds to a row in a stream record (a stream record can have
         * more than one row).
         * </p>
         * 
         * @param parsedInputRecords
         *        An array of elements, where each element corresponds to a row in a stream record (a stream record can
         *        have more than one row).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords);

        /**
         * <p>
         * An array of elements, where each element corresponds to a row in a stream record (a stream record can have
         * more than one row).
         * </p>
         * 
         * @param parsedInputRecords
         *        An array of elements, where each element corresponds to a row in a stream record (a stream record can
         *        have more than one row).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedInputRecords(Collection<String>... parsedInputRecords);

        /**
         * <p>
         * The stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
         * parameter.
         * </p>
         * 
         * @param processedInputRecords
         *        The stream data that was modified by the processor specified in the
         *        <code>InputProcessingConfiguration</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(Collection<String> processedInputRecords);

        /**
         * <p>
         * The stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
         * parameter.
         * </p>
         * 
         * @param processedInputRecords
         *        The stream data that was modified by the processor specified in the
         *        <code>InputProcessingConfiguration</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(String... processedInputRecords);

        /**
         * <p>
         * The raw stream data that was sampled to infer the schema.
         * </p>
         * 
         * @param rawInputRecords
         *        The raw stream data that was sampled to infer the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(Collection<String> rawInputRecords);

        /**
         * <p>
         * The raw stream data that was sampled to infer the schema.
         * </p>
         * 
         * @param rawInputRecords
         *        The raw stream data that was sampled to infer the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(String... rawInputRecords);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private SourceSchema inputSchema;

        private List<List<String>> parsedInputRecords = DefaultSdkAutoConstructList.getInstance();

        private List<String> processedInputRecords = DefaultSdkAutoConstructList.getInstance();

        private List<String> rawInputRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaResponse model) {
            super(model);
            inputSchema(model.inputSchema);
            parsedInputRecords(model.parsedInputRecords);
            processedInputRecords(model.processedInputRecords);
            rawInputRecords(model.rawInputRecords);
        }

        public final SourceSchema.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final Collection<? extends Collection<String>> getParsedInputRecords() {
            if (parsedInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return parsedInputRecords;
        }

        public final void setParsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
        }

        @Override
        @Transient
        public final Builder parsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parsedInputRecords(Collection<String>... parsedInputRecords) {
            parsedInputRecords(Arrays.asList(parsedInputRecords));
            return this;
        }

        public final Collection<String> getProcessedInputRecords() {
            if (processedInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return processedInputRecords;
        }

        public final void setProcessedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
        }

        @Override
        @Transient
        public final Builder processedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processedInputRecords(String... processedInputRecords) {
            processedInputRecords(Arrays.asList(processedInputRecords));
            return this;
        }

        public final Collection<String> getRawInputRecords() {
            if (rawInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return rawInputRecords;
        }

        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        @Override
        @Transient
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rawInputRecords(String... rawInputRecords) {
            rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        @Override
        public DiscoverInputSchemaResponse build() {
            return new DiscoverInputSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
