/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you configure the application input for a SQL-based Kinesis Data Analytics application, you specify the
 * streaming source, the in-application stream name that is created, and the mapping between the two.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Input implements SdkPojo, Serializable, ToCopyableBuilder<Input.Builder, Input> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(Input::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()).build();

    private static final SdkField<InputProcessingConfiguration> INPUT_PROCESSING_CONFIGURATION_FIELD = SdkField
            .<InputProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InputProcessingConfiguration")
            .getter(getter(Input::inputProcessingConfiguration))
            .setter(setter(Builder::inputProcessingConfiguration))
            .constructor(InputProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfiguration")
                    .build()).build();

    private static final SdkField<KinesisStreamsInput> KINESIS_STREAMS_INPUT_FIELD = SdkField
            .<KinesisStreamsInput> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamsInput")
            .getter(getter(Input::kinesisStreamsInput)).setter(setter(Builder::kinesisStreamsInput))
            .constructor(KinesisStreamsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsInput").build())
            .build();

    private static final SdkField<KinesisFirehoseInput> KINESIS_FIREHOSE_INPUT_FIELD = SdkField
            .<KinesisFirehoseInput> builder(MarshallingType.SDK_POJO).memberName("KinesisFirehoseInput")
            .getter(getter(Input::kinesisFirehoseInput)).setter(setter(Builder::kinesisFirehoseInput))
            .constructor(KinesisFirehoseInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseInput").build())
            .build();

    private static final SdkField<InputParallelism> INPUT_PARALLELISM_FIELD = SdkField
            .<InputParallelism> builder(MarshallingType.SDK_POJO).memberName("InputParallelism")
            .getter(getter(Input::inputParallelism)).setter(setter(Builder::inputParallelism))
            .constructor(InputParallelism::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParallelism").build()).build();

    private static final SdkField<SourceSchema> INPUT_SCHEMA_FIELD = SdkField.<SourceSchema> builder(MarshallingType.SDK_POJO)
            .memberName("InputSchema").getter(getter(Input::inputSchema)).setter(setter(Builder::inputSchema))
            .constructor(SourceSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD,
            INPUT_PROCESSING_CONFIGURATION_FIELD, KINESIS_STREAMS_INPUT_FIELD, KINESIS_FIREHOSE_INPUT_FIELD,
            INPUT_PARALLELISM_FIELD, INPUT_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namePrefix;

    private final InputProcessingConfiguration inputProcessingConfiguration;

    private final KinesisStreamsInput kinesisStreamsInput;

    private final KinesisFirehoseInput kinesisFirehoseInput;

    private final InputParallelism inputParallelism;

    private final SourceSchema inputSchema;

    private Input(BuilderImpl builder) {
        this.namePrefix = builder.namePrefix;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
        this.kinesisStreamsInput = builder.kinesisStreamsInput;
        this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
        this.inputParallelism = builder.inputParallelism;
        this.inputSchema = builder.inputSchema;
    }

    /**
     * <p>
     * The name prefix to use when creating an in-application stream. Suppose that you specify a prefix "
     * <code>MyInApplicationStream</code>." Kinesis Data Analytics then creates one or more (as per the
     * <code>InputParallelism</code> count you specified) in-application streams with the names "
     * <code>MyInApplicationStream_001</code>," "<code>MyInApplicationStream_002</code>," and so on.
     * </p>
     * 
     * @return The name prefix to use when creating an in-application stream. Suppose that you specify a prefix "
     *         <code>MyInApplicationStream</code>." Kinesis Data Analytics then creates one or more (as per the
     *         <code>InputParallelism</code> count you specified) in-application streams with the names "
     *         <code>MyInApplicationStream_001</code>," "<code>MyInApplicationStream_002</code>," and so on.
     */
    public final String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * The <a>InputProcessingConfiguration</a> for the input. An input processor transforms records as they are received
     * from the stream, before the application's SQL code executes. Currently, the only input processing configuration
     * available is <a>InputLambdaProcessor</a>.
     * </p>
     * 
     * @return The <a>InputProcessingConfiguration</a> for the input. An input processor transforms records as they are
     *         received from the stream, before the application's SQL code executes. Currently, the only input
     *         processing configuration available is <a>InputLambdaProcessor</a>.
     */
    public final InputProcessingConfiguration inputProcessingConfiguration() {
        return inputProcessingConfiguration;
    }

    /**
     * <p>
     * If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name
     *         (ARN).
     */
    public final KinesisStreamsInput kinesisStreamsInput() {
        return kinesisStreamsInput;
    }

    /**
     * <p>
     * If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
     * </p>
     * 
     * @return If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery
     *         stream's ARN.
     */
    public final KinesisFirehoseInput kinesisFirehoseInput() {
        return kinesisFirehoseInput;
    }

    /**
     * <p>
     * Describes the number of in-application streams to create.
     * </p>
     * 
     * @return Describes the number of in-application streams to create.
     */
    public final InputParallelism inputParallelism() {
        return inputParallelism;
    }

    /**
     * <p>
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns
     * in the in-application stream that is being created.
     * </p>
     * <p>
     * Also used to describe the format of the reference data source.
     * </p>
     * 
     * @return Describes the format of the data in the streaming source, and how each data element maps to corresponding
     *         columns in the in-application stream that is being created.</p>
     *         <p>
     *         Also used to describe the format of the reference data source.
     */
    public final SourceSchema inputSchema() {
        return inputSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsInput());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseInput());
        hashCode = 31 * hashCode + Objects.hashCode(inputParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input) obj;
        return Objects.equals(namePrefix(), other.namePrefix())
                && Objects.equals(inputProcessingConfiguration(), other.inputProcessingConfiguration())
                && Objects.equals(kinesisStreamsInput(), other.kinesisStreamsInput())
                && Objects.equals(kinesisFirehoseInput(), other.kinesisFirehoseInput())
                && Objects.equals(inputParallelism(), other.inputParallelism())
                && Objects.equals(inputSchema(), other.inputSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Input").add("NamePrefix", namePrefix())
                .add("InputProcessingConfiguration", inputProcessingConfiguration())
                .add("KinesisStreamsInput", kinesisStreamsInput()).add("KinesisFirehoseInput", kinesisFirehoseInput())
                .add("InputParallelism", inputParallelism()).add("InputSchema", inputSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "InputProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(inputProcessingConfiguration()));
        case "KinesisStreamsInput":
            return Optional.ofNullable(clazz.cast(kinesisStreamsInput()));
        case "KinesisFirehoseInput":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseInput()));
        case "InputParallelism":
            return Optional.ofNullable(clazz.cast(inputParallelism()));
        case "InputSchema":
            return Optional.ofNullable(clazz.cast(inputSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Input> {
        /**
         * <p>
         * The name prefix to use when creating an in-application stream. Suppose that you specify a prefix "
         * <code>MyInApplicationStream</code>." Kinesis Data Analytics then creates one or more (as per the
         * <code>InputParallelism</code> count you specified) in-application streams with the names "
         * <code>MyInApplicationStream_001</code>," "<code>MyInApplicationStream_002</code>," and so on.
         * </p>
         * 
         * @param namePrefix
         *        The name prefix to use when creating an in-application stream. Suppose that you specify a prefix "
         *        <code>MyInApplicationStream</code>." Kinesis Data Analytics then creates one or more (as per the
         *        <code>InputParallelism</code> count you specified) in-application streams with the names "
         *        <code>MyInApplicationStream_001</code>," "<code>MyInApplicationStream_002</code>," and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * The <a>InputProcessingConfiguration</a> for the input. An input processor transforms records as they are
         * received from the stream, before the application's SQL code executes. Currently, the only input processing
         * configuration available is <a>InputLambdaProcessor</a>.
         * </p>
         * 
         * @param inputProcessingConfiguration
         *        The <a>InputProcessingConfiguration</a> for the input. An input processor transforms records as they
         *        are received from the stream, before the application's SQL code executes. Currently, the only input
         *        processing configuration available is <a>InputLambdaProcessor</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration);

        /**
         * <p>
         * The <a>InputProcessingConfiguration</a> for the input. An input processor transforms records as they are
         * received from the stream, before the application's SQL code executes. Currently, the only input processing
         * configuration available is <a>InputLambdaProcessor</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link InputProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link InputProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inputProcessingConfiguration(InputProcessingConfiguration)}.
         * 
         * @param inputProcessingConfiguration
         *        a consumer that will call methods on {@link InputProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfiguration(InputProcessingConfiguration)
         */
        default Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return inputProcessingConfiguration(InputProcessingConfiguration.builder()
                    .applyMutation(inputProcessingConfiguration).build());
        }

        /**
         * <p>
         * If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param kinesisStreamsInput
         *        If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name
         *        (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput);

        /**
         * <p>
         * If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsInput.Builder} avoiding the need
         * to create one manually via {@link KinesisStreamsInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsInput.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisStreamsInput(KinesisStreamsInput)}.
         * 
         * @param kinesisStreamsInput
         *        a consumer that will call methods on {@link KinesisStreamsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsInput(KinesisStreamsInput)
         */
        default Builder kinesisStreamsInput(Consumer<KinesisStreamsInput.Builder> kinesisStreamsInput) {
            return kinesisStreamsInput(KinesisStreamsInput.builder().applyMutation(kinesisStreamsInput).build());
        }

        /**
         * <p>
         * If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's
         * ARN.
         * </p>
         * 
         * @param kinesisFirehoseInput
         *        If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery
         *        stream's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput);

        /**
         * <p>
         * If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's
         * ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseInput.Builder} avoiding the need
         * to create one manually via {@link KinesisFirehoseInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseInput.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisFirehoseInput(KinesisFirehoseInput)}.
         * 
         * @param kinesisFirehoseInput
         *        a consumer that will call methods on {@link KinesisFirehoseInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseInput(KinesisFirehoseInput)
         */
        default Builder kinesisFirehoseInput(Consumer<KinesisFirehoseInput.Builder> kinesisFirehoseInput) {
            return kinesisFirehoseInput(KinesisFirehoseInput.builder().applyMutation(kinesisFirehoseInput).build());
        }

        /**
         * <p>
         * Describes the number of in-application streams to create.
         * </p>
         * 
         * @param inputParallelism
         *        Describes the number of in-application streams to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelism(InputParallelism inputParallelism);

        /**
         * <p>
         * Describes the number of in-application streams to create.
         * </p>
         * This is a convenience that creates an instance of the {@link InputParallelism.Builder} avoiding the need to
         * create one manually via {@link InputParallelism#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputParallelism.Builder#build()} is called immediately and its
         * result is passed to {@link #inputParallelism(InputParallelism)}.
         * 
         * @param inputParallelism
         *        a consumer that will call methods on {@link InputParallelism.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputParallelism(InputParallelism)
         */
        default Builder inputParallelism(Consumer<InputParallelism.Builder> inputParallelism) {
            return inputParallelism(InputParallelism.builder().applyMutation(inputParallelism).build());
        }

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns in the in-application stream that is being created.
         * </p>
         * <p>
         * Also used to describe the format of the reference data source.
         * </p>
         * 
         * @param inputSchema
         *        Describes the format of the data in the streaming source, and how each data element maps to
         *        corresponding columns in the in-application stream that is being created.</p>
         *        <p>
         *        Also used to describe the format of the reference data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SourceSchema inputSchema);

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns in the in-application stream that is being created.
         * </p>
         * <p>
         * Also used to describe the format of the reference data source.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchema(SourceSchema)}.
         * 
         * @param inputSchema
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchema(SourceSchema)
         */
        default Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return inputSchema(SourceSchema.builder().applyMutation(inputSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String namePrefix;

        private InputProcessingConfiguration inputProcessingConfiguration;

        private KinesisStreamsInput kinesisStreamsInput;

        private KinesisFirehoseInput kinesisFirehoseInput;

        private InputParallelism inputParallelism;

        private SourceSchema inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            namePrefix(model.namePrefix);
            inputProcessingConfiguration(model.inputProcessingConfiguration);
            kinesisStreamsInput(model.kinesisStreamsInput);
            kinesisFirehoseInput(model.kinesisFirehoseInput);
            inputParallelism(model.inputParallelism);
            inputSchema(model.inputSchema);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        @Transient
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return inputProcessingConfiguration != null ? inputProcessingConfiguration.toBuilder() : null;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final KinesisStreamsInput.Builder getKinesisStreamsInput() {
            return kinesisStreamsInput != null ? kinesisStreamsInput.toBuilder() : null;
        }

        public final void setKinesisStreamsInput(KinesisStreamsInput.BuilderImpl kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput != null ? kinesisStreamsInput.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput;
            return this;
        }

        public final KinesisFirehoseInput.Builder getKinesisFirehoseInput() {
            return kinesisFirehoseInput != null ? kinesisFirehoseInput.toBuilder() : null;
        }

        public final void setKinesisFirehoseInput(KinesisFirehoseInput.BuilderImpl kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput != null ? kinesisFirehoseInput.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput;
            return this;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return inputParallelism != null ? inputParallelism.toBuilder() : null;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        @Override
        @Transient
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final SourceSchema.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @Override
        public Input build() {
            return new Input(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
