/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For an SQL-based Kinesis Data Analytics application's output, describes the Kinesis data stream that is configured as
 * its destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisStreamsOutputDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisStreamsOutputDescription.Builder, KinesisStreamsOutputDescription> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(KinesisStreamsOutputDescription::resourceARN))
            .setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(KinesisStreamsOutputDescription::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceARN;

    private final String roleARN;

    private KinesisStreamsOutputDescription(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Kinesis data stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Kinesis data stream.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * The ARN of the IAM role that Kinesis Data Analytics can assume to access the stream.
     * </p>
     * <note>
     * <p>
     * Provided for backward compatibility. Applications that are created with the current API version have an
     * application-level service execution role rather than a resource-level role.
     * </p>
     * </note>
     * 
     * @return The ARN of the IAM role that Kinesis Data Analytics can assume to access the stream.</p> <note>
     *         <p>
     *         Provided for backward compatibility. Applications that are created with the current API version have an
     *         application-level service execution role rather than a resource-level role.
     *         </p>
     */
    public final String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamsOutputDescription)) {
            return false;
        }
        KinesisStreamsOutputDescription other = (KinesisStreamsOutputDescription) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(roleARN(), other.roleARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisStreamsOutputDescription").add("ResourceARN", resourceARN()).add("RoleARN", roleARN())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamsOutputDescription, T> g) {
        return obj -> g.apply((KinesisStreamsOutputDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisStreamsOutputDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Kinesis data stream.
         * </p>
         * 
         * @param resourceARN
         *        The Amazon Resource Name (ARN) of the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * The ARN of the IAM role that Kinesis Data Analytics can assume to access the stream.
         * </p>
         * <note>
         * <p>
         * Provided for backward compatibility. Applications that are created with the current API version have an
         * application-level service execution role rather than a resource-level role.
         * </p>
         * </note>
         * 
         * @param roleARN
         *        The ARN of the IAM role that Kinesis Data Analytics can assume to access the stream.</p> <note>
         *        <p>
         *        Provided for backward compatibility. Applications that are created with the current API version have
         *        an application-level service execution role rather than a resource-level role.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamsOutputDescription model) {
            resourceARN(model.resourceARN);
            roleARN(model.roleARN);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        @Transient
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        @Transient
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        @Override
        public KinesisStreamsOutputDescription build() {
            return new KinesisStreamsOutputDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
