/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationsResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private static final SdkField<List<ApplicationSummary>> APPLICATION_SUMMARIES_FIELD = SdkField
            .<List<ApplicationSummary>> builder(MarshallingType.LIST)
            .memberName("ApplicationSummaries")
            .getter(getter(ListApplicationsResponse::applicationSummaries))
            .setter(setter(Builder::applicationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ApplicationSummary> applicationSummaries;

    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummaries = builder.applicationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationSummaries() {
        return applicationSummaries != null && !(applicationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ApplicationSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationSummaries} method.
     * </p>
     * 
     * @return A list of <code>ApplicationSummary</code> objects.
     */
    public final List<ApplicationSummary> applicationSummaries() {
        return applicationSummaries;
    }

    /**
     * <p>
     * The pagination token for the next set of results, or <code>null</code> if there are no additional results. Pass
     * this token into a subsequent command to retrieve the next set of items For more information about pagination, see
     * <a href="https://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Using the Amazon Command Line
     * Interface's Pagination Options</a>.
     * </p>
     * 
     * @return The pagination token for the next set of results, or <code>null</code> if there are no additional
     *         results. Pass this token into a subsequent command to retrieve the next set of items For more information
     *         about pagination, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Using
     *         the Amazon Command Line Interface's Pagination Options</a>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationSummaries() ? applicationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        return hasApplicationSummaries() == other.hasApplicationSummaries()
                && Objects.equals(applicationSummaries(), other.applicationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationsResponse")
                .add("ApplicationSummaries", hasApplicationSummaries() ? applicationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationSummaries":
            return Optional.ofNullable(clazz.cast(applicationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsResponse, T> g) {
        return obj -> g.apply((ListApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * <p>
         * A list of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        A list of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries);

        /**
         * <p>
         * A list of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        A list of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(ApplicationSummary... applicationSummaries);

        /**
         * <p>
         * A list of <code>ApplicationSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ApplicationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSummaries(List<ApplicationSummary>)}.
         * 
         * @param applicationSummaries
         *        a consumer that will call methods on {@link List<ApplicationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSummaries(List<ApplicationSummary>)
         */
        Builder applicationSummaries(Consumer<ApplicationSummary.Builder>... applicationSummaries);

        /**
         * <p>
         * The pagination token for the next set of results, or <code>null</code> if there are no additional results.
         * Pass this token into a subsequent command to retrieve the next set of items For more information about
         * pagination, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Using the Amazon
         * Command Line Interface's Pagination Options</a>.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next set of results, or <code>null</code> if there are no additional
         *        results. Pass this token into a subsequent command to retrieve the next set of items For more
         *        information about pagination, see <a
         *        href="https://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Using the Amazon Command Line
         *        Interface's Pagination Options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private List<ApplicationSummary> applicationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            applicationSummaries(model.applicationSummaries);
            nextToken(model.nextToken);
        }

        public final List<ApplicationSummary.Builder> getApplicationSummaries() {
            List<ApplicationSummary.Builder> result = ApplicationSummariesCopier.copyToBuilder(this.applicationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary.BuilderImpl> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copyFromBuilder(applicationSummaries);
        }

        @Override
        @Transient
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary... applicationSummaries) {
            applicationSummaries(Arrays.asList(applicationSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationSummaries(Consumer<ApplicationSummary.Builder>... applicationSummaries) {
            applicationSummaries(Stream.of(applicationSummaries).map(c -> ApplicationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
