/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartApplicationRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<StartApplicationRequest.Builder, StartApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(StartApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<RunConfiguration> RUN_CONFIGURATION_FIELD = SdkField
            .<RunConfiguration> builder(MarshallingType.SDK_POJO).memberName("RunConfiguration")
            .getter(getter(StartApplicationRequest::runConfiguration)).setter(setter(Builder::runConfiguration))
            .constructor(RunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            RUN_CONFIGURATION_FIELD));

    private final String applicationName;

    private final RunConfiguration runConfiguration;

    private StartApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.runConfiguration = builder.runConfiguration;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Identifies the run configuration (start parameters) of a Kinesis Data Analytics application.
     * </p>
     * 
     * @return Identifies the run configuration (start parameters) of a Kinesis Data Analytics application.
     */
    public final RunConfiguration runConfiguration() {
        return runConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(runConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(runConfiguration(), other.runConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartApplicationRequest").add("ApplicationName", applicationName())
                .add("RunConfiguration", runConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "RunConfiguration":
            return Optional.ofNullable(clazz.cast(runConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartApplicationRequest, T> g) {
        return obj -> g.apply((StartApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, StartApplicationRequest> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Identifies the run configuration (start parameters) of a Kinesis Data Analytics application.
         * </p>
         * 
         * @param runConfiguration
         *        Identifies the run configuration (start parameters) of a Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfiguration(RunConfiguration runConfiguration);

        /**
         * <p>
         * Identifies the run configuration (start parameters) of a Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link RunConfiguration.Builder} avoiding the need to
         * create one manually via {@link RunConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #runConfiguration(RunConfiguration)}.
         * 
         * @param runConfiguration
         *        a consumer that will call methods on {@link RunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfiguration(RunConfiguration)
         */
        default Builder runConfiguration(Consumer<RunConfiguration.Builder> runConfiguration) {
            return runConfiguration(RunConfiguration.builder().applyMutation(runConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private RunConfiguration runConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            runConfiguration(model.runConfiguration);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final RunConfiguration.Builder getRunConfiguration() {
            return runConfiguration != null ? runConfiguration.toBuilder() : null;
        }

        public final void setRunConfiguration(RunConfiguration.BuilderImpl runConfiguration) {
            this.runConfiguration = runConfiguration != null ? runConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder runConfiguration(RunConfiguration runConfiguration) {
            this.runConfiguration = runConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
