/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopApplicationRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<StopApplicationRequest.Builder, StopApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(StopApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Force")
            .getter(getter(StopApplicationRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            FORCE_FIELD));

    private final String applicationName;

    private final Boolean force;

    private StopApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.force = builder.force;
    }

    /**
     * <p>
     * The name of the running application to stop.
     * </p>
     * 
     * @return The name of the running application to stop.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Set to <code>true</code> to force the application to stop. If you set <code>Force</code> to <code>true</code>,
     * Kinesis Data Analytics stops the application without taking a snapshot.
     * </p>
     * <note>
     * <p>
     * Force-stopping your application may lead to data loss or duplication. To prevent data loss or duplicate
     * processing of data during application restarts, we recommend you to take frequent snapshots of your application.
     * </p>
     * </note>
     * <p>
     * You can only force stop a Flink-based Kinesis Data Analytics application. You can't force stop a SQL-based
     * Kinesis Data Analytics application.
     * </p>
     * <p>
     * The application must be in the <code>STARTING</code>, <code>UPDATING</code>, <code>STOPPING</code>,
     * <code>AUTOSCALING</code>, or <code>RUNNING</code> status.
     * </p>
     * 
     * @return Set to <code>true</code> to force the application to stop. If you set <code>Force</code> to
     *         <code>true</code>, Kinesis Data Analytics stops the application without taking a snapshot. </p> <note>
     *         <p>
     *         Force-stopping your application may lead to data loss or duplication. To prevent data loss or duplicate
     *         processing of data during application restarts, we recommend you to take frequent snapshots of your
     *         application.
     *         </p>
     *         </note>
     *         <p>
     *         You can only force stop a Flink-based Kinesis Data Analytics application. You can't force stop a
     *         SQL-based Kinesis Data Analytics application.
     *         </p>
     *         <p>
     *         The application must be in the <code>STARTING</code>, <code>UPDATING</code>, <code>STOPPING</code>,
     *         <code>AUTOSCALING</code>, or <code>RUNNING</code> status.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopApplicationRequest)) {
            return false;
        }
        StopApplicationRequest other = (StopApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopApplicationRequest").add("ApplicationName", applicationName()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopApplicationRequest, T> g) {
        return obj -> g.apply((StopApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, StopApplicationRequest> {
        /**
         * <p>
         * The name of the running application to stop.
         * </p>
         * 
         * @param applicationName
         *        The name of the running application to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Set to <code>true</code> to force the application to stop. If you set <code>Force</code> to <code>true</code>
         * , Kinesis Data Analytics stops the application without taking a snapshot.
         * </p>
         * <note>
         * <p>
         * Force-stopping your application may lead to data loss or duplication. To prevent data loss or duplicate
         * processing of data during application restarts, we recommend you to take frequent snapshots of your
         * application.
         * </p>
         * </note>
         * <p>
         * You can only force stop a Flink-based Kinesis Data Analytics application. You can't force stop a SQL-based
         * Kinesis Data Analytics application.
         * </p>
         * <p>
         * The application must be in the <code>STARTING</code>, <code>UPDATING</code>, <code>STOPPING</code>,
         * <code>AUTOSCALING</code>, or <code>RUNNING</code> status.
         * </p>
         * 
         * @param force
         *        Set to <code>true</code> to force the application to stop. If you set <code>Force</code> to
         *        <code>true</code>, Kinesis Data Analytics stops the application without taking a snapshot. </p> <note>
         *        <p>
         *        Force-stopping your application may lead to data loss or duplication. To prevent data loss or
         *        duplicate processing of data during application restarts, we recommend you to take frequent snapshots
         *        of your application.
         *        </p>
         *        </note>
         *        <p>
         *        You can only force stop a Flink-based Kinesis Data Analytics application. You can't force stop a
         *        SQL-based Kinesis Data Analytics application.
         *        </p>
         *        <p>
         *        The application must be in the <code>STARTING</code>, <code>UPDATING</code>, <code>STOPPING</code>,
         *        <code>AUTOSCALING</code>, or <code>RUNNING</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(StopApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            force(model.force);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        @Transient
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopApplicationRequest build() {
            return new StopApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
