/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationMaintenanceConfigurationRequest extends KinesisAnalyticsV2Request
        implements
        ToCopyableBuilder<UpdateApplicationMaintenanceConfigurationRequest.Builder, UpdateApplicationMaintenanceConfigurationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(UpdateApplicationMaintenanceConfigurationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<ApplicationMaintenanceConfigurationUpdate> APPLICATION_MAINTENANCE_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationMaintenanceConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationMaintenanceConfigurationUpdate")
            .getter(getter(UpdateApplicationMaintenanceConfigurationRequest::applicationMaintenanceConfigurationUpdate))
            .setter(setter(Builder::applicationMaintenanceConfigurationUpdate))
            .constructor(ApplicationMaintenanceConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationMaintenanceConfigurationUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            APPLICATION_MAINTENANCE_CONFIGURATION_UPDATE_FIELD));

    private final String applicationName;

    private final ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate;

    private UpdateApplicationMaintenanceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationMaintenanceConfigurationUpdate = builder.applicationMaintenanceConfigurationUpdate;
    }

    /**
     * <p>
     * The name of the application for which you want to update the maintenance configuration.
     * </p>
     * 
     * @return The name of the application for which you want to update the maintenance configuration.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Describes the application maintenance configuration update.
     * </p>
     * 
     * @return Describes the application maintenance configuration update.
     */
    public final ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate() {
        return applicationMaintenanceConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationMaintenanceConfigurationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationMaintenanceConfigurationRequest)) {
            return false;
        }
        UpdateApplicationMaintenanceConfigurationRequest other = (UpdateApplicationMaintenanceConfigurationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationMaintenanceConfigurationUpdate(), other.applicationMaintenanceConfigurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationMaintenanceConfigurationRequest").add("ApplicationName", applicationName())
                .add("ApplicationMaintenanceConfigurationUpdate", applicationMaintenanceConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ApplicationMaintenanceConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationMaintenanceConfigurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationMaintenanceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationMaintenanceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationMaintenanceConfigurationRequest> {
        /**
         * <p>
         * The name of the application for which you want to update the maintenance configuration.
         * </p>
         * 
         * @param applicationName
         *        The name of the application for which you want to update the maintenance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Describes the application maintenance configuration update.
         * </p>
         * 
         * @param applicationMaintenanceConfigurationUpdate
         *        Describes the application maintenance configuration update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMaintenanceConfigurationUpdate(
                ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate);

        /**
         * <p>
         * Describes the application maintenance configuration update.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link ApplicationMaintenanceConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ApplicationMaintenanceConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationMaintenanceConfigurationUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #applicationMaintenanceConfigurationUpdate(ApplicationMaintenanceConfigurationUpdate)}.
         * 
         * @param applicationMaintenanceConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationMaintenanceConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationMaintenanceConfigurationUpdate(ApplicationMaintenanceConfigurationUpdate)
         */
        default Builder applicationMaintenanceConfigurationUpdate(
                Consumer<ApplicationMaintenanceConfigurationUpdate.Builder> applicationMaintenanceConfigurationUpdate) {
            return applicationMaintenanceConfigurationUpdate(ApplicationMaintenanceConfigurationUpdate.builder()
                    .applyMutation(applicationMaintenanceConfigurationUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationMaintenanceConfigurationRequest model) {
            super(model);
            applicationName(model.applicationName);
            applicationMaintenanceConfigurationUpdate(model.applicationMaintenanceConfigurationUpdate);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final ApplicationMaintenanceConfigurationUpdate.Builder getApplicationMaintenanceConfigurationUpdate() {
            return applicationMaintenanceConfigurationUpdate != null ? applicationMaintenanceConfigurationUpdate.toBuilder()
                    : null;
        }

        public final void setApplicationMaintenanceConfigurationUpdate(
                ApplicationMaintenanceConfigurationUpdate.BuilderImpl applicationMaintenanceConfigurationUpdate) {
            this.applicationMaintenanceConfigurationUpdate = applicationMaintenanceConfigurationUpdate != null ? applicationMaintenanceConfigurationUpdate
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder applicationMaintenanceConfigurationUpdate(
                ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate) {
            this.applicationMaintenanceConfigurationUpdate = applicationMaintenanceConfigurationUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationMaintenanceConfigurationRequest build() {
            return new UpdateApplicationMaintenanceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
