/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to the VPC configuration used by the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigurationUpdate.Builder, VpcConfigurationUpdate> {
    private static final SdkField<String> VPC_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConfigurationId").getter(getter(VpcConfigurationUpdate::vpcConfigurationId))
            .setter(setter(Builder::vpcConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationId").build())
            .build();

    private static final SdkField<List<String>> SUBNET_ID_UPDATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIdUpdates")
            .getter(getter(VpcConfigurationUpdate::subnetIdUpdates))
            .setter(setter(Builder::subnetIdUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ID_UPDATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIdUpdates")
            .getter(getter(VpcConfigurationUpdate::securityGroupIdUpdates))
            .setter(setter(Builder::securityGroupIdUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONFIGURATION_ID_FIELD,
            SUBNET_ID_UPDATES_FIELD, SECURITY_GROUP_ID_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcConfigurationId;

    private final List<String> subnetIdUpdates;

    private final List<String> securityGroupIdUpdates;

    private VpcConfigurationUpdate(BuilderImpl builder) {
        this.vpcConfigurationId = builder.vpcConfigurationId;
        this.subnetIdUpdates = builder.subnetIdUpdates;
        this.securityGroupIdUpdates = builder.securityGroupIdUpdates;
    }

    /**
     * <p>
     * Describes an update to the ID of the VPC configuration.
     * </p>
     * 
     * @return Describes an update to the ID of the VPC configuration.
     */
    public final String vpcConfigurationId() {
        return vpcConfigurationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIdUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetIdUpdates() {
        return subnetIdUpdates != null && !(subnetIdUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes updates to the array of <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html">Subnet</a> IDs used by the VPC
     * configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIdUpdates} method.
     * </p>
     * 
     * @return Describes updates to the array of <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html">Subnet</a> IDs used by the
     *         VPC configuration.
     */
    public final List<String> subnetIdUpdates() {
        return subnetIdUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIdUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityGroupIdUpdates() {
        return securityGroupIdUpdates != null && !(securityGroupIdUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes updates to the array of <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html">SecurityGroup</a> IDs used
     * by the VPC configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIdUpdates} method.
     * </p>
     * 
     * @return Describes updates to the array of <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html">SecurityGroup</a>
     *         IDs used by the VPC configuration.
     */
    public final List<String> securityGroupIdUpdates() {
        return securityGroupIdUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIdUpdates() ? subnetIdUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIdUpdates() ? securityGroupIdUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigurationUpdate)) {
            return false;
        }
        VpcConfigurationUpdate other = (VpcConfigurationUpdate) obj;
        return Objects.equals(vpcConfigurationId(), other.vpcConfigurationId())
                && hasSubnetIdUpdates() == other.hasSubnetIdUpdates()
                && Objects.equals(subnetIdUpdates(), other.subnetIdUpdates())
                && hasSecurityGroupIdUpdates() == other.hasSecurityGroupIdUpdates()
                && Objects.equals(securityGroupIdUpdates(), other.securityGroupIdUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfigurationUpdate").add("VpcConfigurationId", vpcConfigurationId())
                .add("SubnetIdUpdates", hasSubnetIdUpdates() ? subnetIdUpdates() : null)
                .add("SecurityGroupIdUpdates", hasSecurityGroupIdUpdates() ? securityGroupIdUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConfigurationId":
            return Optional.ofNullable(clazz.cast(vpcConfigurationId()));
        case "SubnetIdUpdates":
            return Optional.ofNullable(clazz.cast(subnetIdUpdates()));
        case "SecurityGroupIdUpdates":
            return Optional.ofNullable(clazz.cast(securityGroupIdUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigurationUpdate, T> g) {
        return obj -> g.apply((VpcConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigurationUpdate> {
        /**
         * <p>
         * Describes an update to the ID of the VPC configuration.
         * </p>
         * 
         * @param vpcConfigurationId
         *        Describes an update to the ID of the VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationId(String vpcConfigurationId);

        /**
         * <p>
         * Describes updates to the array of <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html">Subnet</a> IDs used by the VPC
         * configuration.
         * </p>
         * 
         * @param subnetIdUpdates
         *        Describes updates to the array of <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html">Subnet</a> IDs used by
         *        the VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdUpdates(Collection<String> subnetIdUpdates);

        /**
         * <p>
         * Describes updates to the array of <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html">Subnet</a> IDs used by the VPC
         * configuration.
         * </p>
         * 
         * @param subnetIdUpdates
         *        Describes updates to the array of <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html">Subnet</a> IDs used by
         *        the VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdUpdates(String... subnetIdUpdates);

        /**
         * <p>
         * Describes updates to the array of <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html">SecurityGroup</a> IDs
         * used by the VPC configuration.
         * </p>
         * 
         * @param securityGroupIdUpdates
         *        Describes updates to the array of <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html">SecurityGroup</a>
         *        IDs used by the VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdUpdates(Collection<String> securityGroupIdUpdates);

        /**
         * <p>
         * Describes updates to the array of <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html">SecurityGroup</a> IDs
         * used by the VPC configuration.
         * </p>
         * 
         * @param securityGroupIdUpdates
         *        Describes updates to the array of <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html">SecurityGroup</a>
         *        IDs used by the VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdUpdates(String... securityGroupIdUpdates);
    }

    static final class BuilderImpl implements Builder {
        private String vpcConfigurationId;

        private List<String> subnetIdUpdates = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIdUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigurationUpdate model) {
            vpcConfigurationId(model.vpcConfigurationId);
            subnetIdUpdates(model.subnetIdUpdates);
            securityGroupIdUpdates(model.securityGroupIdUpdates);
        }

        public final String getVpcConfigurationId() {
            return vpcConfigurationId;
        }

        public final void setVpcConfigurationId(String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
        }

        @Override
        @Transient
        public final Builder vpcConfigurationId(String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
            return this;
        }

        public final Collection<String> getSubnetIdUpdates() {
            if (subnetIdUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIdUpdates;
        }

        public final void setSubnetIdUpdates(Collection<String> subnetIdUpdates) {
            this.subnetIdUpdates = SubnetIdsCopier.copy(subnetIdUpdates);
        }

        @Override
        @Transient
        public final Builder subnetIdUpdates(Collection<String> subnetIdUpdates) {
            this.subnetIdUpdates = SubnetIdsCopier.copy(subnetIdUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetIdUpdates(String... subnetIdUpdates) {
            subnetIdUpdates(Arrays.asList(subnetIdUpdates));
            return this;
        }

        public final Collection<String> getSecurityGroupIdUpdates() {
            if (securityGroupIdUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIdUpdates;
        }

        public final void setSecurityGroupIdUpdates(Collection<String> securityGroupIdUpdates) {
            this.securityGroupIdUpdates = SecurityGroupIdsCopier.copy(securityGroupIdUpdates);
        }

        @Override
        @Transient
        public final Builder securityGroupIdUpdates(Collection<String> securityGroupIdUpdates) {
            this.securityGroupIdUpdates = SecurityGroupIdsCopier.copy(securityGroupIdUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIdUpdates(String... securityGroupIdUpdates) {
            securityGroupIdUpdates(Arrays.asList(securityGroupIdUpdates));
            return this;
        }

        @Override
        public VpcConfigurationUpdate build() {
            return new VpcConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
