/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SourceSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceDataSourceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceDataSourceUpdate> {
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferenceId").getter(ReferenceDataSourceUpdate.getter(ReferenceDataSourceUpdate::referenceId)).setter(ReferenceDataSourceUpdate.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<String> TABLE_NAME_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableNameUpdate").getter(ReferenceDataSourceUpdate.getter(ReferenceDataSourceUpdate::tableNameUpdate)).setter(ReferenceDataSourceUpdate.setter(Builder::tableNameUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableNameUpdate").build()}).build();
    private static final SdkField<S3ReferenceDataSourceUpdate> S3_REFERENCE_DATA_SOURCE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ReferenceDataSourceUpdate").getter(ReferenceDataSourceUpdate.getter(ReferenceDataSourceUpdate::s3ReferenceDataSourceUpdate)).setter(ReferenceDataSourceUpdate.setter(Builder::s3ReferenceDataSourceUpdate)).constructor(S3ReferenceDataSourceUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReferenceDataSourceUpdate").build()}).build();
    private static final SdkField<SourceSchema> REFERENCE_SCHEMA_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReferenceSchemaUpdate").getter(ReferenceDataSourceUpdate.getter(ReferenceDataSourceUpdate::referenceSchemaUpdate)).setter(ReferenceDataSourceUpdate.setter(Builder::referenceSchemaUpdate)).constructor(SourceSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSchemaUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD, TABLE_NAME_UPDATE_FIELD, S3_REFERENCE_DATA_SOURCE_UPDATE_FIELD, REFERENCE_SCHEMA_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String referenceId;
    private final String tableNameUpdate;
    private final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;
    private final SourceSchema referenceSchemaUpdate;

    private ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableNameUpdate = builder.tableNameUpdate;
        this.s3ReferenceDataSourceUpdate = builder.s3ReferenceDataSourceUpdate;
        this.referenceSchemaUpdate = builder.referenceSchemaUpdate;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final String tableNameUpdate() {
        return this.tableNameUpdate;
    }

    public final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate() {
        return this.s3ReferenceDataSourceUpdate;
    }

    public final SourceSchema referenceSchemaUpdate() {
        return this.referenceSchemaUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableNameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReferenceDataSourceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceSchemaUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceUpdate)) {
            return false;
        }
        ReferenceDataSourceUpdate other = (ReferenceDataSourceUpdate)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.tableNameUpdate(), other.tableNameUpdate()) && Objects.equals(this.s3ReferenceDataSourceUpdate(), other.s3ReferenceDataSourceUpdate()) && Objects.equals(this.referenceSchemaUpdate(), other.referenceSchemaUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceDataSourceUpdate").add("ReferenceId", (Object)this.referenceId()).add("TableNameUpdate", (Object)this.tableNameUpdate()).add("S3ReferenceDataSourceUpdate", (Object)this.s3ReferenceDataSourceUpdate()).add("ReferenceSchemaUpdate", (Object)this.referenceSchemaUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "TableNameUpdate": {
                return Optional.ofNullable(clazz.cast(this.tableNameUpdate()));
            }
            case "S3ReferenceDataSourceUpdate": {
                return Optional.ofNullable(clazz.cast(this.s3ReferenceDataSourceUpdate()));
            }
            case "ReferenceSchemaUpdate": {
                return Optional.ofNullable(clazz.cast(this.referenceSchemaUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceDataSourceUpdate, T> g) {
        return obj -> g.apply((ReferenceDataSourceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String referenceId;
        private String tableNameUpdate;
        private S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;
        private SourceSchema referenceSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceUpdate model) {
            this.referenceId(model.referenceId);
            this.tableNameUpdate(model.tableNameUpdate);
            this.s3ReferenceDataSourceUpdate(model.s3ReferenceDataSourceUpdate);
            this.referenceSchemaUpdate(model.referenceSchemaUpdate);
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getTableNameUpdate() {
            return this.tableNameUpdate;
        }

        public final void setTableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
        }

        @Override
        public final Builder tableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
            return this;
        }

        public final S3ReferenceDataSourceUpdate.Builder getS3ReferenceDataSourceUpdate() {
            return this.s3ReferenceDataSourceUpdate != null ? this.s3ReferenceDataSourceUpdate.toBuilder() : null;
        }

        public final void setS3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate.BuilderImpl s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate != null ? s3ReferenceDataSourceUpdate.build() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
            return this;
        }

        public final SourceSchema.Builder getReferenceSchemaUpdate() {
            return this.referenceSchemaUpdate != null ? this.referenceSchemaUpdate.toBuilder() : null;
        }

        public final void setReferenceSchemaUpdate(SourceSchema.BuilderImpl referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate != null ? referenceSchemaUpdate.build() : null;
        }

        @Override
        public final Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
            return this;
        }

        public ReferenceDataSourceUpdate build() {
            return new ReferenceDataSourceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceDataSourceUpdate> {
        public Builder referenceId(String var1);

        public Builder tableNameUpdate(String var1);

        public Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate var1);

        default public Builder s3ReferenceDataSourceUpdate(Consumer<S3ReferenceDataSourceUpdate.Builder> s3ReferenceDataSourceUpdate) {
            return this.s3ReferenceDataSourceUpdate((S3ReferenceDataSourceUpdate)((S3ReferenceDataSourceUpdate.Builder)S3ReferenceDataSourceUpdate.builder().applyMutation(s3ReferenceDataSourceUpdate)).build());
        }

        public Builder referenceSchemaUpdate(SourceSchema var1);

        default public Builder referenceSchemaUpdate(Consumer<SourceSchema.Builder> referenceSchemaUpdate) {
            return this.referenceSchemaUpdate((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(referenceSchemaUpdate)).build());
        }
    }
}

