/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse;

/**
 * Service client for accessing Kinesis Analytics V2 asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Kinesis Data Analytics is a fully managed service that you can use to process and analyze streaming data using
 * Java, SQL, or Scala. The service enables you to quickly author and run Java, SQL, or Scala code against streaming
 * sources to perform time series analytics, feed real-time dashboards, and create real-time metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KinesisAnalyticsV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "kinesisanalytics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kinesisanalytics";

    /**
     * <p>
     * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
     * </p>
     *
     * @param addApplicationCloudWatchLoggingOptionRequest
     * @return A Java Future containing the result of the AddApplicationCloudWatchLoggingOption operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationCloudWatchLoggingOptionResponse> addApplicationCloudWatchLoggingOption(
            AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AddApplicationCloudWatchLoggingOptionRequest.Builder} avoiding the need to create one manually via
     * {@link AddApplicationCloudWatchLoggingOptionRequest#builder()}
     * </p>
     *
     * @param addApplicationCloudWatchLoggingOptionRequest
     *        A {@link Consumer} that will call methods on {@link AddApplicationCloudWatchLoggingOptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AddApplicationCloudWatchLoggingOption operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationCloudWatchLoggingOptionResponse> addApplicationCloudWatchLoggingOption(
            Consumer<AddApplicationCloudWatchLoggingOptionRequest.Builder> addApplicationCloudWatchLoggingOptionRequest) {
        return addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest.builder()
                .applyMutation(addApplicationCloudWatchLoggingOptionRequest).build());
    }

    /**
     * <p>
     * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * You can add a streaming source when you create an application, or you can use this operation to add a streaming
     * source after you create an application. For more information, see <a>CreateApplication</a>.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     *
     * @param addApplicationInputRequest
     * @return A Java Future containing the result of the AddApplicationInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>CodeValidationException The user-provided application code (query) is not valid. This can be a simple
     *         syntax error.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationInputResponse> addApplicationInput(
            AddApplicationInputRequest addApplicationInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * You can add a streaming source when you create an application, or you can use this operation to add a streaming
     * source after you create an application. For more information, see <a>CreateApplication</a>.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationInputRequest.Builder} avoiding the
     * need to create one manually via {@link AddApplicationInputRequest#builder()}
     * </p>
     *
     * @param addApplicationInputRequest
     *        A {@link Consumer} that will call methods on {@link AddApplicationInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddApplicationInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>CodeValidationException The user-provided application code (query) is not valid. This can be a simple
     *         syntax error.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationInputResponse> addApplicationInput(
            Consumer<AddApplicationInputRequest.Builder> addApplicationInputRequest) {
        return addApplicationInput(AddApplicationInputRequest.builder().applyMutation(addApplicationInputRequest).build());
    }

    /**
     * <p>
     * Adds an <a>InputProcessingConfiguration</a> to a SQL-based Kinesis Data Analytics application. An input processor
     * pre-processes records on the input stream before the application's SQL code executes. Currently, the only input
     * processor available is <a href="https://docs.aws.amazon.com/lambda/">Amazon Lambda</a>.
     * </p>
     *
     * @param addApplicationInputProcessingConfigurationRequest
     * @return A Java Future containing the result of the AddApplicationInputProcessingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationInputProcessingConfigurationResponse> addApplicationInputProcessingConfiguration(
            AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an <a>InputProcessingConfiguration</a> to a SQL-based Kinesis Data Analytics application. An input processor
     * pre-processes records on the input stream before the application's SQL code executes. Currently, the only input
     * processor available is <a href="https://docs.aws.amazon.com/lambda/">Amazon Lambda</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AddApplicationInputProcessingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link AddApplicationInputProcessingConfigurationRequest#builder()}
     * </p>
     *
     * @param addApplicationInputProcessingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AddApplicationInputProcessingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddApplicationInputProcessingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationInputProcessingConfigurationResponse> addApplicationInputProcessingConfiguration(
            Consumer<AddApplicationInputProcessingConfigurationRequest.Builder> addApplicationInputProcessingConfigurationRequest) {
        return addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest.builder()
                .applyMutation(addApplicationInputProcessingConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds an external destination to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an
     * external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon
     * Lambda function), you add the relevant configuration to your application using this operation. You can configure
     * one or more outputs for your application. Each output configuration maps an in-application stream and an external
     * destination.
     * </p>
     * <p>
     * You can use one of the output configurations to deliver data from your in-application error stream to an external
     * destination so that you can analyze the errors.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     *
     * @param addApplicationOutputRequest
     * @return A Java Future containing the result of the AddApplicationOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationOutputResponse> addApplicationOutput(
            AddApplicationOutputRequest addApplicationOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an external destination to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an
     * external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon
     * Lambda function), you add the relevant configuration to your application using this operation. You can configure
     * one or more outputs for your application. Each output configuration maps an in-application stream and an external
     * destination.
     * </p>
     * <p>
     * You can use one of the output configurations to deliver data from your in-application error stream to an external
     * destination so that you can analyze the errors.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationOutputRequest.Builder} avoiding the
     * need to create one manually via {@link AddApplicationOutputRequest#builder()}
     * </p>
     *
     * @param addApplicationOutputRequest
     *        A {@link Consumer} that will call methods on {@link AddApplicationOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddApplicationOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationOutputResponse> addApplicationOutput(
            Consumer<AddApplicationOutputRequest.Builder> addApplicationOutputRequest) {
        return addApplicationOutput(AddApplicationOutputRequest.builder().applyMutation(addApplicationOutputRequest).build());
    }

    /**
     * <p>
     * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table
     * within your application. In the request, you provide the source (S3 bucket name and object key name), name of the
     * in-application table to create, and the necessary mapping information that describes how data in an Amazon S3
     * object maps to columns in the resulting in-application table.
     * </p>
     *
     * @param addApplicationReferenceDataSourceRequest
     * @return A Java Future containing the result of the AddApplicationReferenceDataSource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationReferenceDataSourceResponse> addApplicationReferenceDataSource(
            AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table
     * within your application. In the request, you provide the source (S3 bucket name and object key name), name of the
     * in-application table to create, and the necessary mapping information that describes how data in an Amazon S3
     * object maps to columns in the resulting in-application table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationReferenceDataSourceRequest.Builder}
     * avoiding the need to create one manually via {@link AddApplicationReferenceDataSourceRequest#builder()}
     * </p>
     *
     * @param addApplicationReferenceDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link AddApplicationReferenceDataSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddApplicationReferenceDataSource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationReferenceDataSourceResponse> addApplicationReferenceDataSource(
            Consumer<AddApplicationReferenceDataSourceRequest.Builder> addApplicationReferenceDataSourceRequest) {
        return addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest.builder()
                .applyMutation(addApplicationReferenceDataSourceRequest).build());
    }

    /**
     * <p>
     * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and
     * access resources securely.
     * </p>
     * <p>
     * Note the following about VPC configurations for Kinesis Data Analytics applications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VPC configurations are not supported for SQL applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * When a VPC is added to a Kinesis Data Analytics application, the application can no longer be accessed from the
     * Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param addApplicationVpcConfigurationRequest
     * @return A Java Future containing the result of the AddApplicationVpcConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationVpcConfigurationResponse> addApplicationVpcConfiguration(
            AddApplicationVpcConfigurationRequest addApplicationVpcConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and
     * access resources securely.
     * </p>
     * <p>
     * Note the following about VPC configurations for Kinesis Data Analytics applications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VPC configurations are not supported for SQL applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * When a VPC is added to a Kinesis Data Analytics application, the application can no longer be accessed from the
     * Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationVpcConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link AddApplicationVpcConfigurationRequest#builder()}
     * </p>
     *
     * @param addApplicationVpcConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link AddApplicationVpcConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddApplicationVpcConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.AddApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddApplicationVpcConfigurationResponse> addApplicationVpcConfiguration(
            Consumer<AddApplicationVpcConfigurationRequest.Builder> addApplicationVpcConfigurationRequest) {
        return addApplicationVpcConfiguration(AddApplicationVpcConfigurationRequest.builder()
                .applyMutation(addApplicationVpcConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics
     * application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html">Creating
     * an Application</a>.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CodeValidationException The user-provided application code (query) is not valid. This can be a simple
     *         syntax error.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>LimitExceededException The number of allowed resources has been exceeded.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>TooManyTagsException Application created with too many tags, or too many tags added to an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics
     * application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html">Creating
     * an Application</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CodeValidationException The user-provided application code (query) is not valid. This can be a simple
     *         syntax error.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>LimitExceededException The number of allowed resources has been exceeded.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>TooManyTagsException Application created with too many tags, or too many tags added to an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates and returns a URL that you can use to connect to an application's extension.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned
     * URL is created, no additional permission is required to access this URL. IAM authorization policies for this API
     * are also enforced for every HTTP request that attempts to connect to the extension.
     * </p>
     * <p>
     * You control the amount of time that the URL will be valid using the
     * <code>SessionExpirationDurationInSeconds</code> parameter. If you do not provide this parameter, the returned URL
     * is valid for twelve hours.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If
     * you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
     * </p>
     * </note>
     *
     * @param createApplicationPresignedUrlRequest
     * @return A Java Future containing the result of the CreateApplicationPresignedUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.CreateApplicationPresignedUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationPresignedUrlResponse> createApplicationPresignedUrl(
            CreateApplicationPresignedUrlRequest createApplicationPresignedUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and returns a URL that you can use to connect to an application's extension.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned
     * URL is created, no additional permission is required to access this URL. IAM authorization policies for this API
     * are also enforced for every HTTP request that attempts to connect to the extension.
     * </p>
     * <p>
     * You control the amount of time that the URL will be valid using the
     * <code>SessionExpirationDurationInSeconds</code> parameter. If you do not provide this parameter, the returned URL
     * is valid for twelve hours.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If
     * you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationPresignedUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreateApplicationPresignedUrlRequest#builder()}
     * </p>
     *
     * @param createApplicationPresignedUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationPresignedUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateApplicationPresignedUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.CreateApplicationPresignedUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationPresignedUrlResponse> createApplicationPresignedUrl(
            Consumer<CreateApplicationPresignedUrlRequest.Builder> createApplicationPresignedUrlRequest) {
        return createApplicationPresignedUrl(CreateApplicationPresignedUrlRequest.builder()
                .applyMutation(createApplicationPresignedUrlRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of the application's state data.
     * </p>
     *
     * @param createApplicationSnapshotRequest
     * @return A Java Future containing the result of the CreateApplicationSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>LimitExceededException The number of allowed resources has been exceeded.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.CreateApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationSnapshotResponse> createApplicationSnapshot(
            CreateApplicationSnapshotRequest createApplicationSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the application's state data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationSnapshotRequest#builder()}
     * </p>
     *
     * @param createApplicationSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplicationSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>LimitExceededException The number of allowed resources has been exceeded.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.CreateApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationSnapshotResponse> createApplicationSnapshot(
            Consumer<CreateApplicationSnapshotRequest.Builder> createApplicationSnapshotRequest) {
        return createApplicationSnapshot(CreateApplicationSnapshotRequest.builder()
                .applyMutation(createApplicationSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified application. Kinesis Data Analytics halts application execution and deletes the
     * application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application. Kinesis Data Analytics halts application execution and deletes the
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.
     * </p>
     *
     * @param deleteApplicationCloudWatchLoggingOptionRequest
     * @return A Java Future containing the result of the DeleteApplicationCloudWatchLoggingOption operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationCloudWatchLoggingOptionResponse> deleteApplicationCloudWatchLoggingOption(
            DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationCloudWatchLoggingOptionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationCloudWatchLoggingOptionRequest#builder()}
     * </p>
     *
     * @param deleteApplicationCloudWatchLoggingOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteApplicationCloudWatchLoggingOptionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApplicationCloudWatchLoggingOption operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationCloudWatchLoggingOptionResponse> deleteApplicationCloudWatchLoggingOption(
            Consumer<DeleteApplicationCloudWatchLoggingOptionRequest.Builder> deleteApplicationCloudWatchLoggingOptionRequest) {
        return deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest.builder()
                .applyMutation(deleteApplicationCloudWatchLoggingOptionRequest).build());
    }

    /**
     * <p>
     * Deletes an <a>InputProcessingConfiguration</a> from an input.
     * </p>
     *
     * @param deleteApplicationInputProcessingConfigurationRequest
     * @return A Java Future containing the result of the DeleteApplicationInputProcessingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationInputProcessingConfigurationResponse> deleteApplicationInputProcessingConfiguration(
            DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <a>InputProcessingConfiguration</a> from an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationInputProcessingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationInputProcessingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationInputProcessingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteApplicationInputProcessingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApplicationInputProcessingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationInputProcessingConfigurationResponse> deleteApplicationInputProcessingConfiguration(
            Consumer<DeleteApplicationInputProcessingConfigurationRequest.Builder> deleteApplicationInputProcessingConfigurationRequest) {
        return deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest.builder()
                .applyMutation(deleteApplicationInputProcessingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's
     * configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to
     * the external output destination.
     * </p>
     *
     * @param deleteApplicationOutputRequest
     * @return A Java Future containing the result of the DeleteApplicationOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationOutputResponse> deleteApplicationOutput(
            DeleteApplicationOutputRequest deleteApplicationOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's
     * configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to
     * the external output destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationOutputRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApplicationOutputRequest#builder()}
     * </p>
     *
     * @param deleteApplicationOutputRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplicationOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationOutputResponse> deleteApplicationOutput(
            Consumer<DeleteApplicationOutputRequest.Builder> deleteApplicationOutputRequest) {
        return deleteApplicationOutput(DeleteApplicationOutputRequest.builder().applyMutation(deleteApplicationOutputRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's
     * configuration.
     * </p>
     * <p>
     * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you
     * created using the <a>AddApplicationReferenceDataSource</a> operation.
     * </p>
     *
     * @param deleteApplicationReferenceDataSourceRequest
     * @return A Java Future containing the result of the DeleteApplicationReferenceDataSource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationReferenceDataSourceResponse> deleteApplicationReferenceDataSource(
            DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's
     * configuration.
     * </p>
     * <p>
     * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you
     * created using the <a>AddApplicationReferenceDataSource</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationReferenceDataSourceRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationReferenceDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteApplicationReferenceDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationReferenceDataSourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteApplicationReferenceDataSource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationReferenceDataSourceResponse> deleteApplicationReferenceDataSource(
            Consumer<DeleteApplicationReferenceDataSourceRequest.Builder> deleteApplicationReferenceDataSourceRequest) {
        return deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest.builder()
                .applyMutation(deleteApplicationReferenceDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot of application state.
     * </p>
     *
     * @param deleteApplicationSnapshotRequest
     * @return A Java Future containing the result of the DeleteApplicationSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationSnapshotResponse> deleteApplicationSnapshot(
            DeleteApplicationSnapshotRequest deleteApplicationSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot of application state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApplicationSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteApplicationSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplicationSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationSnapshotResponse> deleteApplicationSnapshot(
            Consumer<DeleteApplicationSnapshotRequest.Builder> deleteApplicationSnapshotRequest) {
        return deleteApplicationSnapshot(DeleteApplicationSnapshotRequest.builder()
                .applyMutation(deleteApplicationSnapshotRequest).build());
    }

    /**
     * <p>
     * Removes a VPC configuration from a Kinesis Data Analytics application.
     * </p>
     *
     * @param deleteApplicationVpcConfigurationRequest
     * @return A Java Future containing the result of the DeleteApplicationVpcConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationVpcConfigurationResponse> deleteApplicationVpcConfiguration(
            DeleteApplicationVpcConfigurationRequest deleteApplicationVpcConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a VPC configuration from a Kinesis Data Analytics application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationVpcConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApplicationVpcConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationVpcConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationVpcConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteApplicationVpcConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DeleteApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationVpcConfigurationResponse> deleteApplicationVpcConfiguration(
            Consumer<DeleteApplicationVpcConfigurationRequest.Builder> deleteApplicationVpcConfigurationRequest) {
        return deleteApplicationVpcConfiguration(DeleteApplicationVpcConfigurationRequest.builder()
                .applyMutation(deleteApplicationVpcConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific Kinesis Data Analytics application.
     * </p>
     * <p>
     * If you want to retrieve a list of all applications in your account, use the <a>ListApplications</a> operation.
     * </p>
     *
     * @param describeApplicationRequest
     * @return A Java Future containing the result of the DescribeApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationResponse> describeApplication(
            DescribeApplicationRequest describeApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific Kinesis Data Analytics application.
     * </p>
     * <p>
     * If you want to retrieve a list of all applications in your account, use the <a>ListApplications</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationRequest#builder()}
     * </p>
     *
     * @param describeApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationResponse> describeApplication(
            Consumer<DescribeApplicationRequest.Builder> describeApplicationRequest) {
        return describeApplication(DescribeApplicationRequest.builder().applyMutation(describeApplicationRequest).build());
    }

    /**
     * <p>
     * Returns information about a snapshot of application state data.
     * </p>
     *
     * @param describeApplicationSnapshotRequest
     * @return A Java Future containing the result of the DescribeApplicationSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DescribeApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationSnapshotResponse> describeApplicationSnapshot(
            DescribeApplicationSnapshotRequest describeApplicationSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a snapshot of application state data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationSnapshotRequest#builder()}
     * </p>
     *
     * @param describeApplicationSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationSnapshotRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeApplicationSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DescribeApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationSnapshotResponse> describeApplicationSnapshot(
            Consumer<DescribeApplicationSnapshotRequest.Builder> describeApplicationSnapshotRequest) {
        return describeApplicationSnapshot(DescribeApplicationSnapshotRequest.builder()
                .applyMutation(describeApplicationSnapshotRequest).build());
    }

    /**
     * <p>
     * Provides a detailed description of a specified version of the application. To see a list of all the versions of
     * an application, invoke the <a>ListApplicationVersions</a> operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     * </p>
     * </note>
     *
     * @param describeApplicationVersionRequest
     * @return A Java Future containing the result of the DescribeApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DescribeApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationVersionResponse> describeApplicationVersion(
            DescribeApplicationVersionRequest describeApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed description of a specified version of the application. To see a list of all the versions of
     * an application, invoke the <a>ListApplicationVersions</a> operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeApplicationVersionRequest#builder()}
     * </p>
     *
     * @param describeApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DescribeApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationVersionResponse> describeApplicationVersion(
            Consumer<DescribeApplicationVersionRequest.Builder> describeApplicationVersionRequest) {
        return describeApplicationVersion(DescribeApplicationVersionRequest.builder()
                .applyMutation(describeApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified
     * streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the
     * response, the operation returns the inferred schema and also the sample records that the operation used to infer
     * the schema.
     * </p>
     * <p>
     * You can use the inferred schema when configuring a streaming source for your application. When you create an
     * application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show
     * it in the console user interface.
     * </p>
     *
     * @param discoverInputSchemaRequest
     * @return A Java Future containing the result of the DiscoverInputSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnableToDetectSchemaException The data format is not valid. Kinesis Data Analytics cannot detect the
     *         schema for the given streaming source.</li>
     *         <li>ResourceProvisionedThroughputExceededException Discovery failed to get a record from the streaming
     *         source because of the Kinesis Streams <code>ProvisionedThroughputExceededException</code>. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html">GetRecords</a> in the
     *         Amazon Kinesis Streams API Reference.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DiscoverInputSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DiscoverInputSchemaResponse> discoverInputSchema(
            DiscoverInputSchemaRequest discoverInputSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified
     * streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the
     * response, the operation returns the inferred schema and also the sample records that the operation used to infer
     * the schema.
     * </p>
     * <p>
     * You can use the inferred schema when configuring a streaming source for your application. When you create an
     * application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show
     * it in the console user interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DiscoverInputSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link DiscoverInputSchemaRequest#builder()}
     * </p>
     *
     * @param discoverInputSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DiscoverInputSchemaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DiscoverInputSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnableToDetectSchemaException The data format is not valid. Kinesis Data Analytics cannot detect the
     *         schema for the given streaming source.</li>
     *         <li>ResourceProvisionedThroughputExceededException Discovery failed to get a record from the streaming
     *         source because of the Kinesis Streams <code>ProvisionedThroughputExceededException</code>. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html">GetRecords</a> in the
     *         Amazon Kinesis Streams API Reference.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.DiscoverInputSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DiscoverInputSchemaResponse> discoverInputSchema(
            Consumer<DiscoverInputSchemaRequest.Builder> discoverInputSchemaRequest) {
        return discoverInputSchema(DiscoverInputSchemaRequest.builder().applyMutation(discoverInputSchemaRequest).build());
    }

    /**
     * <p>
     * Lists information about the current application snapshots.
     * </p>
     *
     * @param listApplicationSnapshotsRequest
     * @return A Java Future containing the result of the ListApplicationSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplicationSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationSnapshotsResponse> listApplicationSnapshots(
            ListApplicationSnapshotsRequest listApplicationSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the current application snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationSnapshotsRequest#builder()}
     * </p>
     *
     * @param listApplicationSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationSnapshotsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplicationSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationSnapshotsResponse> listApplicationSnapshots(
            Consumer<ListApplicationSnapshotsRequest.Builder> listApplicationSnapshotsRequest) {
        return listApplicationSnapshots(ListApplicationSnapshotsRequest.builder().applyMutation(listApplicationSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the versions for the specified application, including versions that were rolled back. The response also
     * includes a summary of the configuration associated with each version.
     * </p>
     * <p>
     * To get the complete description of a specific application version, invoke the <a>DescribeApplicationVersion</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     * </p>
     * </note>
     *
     * @param listApplicationVersionsRequest
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            ListApplicationVersionsRequest listApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions for the specified application, including versions that were rolled back. The response also
     * includes a summary of the configuration associated with each version.
     * </p>
     * <p>
     * To get the complete description of a specific application version, invoke the <a>DescribeApplicationVersion</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) {
        return listApplicationVersions(ListApplicationVersionsRequest.builder().applyMutation(listApplicationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Kinesis Data Analytics applications in your account. For each application, the response
     * includes the application name, Amazon Resource Name (ARN), and status.
     * </p>
     * <p>
     * If you want detailed information about a specific application, use <a>DescribeApplication</a>.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Kinesis Data Analytics applications in your account. For each application, the response
     * includes the application name, Amazon Resource Name (ARN), and status.
     * </p>
     * <p>
     * If you want detailed information about a specific application, use <a>DescribeApplication</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Kinesis Data Analytics applications in your account. For each application, the response
     * includes the application name, Amazon Resource Name (ARN), and status.
     * </p>
     * <p>
     * If you want detailed information about a specific application, use <a>DescribeApplication</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications() {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the list of key-value tags assigned to the application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of key-value tags assigned to the application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Reverts the application to the previous running version. You can roll back an application if you suspect it is
     * stuck in a transient status.
     * </p>
     * <p>
     * You can roll back an application only if it is in the <code>UPDATING</code> or <code>AUTOSCALING</code> status.
     * </p>
     * <p>
     * When you rollback an application, it loads state data from the last successful snapshot. If the application has
     * no snapshots, Kinesis Data Analytics rejects the rollback request.
     * </p>
     * <p>
     * This action is not supported for Kinesis Data Analytics for SQL applications.
     * </p>
     *
     * @param rollbackApplicationRequest
     * @return A Java Future containing the result of the RollbackApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.RollbackApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RollbackApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RollbackApplicationResponse> rollbackApplication(
            RollbackApplicationRequest rollbackApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reverts the application to the previous running version. You can roll back an application if you suspect it is
     * stuck in a transient status.
     * </p>
     * <p>
     * You can roll back an application only if it is in the <code>UPDATING</code> or <code>AUTOSCALING</code> status.
     * </p>
     * <p>
     * When you rollback an application, it loads state data from the last successful snapshot. If the application has
     * no snapshots, Kinesis Data Analytics rejects the rollback request.
     * </p>
     * <p>
     * This action is not supported for Kinesis Data Analytics for SQL applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RollbackApplicationRequest#builder()}
     * </p>
     *
     * @param rollbackApplicationRequest
     *        A {@link Consumer} that will call methods on {@link RollbackApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RollbackApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.RollbackApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RollbackApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RollbackApplicationResponse> rollbackApplication(
            Consumer<RollbackApplicationRequest.Builder> rollbackApplicationRequest) {
        return rollbackApplication(RollbackApplicationRequest.builder().applyMutation(rollbackApplicationRequest).build());
    }

    /**
     * <p>
     * Starts the specified Kinesis Data Analytics application. After creating an application, you must exclusively call
     * this operation to start your application.
     * </p>
     *
     * @param startApplicationRequest
     * @return A Java Future containing the result of the StartApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartApplicationResponse> startApplication(StartApplicationRequest startApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified Kinesis Data Analytics application. After creating an application, you must exclusively call
     * this operation to start your application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartApplicationRequest#builder()}
     * </p>
     *
     * @param startApplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartApplicationResponse> startApplication(
            Consumer<StartApplicationRequest.Builder> startApplicationRequest) {
        return startApplication(StartApplicationRequest.builder().applyMutation(startApplicationRequest).build());
    }

    /**
     * <p>
     * Stops the application from processing data. You can stop an application only if it is in the running status,
     * unless you set the <code>Force</code> parameter to <code>true</code>.
     * </p>
     * <p>
     * You can use the <a>DescribeApplication</a> operation to find the application status.
     * </p>
     * <p>
     * Kinesis Data Analytics takes a snapshot when the application is stopped, unless <code>Force</code> is set to
     * <code>true</code>.
     * </p>
     *
     * @param stopApplicationRequest
     * @return A Java Future containing the result of the StopApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopApplicationResponse> stopApplication(StopApplicationRequest stopApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the application from processing data. You can stop an application only if it is in the running status,
     * unless you set the <code>Force</code> parameter to <code>true</code>.
     * </p>
     * <p>
     * You can use the <a>DescribeApplication</a> operation to find the application status.
     * </p>
     * <p>
     * Kinesis Data Analytics takes a snapshot when the application is stopped, unless <code>Force</code> is set to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopApplicationRequest#builder()}
     * </p>
     *
     * @param stopApplicationRequest
     *        A {@link Consumer} that will call methods on {@link StopApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopApplicationResponse> stopApplication(
            Consumer<StopApplicationRequest.Builder> stopApplicationRequest) {
        return stopApplication(StopApplicationRequest.builder().applyMutation(stopApplicationRequest).build());
    }

    /**
     * <p>
     * Adds one or more key-value tags to a Kinesis Data Analytics application. Note that the maximum number of
     * application tags includes system tags. The maximum number of user-defined application tags is 50. For more
     * information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using
     * Tagging</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>TooManyTagsException Application created with too many tags, or too many tags added to an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more key-value tags to a Kinesis Data Analytics application. Note that the maximum number of
     * application tags includes system tags. The maximum number of user-defined application tags is 50. For more
     * information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using
     * Tagging</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>TooManyTagsException Application created with too many tags, or too many tags added to an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a Kinesis Data Analytics application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>TooManyTagsException Application created with too many tags, or too many tags added to an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a Kinesis Data Analytics application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>TooManyTagsException Application created with too many tags, or too many tags added to an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code,
     * input configuration, and output configuration.
     * </p>
     * <p>
     * Kinesis Data Analytics updates the <code>ApplicationVersionId</code> each time you update your application.
     * </p>
     * <note>
     * <p>
     * You cannot update the <code>RuntimeEnvironment</code> of an existing application. If you need to update an
     * application's <code>RuntimeEnvironment</code>, you must delete the application and create it again.
     * </p>
     * </note>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CodeValidationException The user-provided application code (query) is not valid. This can be a simple
     *         syntax error.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>LimitExceededException The number of allowed resources has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code,
     * input configuration, and output configuration.
     * </p>
     * <p>
     * Kinesis Data Analytics updates the <code>ApplicationVersionId</code> each time you update your application.
     * </p>
     * <note>
     * <p>
     * You cannot update the <code>RuntimeEnvironment</code> of an existing application. If you need to update an
     * application's <code>RuntimeEnvironment</code>, you must delete the application and create it again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CodeValidationException The user-provided application code (query) is not valid. This can be a simple
     *         syntax error.</li>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>InvalidRequestException The request JSON is not valid for the operation.</li>
     *         <li>InvalidApplicationConfigurationException The user-provided application configuration is not valid.</li>
     *         <li>LimitExceededException The number of allowed resources has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the maintenance configuration of the Kinesis Data Analytics application.
     * </p>
     * <p>
     * You can invoke this operation on an application that is in one of the two following states: <code>READY</code> or
     * <code>RUNNING</code>. If you invoke it when the application is in a state other than these two states, it throws
     * a <code>ResourceInUseException</code>. The service makes use of the updated configuration the next time it
     * schedules maintenance for the application. If you invoke this operation after the service schedules maintenance,
     * the service will apply the configuration update the next time it schedules maintenance for the application. This
     * means that you might not see the maintenance configuration update applied to the maintenance process that follows
     * a successful invocation of this operation, but to the following maintenance process instead.
     * </p>
     * <p>
     * To see the current maintenance configuration of your application, invoke the <a>DescribeApplication</a>
     * operation.
     * </p>
     * <p>
     * For information about application maintenance, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html">Kinesis Data Analytics for
     * Apache Flink Maintenance</a>.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     * </p>
     * </note>
     *
     * @param updateApplicationMaintenanceConfigurationRequest
     * @return A Java Future containing the result of the UpdateApplicationMaintenanceConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.UpdateApplicationMaintenanceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplicationMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationMaintenanceConfigurationResponse> updateApplicationMaintenanceConfiguration(
            UpdateApplicationMaintenanceConfigurationRequest updateApplicationMaintenanceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the maintenance configuration of the Kinesis Data Analytics application.
     * </p>
     * <p>
     * You can invoke this operation on an application that is in one of the two following states: <code>READY</code> or
     * <code>RUNNING</code>. If you invoke it when the application is in a state other than these two states, it throws
     * a <code>ResourceInUseException</code>. The service makes use of the updated configuration the next time it
     * schedules maintenance for the application. If you invoke this operation after the service schedules maintenance,
     * the service will apply the configuration update the next time it schedules maintenance for the application. This
     * means that you might not see the maintenance configuration update applied to the maintenance process that follows
     * a successful invocation of this operation, but to the following maintenance process instead.
     * </p>
     * <p>
     * To see the current maintenance configuration of your application, invoke the <a>DescribeApplication</a>
     * operation.
     * </p>
     * <p>
     * For information about application maintenance, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html">Kinesis Data Analytics for
     * Apache Flink Maintenance</a>.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateApplicationMaintenanceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateApplicationMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateApplicationMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateApplicationMaintenanceConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApplicationMaintenanceConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Specified application can't be found.</li>
     *         <li>ResourceInUseException The application is not available for this operation.</li>
     *         <li>InvalidArgumentException The specified input parameter value is not valid.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modifications to an
     *         application. This error can be the result of attempting to modify an application without using the
     *         current application ID.</li>
     *         <li>UnsupportedOperationException The request was rejected because a specified parameter is not supported
     *         or a specified resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisAnalyticsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample KinesisAnalyticsV2AsyncClient.UpdateApplicationMaintenanceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplicationMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationMaintenanceConfigurationResponse> updateApplicationMaintenanceConfiguration(
            Consumer<UpdateApplicationMaintenanceConfigurationRequest.Builder> updateApplicationMaintenanceConfigurationRequest) {
        return updateApplicationMaintenanceConfiguration(UpdateApplicationMaintenanceConfigurationRequest.builder()
                .applyMutation(updateApplicationMaintenanceConfigurationRequest).build());
    }

    @Override
    default KinesisAnalyticsV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link KinesisAnalyticsV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KinesisAnalyticsV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KinesisAnalyticsV2AsyncClient}.
     */
    static KinesisAnalyticsV2AsyncClientBuilder builder() {
        return new DefaultKinesisAnalyticsV2AsyncClientBuilder();
    }
}
