/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the starting parameters for an Managed Service for Apache Flink application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RunConfiguration.Builder, RunConfiguration> {
    private static final SdkField<FlinkRunConfiguration> FLINK_RUN_CONFIGURATION_FIELD = SdkField
            .<FlinkRunConfiguration> builder(MarshallingType.SDK_POJO).memberName("FlinkRunConfiguration")
            .getter(getter(RunConfiguration::flinkRunConfiguration)).setter(setter(Builder::flinkRunConfiguration))
            .constructor(FlinkRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkRunConfiguration").build())
            .build();

    private static final SdkField<List<SqlRunConfiguration>> SQL_RUN_CONFIGURATIONS_FIELD = SdkField
            .<List<SqlRunConfiguration>> builder(MarshallingType.LIST)
            .memberName("SqlRunConfigurations")
            .getter(getter(RunConfiguration::sqlRunConfigurations))
            .setter(setter(Builder::sqlRunConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlRunConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlRunConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlRunConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationRestoreConfiguration> APPLICATION_RESTORE_CONFIGURATION_FIELD = SdkField
            .<ApplicationRestoreConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationRestoreConfiguration")
            .getter(getter(RunConfiguration::applicationRestoreConfiguration))
            .setter(setter(Builder::applicationRestoreConfiguration))
            .constructor(ApplicationRestoreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRestoreConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLINK_RUN_CONFIGURATION_FIELD,
            SQL_RUN_CONFIGURATIONS_FIELD, APPLICATION_RESTORE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FlinkRunConfiguration flinkRunConfiguration;

    private final List<SqlRunConfiguration> sqlRunConfigurations;

    private final ApplicationRestoreConfiguration applicationRestoreConfiguration;

    private RunConfiguration(BuilderImpl builder) {
        this.flinkRunConfiguration = builder.flinkRunConfiguration;
        this.sqlRunConfigurations = builder.sqlRunConfigurations;
        this.applicationRestoreConfiguration = builder.applicationRestoreConfiguration;
    }

    /**
     * <p>
     * Describes the starting parameters for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @return Describes the starting parameters for a Managed Service for Apache Flink application.
     */
    public final FlinkRunConfiguration flinkRunConfiguration() {
        return flinkRunConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SqlRunConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSqlRunConfigurations() {
        return sqlRunConfigurations != null && !(sqlRunConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSqlRunConfigurations} method.
     * </p>
     * 
     * @return Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
     */
    public final List<SqlRunConfiguration> sqlRunConfigurations() {
        return sqlRunConfigurations;
    }

    /**
     * <p>
     * Describes the restore behavior of a restarting application.
     * </p>
     * 
     * @return Describes the restore behavior of a restarting application.
     */
    public final ApplicationRestoreConfiguration applicationRestoreConfiguration() {
        return applicationRestoreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flinkRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasSqlRunConfigurations() ? sqlRunConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationRestoreConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunConfiguration)) {
            return false;
        }
        RunConfiguration other = (RunConfiguration) obj;
        return Objects.equals(flinkRunConfiguration(), other.flinkRunConfiguration())
                && hasSqlRunConfigurations() == other.hasSqlRunConfigurations()
                && Objects.equals(sqlRunConfigurations(), other.sqlRunConfigurations())
                && Objects.equals(applicationRestoreConfiguration(), other.applicationRestoreConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunConfiguration").add("FlinkRunConfiguration", flinkRunConfiguration())
                .add("SqlRunConfigurations", hasSqlRunConfigurations() ? sqlRunConfigurations() : null)
                .add("ApplicationRestoreConfiguration", applicationRestoreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlinkRunConfiguration":
            return Optional.ofNullable(clazz.cast(flinkRunConfiguration()));
        case "SqlRunConfigurations":
            return Optional.ofNullable(clazz.cast(sqlRunConfigurations()));
        case "ApplicationRestoreConfiguration":
            return Optional.ofNullable(clazz.cast(applicationRestoreConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunConfiguration, T> g) {
        return obj -> g.apply((RunConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunConfiguration> {
        /**
         * <p>
         * Describes the starting parameters for a Managed Service for Apache Flink application.
         * </p>
         * 
         * @param flinkRunConfiguration
         *        Describes the starting parameters for a Managed Service for Apache Flink application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration);

        /**
         * <p>
         * Describes the starting parameters for a Managed Service for Apache Flink application.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlinkRunConfiguration.Builder} avoiding
         * the need to create one manually via {@link FlinkRunConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlinkRunConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #flinkRunConfiguration(FlinkRunConfiguration)}.
         * 
         * @param flinkRunConfiguration
         *        a consumer that will call methods on {@link FlinkRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkRunConfiguration(FlinkRunConfiguration)
         */
        default Builder flinkRunConfiguration(Consumer<FlinkRunConfiguration.Builder> flinkRunConfiguration) {
            return flinkRunConfiguration(FlinkRunConfiguration.builder().applyMutation(flinkRunConfiguration).build());
        }

        /**
         * <p>
         * Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
         * </p>
         * 
         * @param sqlRunConfigurations
         *        Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlRunConfigurations(Collection<SqlRunConfiguration> sqlRunConfigurations);

        /**
         * <p>
         * Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
         * </p>
         * 
         * @param sqlRunConfigurations
         *        Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlRunConfigurations(SqlRunConfiguration... sqlRunConfigurations);

        /**
         * <p>
         * Describes the starting parameters for a SQL-based Kinesis Data Analytics application application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #sqlRunConfigurations(List<SqlRunConfiguration>)}.
         * 
         * @param sqlRunConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlRunConfigurations(java.util.Collection<SqlRunConfiguration>)
         */
        Builder sqlRunConfigurations(Consumer<SqlRunConfiguration.Builder>... sqlRunConfigurations);

        /**
         * <p>
         * Describes the restore behavior of a restarting application.
         * </p>
         * 
         * @param applicationRestoreConfiguration
         *        Describes the restore behavior of a restarting application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration);

        /**
         * <p>
         * Describes the restore behavior of a restarting application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationRestoreConfiguration.Builder}
         * avoiding the need to create one manually via {@link ApplicationRestoreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationRestoreConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationRestoreConfiguration(ApplicationRestoreConfiguration)}.
         * 
         * @param applicationRestoreConfiguration
         *        a consumer that will call methods on {@link ApplicationRestoreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationRestoreConfiguration(ApplicationRestoreConfiguration)
         */
        default Builder applicationRestoreConfiguration(
                Consumer<ApplicationRestoreConfiguration.Builder> applicationRestoreConfiguration) {
            return applicationRestoreConfiguration(ApplicationRestoreConfiguration.builder()
                    .applyMutation(applicationRestoreConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FlinkRunConfiguration flinkRunConfiguration;

        private List<SqlRunConfiguration> sqlRunConfigurations = DefaultSdkAutoConstructList.getInstance();

        private ApplicationRestoreConfiguration applicationRestoreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RunConfiguration model) {
            flinkRunConfiguration(model.flinkRunConfiguration);
            sqlRunConfigurations(model.sqlRunConfigurations);
            applicationRestoreConfiguration(model.applicationRestoreConfiguration);
        }

        public final FlinkRunConfiguration.Builder getFlinkRunConfiguration() {
            return flinkRunConfiguration != null ? flinkRunConfiguration.toBuilder() : null;
        }

        public final void setFlinkRunConfiguration(FlinkRunConfiguration.BuilderImpl flinkRunConfiguration) {
            this.flinkRunConfiguration = flinkRunConfiguration != null ? flinkRunConfiguration.build() : null;
        }

        @Override
        public final Builder flinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration) {
            this.flinkRunConfiguration = flinkRunConfiguration;
            return this;
        }

        public final List<SqlRunConfiguration.Builder> getSqlRunConfigurations() {
            List<SqlRunConfiguration.Builder> result = SqlRunConfigurationsCopier.copyToBuilder(this.sqlRunConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSqlRunConfigurations(Collection<SqlRunConfiguration.BuilderImpl> sqlRunConfigurations) {
            this.sqlRunConfigurations = SqlRunConfigurationsCopier.copyFromBuilder(sqlRunConfigurations);
        }

        @Override
        public final Builder sqlRunConfigurations(Collection<SqlRunConfiguration> sqlRunConfigurations) {
            this.sqlRunConfigurations = SqlRunConfigurationsCopier.copy(sqlRunConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlRunConfigurations(SqlRunConfiguration... sqlRunConfigurations) {
            sqlRunConfigurations(Arrays.asList(sqlRunConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlRunConfigurations(Consumer<SqlRunConfiguration.Builder>... sqlRunConfigurations) {
            sqlRunConfigurations(Stream.of(sqlRunConfigurations).map(c -> SqlRunConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ApplicationRestoreConfiguration.Builder getApplicationRestoreConfiguration() {
            return applicationRestoreConfiguration != null ? applicationRestoreConfiguration.toBuilder() : null;
        }

        public final void setApplicationRestoreConfiguration(
                ApplicationRestoreConfiguration.BuilderImpl applicationRestoreConfiguration) {
            this.applicationRestoreConfiguration = applicationRestoreConfiguration != null ? applicationRestoreConfiguration
                    .build() : null;
        }

        @Override
        public final Builder applicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration) {
            this.applicationRestoreConfiguration = applicationRestoreConfiguration;
            return this;
        }

        @Override
        public RunConfiguration build() {
            return new RunConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
