/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the maintenance configuration for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationMaintenanceConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationMaintenanceConfigurationDescription.Builder, ApplicationMaintenanceConfigurationDescription> {
    private static final SdkField<String> APPLICATION_MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationMaintenanceWindowStartTime")
            .getter(getter(ApplicationMaintenanceConfigurationDescription::applicationMaintenanceWindowStartTime))
            .setter(setter(Builder::applicationMaintenanceWindowStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationMaintenanceWindowStartTime").build()).build();

    private static final SdkField<String> APPLICATION_MAINTENANCE_WINDOW_END_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationMaintenanceWindowEndTime")
            .getter(getter(ApplicationMaintenanceConfigurationDescription::applicationMaintenanceWindowEndTime))
            .setter(setter(Builder::applicationMaintenanceWindowEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationMaintenanceWindowEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_MAINTENANCE_WINDOW_START_TIME_FIELD, APPLICATION_MAINTENANCE_WINDOW_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationMaintenanceWindowStartTime;

    private final String applicationMaintenanceWindowEndTime;

    private ApplicationMaintenanceConfigurationDescription(BuilderImpl builder) {
        this.applicationMaintenanceWindowStartTime = builder.applicationMaintenanceWindowStartTime;
        this.applicationMaintenanceWindowEndTime = builder.applicationMaintenanceWindowEndTime;
    }

    /**
     * <p>
     * The start time for the maintenance window.
     * </p>
     * 
     * @return The start time for the maintenance window.
     */
    public final String applicationMaintenanceWindowStartTime() {
        return applicationMaintenanceWindowStartTime;
    }

    /**
     * <p>
     * The end time for the maintenance window.
     * </p>
     * 
     * @return The end time for the maintenance window.
     */
    public final String applicationMaintenanceWindowEndTime() {
        return applicationMaintenanceWindowEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationMaintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(applicationMaintenanceWindowEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationMaintenanceConfigurationDescription)) {
            return false;
        }
        ApplicationMaintenanceConfigurationDescription other = (ApplicationMaintenanceConfigurationDescription) obj;
        return Objects.equals(applicationMaintenanceWindowStartTime(), other.applicationMaintenanceWindowStartTime())
                && Objects.equals(applicationMaintenanceWindowEndTime(), other.applicationMaintenanceWindowEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationMaintenanceConfigurationDescription")
                .add("ApplicationMaintenanceWindowStartTime", applicationMaintenanceWindowStartTime())
                .add("ApplicationMaintenanceWindowEndTime", applicationMaintenanceWindowEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationMaintenanceWindowStartTime":
            return Optional.ofNullable(clazz.cast(applicationMaintenanceWindowStartTime()));
        case "ApplicationMaintenanceWindowEndTime":
            return Optional.ofNullable(clazz.cast(applicationMaintenanceWindowEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationMaintenanceConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationMaintenanceConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationMaintenanceConfigurationDescription> {
        /**
         * <p>
         * The start time for the maintenance window.
         * </p>
         * 
         * @param applicationMaintenanceWindowStartTime
         *        The start time for the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMaintenanceWindowStartTime(String applicationMaintenanceWindowStartTime);

        /**
         * <p>
         * The end time for the maintenance window.
         * </p>
         * 
         * @param applicationMaintenanceWindowEndTime
         *        The end time for the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMaintenanceWindowEndTime(String applicationMaintenanceWindowEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String applicationMaintenanceWindowStartTime;

        private String applicationMaintenanceWindowEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationMaintenanceConfigurationDescription model) {
            applicationMaintenanceWindowStartTime(model.applicationMaintenanceWindowStartTime);
            applicationMaintenanceWindowEndTime(model.applicationMaintenanceWindowEndTime);
        }

        public final String getApplicationMaintenanceWindowStartTime() {
            return applicationMaintenanceWindowStartTime;
        }

        public final void setApplicationMaintenanceWindowStartTime(String applicationMaintenanceWindowStartTime) {
            this.applicationMaintenanceWindowStartTime = applicationMaintenanceWindowStartTime;
        }

        @Override
        public final Builder applicationMaintenanceWindowStartTime(String applicationMaintenanceWindowStartTime) {
            this.applicationMaintenanceWindowStartTime = applicationMaintenanceWindowStartTime;
            return this;
        }

        public final String getApplicationMaintenanceWindowEndTime() {
            return applicationMaintenanceWindowEndTime;
        }

        public final void setApplicationMaintenanceWindowEndTime(String applicationMaintenanceWindowEndTime) {
            this.applicationMaintenanceWindowEndTime = applicationMaintenanceWindowEndTime;
        }

        @Override
        public final Builder applicationMaintenanceWindowEndTime(String applicationMaintenanceWindowEndTime) {
            this.applicationMaintenanceWindowEndTime = applicationMaintenanceWindowEndTime;
            return this;
        }

        @Override
        public ApplicationMaintenanceConfigurationDescription build() {
            return new ApplicationMaintenanceConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
