/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Describes system rollback configuration for a Managed Service for Apache Flink application
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSystemRollbackConfigurationDescription
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ApplicationSystemRollbackConfigurationDescription.Builder, ApplicationSystemRollbackConfigurationDescription> {
    private static final SdkField<Boolean> ROLLBACK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RollbackEnabled").getter(getter(ApplicationSystemRollbackConfigurationDescription::rollbackEnabled))
            .setter(setter(Builder::rollbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLBACK_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean rollbackEnabled;

    private ApplicationSystemRollbackConfigurationDescription(BuilderImpl builder) {
        this.rollbackEnabled = builder.rollbackEnabled;
    }

    /**
     * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
     * 
     * @return Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
     */
    public final Boolean rollbackEnabled() {
        return rollbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollbackEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSystemRollbackConfigurationDescription)) {
            return false;
        }
        ApplicationSystemRollbackConfigurationDescription other = (ApplicationSystemRollbackConfigurationDescription) obj;
        return Objects.equals(rollbackEnabled(), other.rollbackEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSystemRollbackConfigurationDescription").add("RollbackEnabled", rollbackEnabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollbackEnabled":
            return Optional.ofNullable(clazz.cast(rollbackEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSystemRollbackConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationSystemRollbackConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSystemRollbackConfigurationDescription> {
        /**
         * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
         * 
         * @param rollbackEnabled
         *        Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackEnabled(Boolean rollbackEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean rollbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSystemRollbackConfigurationDescription model) {
            rollbackEnabled(model.rollbackEnabled);
        }

        public final Boolean getRollbackEnabled() {
            return rollbackEnabled;
        }

        public final void setRollbackEnabled(Boolean rollbackEnabled) {
            this.rollbackEnabled = rollbackEnabled;
        }

        @Override
        public final Builder rollbackEnabled(Boolean rollbackEnabled) {
            this.rollbackEnabled = rollbackEnabled;
            return this;
        }

        @Override
        public ApplicationSystemRollbackConfigurationDescription build() {
            return new ApplicationSystemRollbackConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
