/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Describes system rollback configuration for a Managed Service for Apache Flink application
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSystemRollbackConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSystemRollbackConfigurationUpdate.Builder, ApplicationSystemRollbackConfigurationUpdate> {
    private static final SdkField<Boolean> ROLLBACK_ENABLED_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RollbackEnabledUpdate")
            .getter(getter(ApplicationSystemRollbackConfigurationUpdate::rollbackEnabledUpdate))
            .setter(setter(Builder::rollbackEnabledUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackEnabledUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ROLLBACK_ENABLED_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean rollbackEnabledUpdate;

    private ApplicationSystemRollbackConfigurationUpdate(BuilderImpl builder) {
        this.rollbackEnabledUpdate = builder.rollbackEnabledUpdate;
    }

    /**
     * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
     * 
     * @return Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
     */
    public final Boolean rollbackEnabledUpdate() {
        return rollbackEnabledUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollbackEnabledUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSystemRollbackConfigurationUpdate)) {
            return false;
        }
        ApplicationSystemRollbackConfigurationUpdate other = (ApplicationSystemRollbackConfigurationUpdate) obj;
        return Objects.equals(rollbackEnabledUpdate(), other.rollbackEnabledUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSystemRollbackConfigurationUpdate")
                .add("RollbackEnabledUpdate", rollbackEnabledUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollbackEnabledUpdate":
            return Optional.ofNullable(clazz.cast(rollbackEnabledUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSystemRollbackConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationSystemRollbackConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSystemRollbackConfigurationUpdate> {
        /**
         * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
         * 
         * @param rollbackEnabledUpdate
         *        Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackEnabledUpdate(Boolean rollbackEnabledUpdate);
    }

    static final class BuilderImpl implements Builder {
        private Boolean rollbackEnabledUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSystemRollbackConfigurationUpdate model) {
            rollbackEnabledUpdate(model.rollbackEnabledUpdate);
        }

        public final Boolean getRollbackEnabledUpdate() {
            return rollbackEnabledUpdate;
        }

        public final void setRollbackEnabledUpdate(Boolean rollbackEnabledUpdate) {
            this.rollbackEnabledUpdate = rollbackEnabledUpdate;
        }

        @Override
        public final Builder rollbackEnabledUpdate(Boolean rollbackEnabledUpdate) {
            this.rollbackEnabledUpdate = rollbackEnabledUpdate;
            return this;
        }

        @Override
        public ApplicationSystemRollbackConfigurationUpdate build() {
            return new ApplicationSystemRollbackConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
