/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the application version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationVersionSummary.Builder, ApplicationVersionSummary> {
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(ApplicationVersionSummary::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus").getter(getter(ApplicationVersionSummary::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_ID_FIELD,
            APPLICATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long applicationVersionId;

    private final String applicationStatus;

    private ApplicationVersionSummary(BuilderImpl builder) {
        this.applicationVersionId = builder.applicationVersionId;
        this.applicationStatus = builder.applicationStatus;
    }

    /**
     * <p>
     * The ID of the application version. Managed Service for Apache Flink updates the <code>ApplicationVersionId</code>
     * each time you update the application.
     * </p>
     * 
     * @return The ID of the application version. Managed Service for Apache Flink updates the
     *         <code>ApplicationVersionId</code> each time you update the application.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionSummary)) {
            return false;
        }
        ApplicationVersionSummary other = (ApplicationVersionSummary) obj;
        return Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationVersionSummary").add("ApplicationVersionId", applicationVersionId())
                .add("ApplicationStatus", applicationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionSummary, T> g) {
        return obj -> g.apply((ApplicationVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationVersionSummary> {
        /**
         * <p>
         * The ID of the application version. Managed Service for Apache Flink updates the
         * <code>ApplicationVersionId</code> each time you update the application.
         * </p>
         * 
         * @param applicationVersionId
         *        The ID of the application version. Managed Service for Apache Flink updates the
         *        <code>ApplicationVersionId</code> each time you update the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);
    }

    static final class BuilderImpl implements Builder {
        private Long applicationVersionId;

        private String applicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionSummary model) {
            applicationVersionId(model.applicationVersionId);
            applicationStatus(model.applicationStatus);
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        @Override
        public ApplicationVersionSummary build() {
            return new ApplicationVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
