/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Provides a description of the operation, such as the type and status of operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationOperationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationOperationInfo.Builder, ApplicationOperationInfo> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(ApplicationOperationInfo::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(ApplicationOperationInfo::operationId)).setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ApplicationOperationInfo::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ApplicationOperationInfo::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationStatus").getter(getter(ApplicationOperationInfo::operationStatusAsString))
            .setter(setter(Builder::operationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD,
            OPERATION_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, OPERATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operation;

    private final String operationId;

    private final Instant startTime;

    private final Instant endTime;

    private final String operationStatus;

    private ApplicationOperationInfo(BuilderImpl builder) {
        this.operation = builder.operation;
        this.operationId = builder.operationId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.operationStatus = builder.operationStatus;
    }

    /**
     * Returns the value of the Operation property for this object.
     * 
     * @return The value of the Operation property for this object.
     */
    public final String operation() {
        return operation;
    }

    /**
     * Returns the value of the OperationId property for this object.
     * 
     * @return The value of the OperationId property for this object.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * The timestamp at which the operation was created
     * 
     * @return The timestamp at which the operation was created
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * The timestamp at which the operation finished for the application
     * 
     * @return The timestamp at which the operation finished for the application
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns the value of the OperationStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return The value of the OperationStatus property for this object.
     * @see OperationStatus
     */
    public final OperationStatus operationStatus() {
        return OperationStatus.fromValue(operationStatus);
    }

    /**
     * Returns the value of the OperationStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return The value of the OperationStatus property for this object.
     * @see OperationStatus
     */
    public final String operationStatusAsString() {
        return operationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationOperationInfo)) {
            return false;
        }
        ApplicationOperationInfo other = (ApplicationOperationInfo) obj;
        return Objects.equals(operation(), other.operation()) && Objects.equals(operationId(), other.operationId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(operationStatusAsString(), other.operationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationOperationInfo").add("Operation", operation()).add("OperationId", operationId())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("OperationStatus", operationStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "OperationStatus":
            return Optional.ofNullable(clazz.cast(operationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationOperationInfo, T> g) {
        return obj -> g.apply((ApplicationOperationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationOperationInfo> {
        /**
         * Sets the value of the Operation property for this object.
         *
         * @param operation
         *        The new value for the Operation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * Sets the value of the OperationId property for this object.
         *
         * @param operationId
         *        The new value for the OperationId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * The timestamp at which the operation was created
         * 
         * @param startTime
         *        The timestamp at which the operation was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * The timestamp at which the operation finished for the application
         * 
         * @param endTime
         *        The timestamp at which the operation finished for the application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * Sets the value of the OperationStatus property for this object.
         *
         * @param operationStatus
         *        The new value for the OperationStatus property for this object.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder operationStatus(String operationStatus);

        /**
         * Sets the value of the OperationStatus property for this object.
         *
         * @param operationStatus
         *        The new value for the OperationStatus property for this object.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder operationStatus(OperationStatus operationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String operation;

        private String operationId;

        private Instant startTime;

        private Instant endTime;

        private String operationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationOperationInfo model) {
            operation(model.operation);
            operationId(model.operationId);
            startTime(model.startTime);
            endTime(model.endTime);
            operationStatus(model.operationStatus);
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationStatus() {
            return operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        @Override
        public ApplicationOperationInfo build() {
            return new ApplicationOperationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
